/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.table.JBTable;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionActionStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdTimingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileStats", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;", "getFileStats", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;", "setFileStats", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;)V", "lastEditor", "Lcom/intellij/openapi/editor/Editor;", "getLastEditor", "()Lcom/intellij/openapi/editor/Editor;", "setLastEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "createTable", "Ljavax/swing/JPanel;", "Columns", "EditorEventListener", "FileStats", "intellij.c.clangd"})
public final class ClangdTimingsPanel
extends ClangdPanelBase {
    @Nullable
    private volatile Editor lastEditor;
    @Nullable
    private volatile FileStats fileStats;

    @Nullable
    public final Editor getLastEditor() {
        return this.lastEditor;
    }

    public final void setLastEditor(@Nullable Editor editor) {
        this.lastEditor = editor;
    }

    @Nullable
    public final FileStats getFileStats() {
        return this.fileStats;
    }

    public final void setFileStats(@Nullable FileStats fileStats) {
        this.fileStats = fileStats;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createTable(Project project) {
        void it;
        JPanel jPanel;
        JLabel fileLabel = new JLabel("File: ");
        AbstractTableModel tableModel2 = new AbstractTableModel(this){
            final /* synthetic */ ClangdTimingsPanel this$0;

            public int getRowCount() {
                Object object = this.this$0.getFileStats();
                return (object != null && (object = ((FileStats)object).getActions()) != null ? object.size() : 0) + 1;
            }

            public int getColumnCount() {
                return 5;
            }

            @Nullable
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object object;
                if (rowIndex == 0) {
                    int n = columnIndex;
                    return n == Columns.NAME.getIndex() ? "Action" : (n == Columns.AVERAGE.getIndex() ? "Avg." : (n == Columns.LAST.getIndex() ? "Last" : (n == Columns.TOTAL.getIndex() ? "Total" : (n == Columns.COUNT.getIndex() ? "Count" : null))));
                }
                int row = rowIndex - 1;
                int n = columnIndex;
                if (n == Columns.NAME.getIndex()) {
                    object = this.this$0.getFileStats();
                    if (object == null || (object = ((FileStats)object).getActions()) == null || (object = (ClionActionStats)object.get(row)) == null || (object = ((ClionActionStats)object).getName()) == null) {
                        object = "Impossible";
                    }
                } else {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    object = n == Columns.AVERAGE.getIndex() ? this.formatMs(this.average((object5 = this.this$0.getFileStats()) != null && (object5 = ((FileStats)object5).getActions()) != null ? (ClionActionStats)object5.get(row) : null)) : (n == Columns.LAST.getIndex() ? this.formatMs((object4 = this.this$0.getFileStats()) != null && (object4 = ((FileStats)object4).getActions()) != null && (object4 = (ClionActionStats)object4.get(row)) != null ? Long.valueOf(((ClionActionStats)object4).getLastTimeMs()) : null) : (n == Columns.TOTAL.getIndex() ? this.formatMs((object3 = this.this$0.getFileStats()) != null && (object3 = ((FileStats)object3).getActions()) != null && (object3 = (ClionActionStats)object3.get(row)) != null ? Long.valueOf(((ClionActionStats)object3).getTotalTimeMs()) : null) : (n == Columns.COUNT.getIndex() ? Integer.valueOf((object2 = this.this$0.getFileStats()) != null && (object2 = ((FileStats)object2).getActions()) != null && (object2 = (ClionActionStats)object2.get(row)) != null ? ((ClionActionStats)object2).getCounter() : 0) : null)));
                }
                return object;
            }

            @NotNull
            public final String formatMs(@Nullable Long time) {
                if (time == null) {
                    return "0 ms";
                }
                return time + " ms";
            }

            @NotNull
            public final String formatMs(double time) {
                String string = "%.2f";
                Object[] objectArray = new Object[]{time};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                return string2 + " ms";
            }

            public final double average(@Nullable ClionActionStats stats) {
                return stats == null ? 0.0 : (double)stats.getTotalTimeMs() / (double)stats.getCounter();
            }
            {
                this.this$0 = this$0;
            }
        };
        JBTable table = new JBTable((TableModel)tableModel2);
        table.setTableHeader(new JTableHeader());
        JButton button = new JButton("Refresh!");
        button.addActionListener(new ActionListener(this, project, fileLabel, table){
            final /* synthetic */ ClangdTimingsPanel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JLabel $fileLabel;
            final /* synthetic */ JBTable $table;

            public final void actionPerformed(ActionEvent it) {
                Editor editor = this.this$0.getLastEditor();
                if (editor == null) {
                    return;
                }
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
                if (ClangdBridge.isSupported(this.$project, virtualFile)) {
                    ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.$project);
                    if (virtualFile == null) {
                        return;
                    }
                    service.requestTimingStats(virtualFile).thenAccept(new Consumer(this){
                        final /* synthetic */ createTable.1 this$0;

                        public final void accept(ClionFileStats it) {
                            if (it == null) {
                                return;
                            }
                            Map<String, ClionActionStats> map = it.getActions();
                            Intrinsics.checkNotNull(map);
                            ArrayList<ClionActionStats> sortedActionsStats = new ArrayList<ClionActionStats>(map.values());
                            List $this$sortBy$iv = sortedActionsStats;
                            boolean $i$f$sortBy = false;
                            if ($this$sortBy$iv.size() > 1) {
                                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                                    public final int compare(T a, T b) {
                                        ClionActionStats it = (ClionActionStats)a;
                                        boolean bl = false;
                                        Comparable comparable = (Comparable)((Object)it.getName());
                                        it = (ClionActionStats)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        String string = it.getName();
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                                    }
                                });
                            }
                            ClangdTimingsPanel clangdTimingsPanel = this.this$0.this$0;
                            String string = it.getFileName();
                            Intrinsics.checkNotNull((Object)string);
                            clangdTimingsPanel.setFileStats(new FileStats(string, (List<ClionActionStats>)sortedActionsStats));
                            this.this$0.$fileLabel.setText("File: " + it.getFileName());
                            this.this$0.$table.updateUI();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = clangdTimingsPanel;
                this.$project = project;
                this.$fileLabel = jLabel;
                this.$table = jBTable;
            }
        });
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)button, "First");
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        JPanel jPanel3 = centerPanel;
        boolean bl = false;
        it.add((Component)fileLabel, "First");
        it.add((Component)table, "Center");
        Unit unit = Unit.INSTANCE;
        jPanel3.add((Component)jPanel, "Center");
        return centerPanel;
    }

    public ClangdTimingsPanel(@NotNull Project project) {
        this.add(this.createTable(project));
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener((FocusChangeListener)new EditorEventListener(), (Disposable)this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$Columns;", "", "index", "", "(Ljava/lang/String;II)V", "getIndex", "()I", "NAME", "AVERAGE", "LAST", "TOTAL", "COUNT", "intellij.c.clangd"})
    private static final class Columns
    extends Enum<Columns> {
        public static final /* enum */ Columns NAME;
        public static final /* enum */ Columns AVERAGE;
        public static final /* enum */ Columns LAST;
        public static final /* enum */ Columns TOTAL;
        public static final /* enum */ Columns COUNT;
        private static final /* synthetic */ Columns[] $VALUES;
        private final int index;

        static {
            Columns[] columnsArray = new Columns[5];
            Columns[] columnsArray2 = columnsArray;
            columnsArray[0] = NAME = new Columns(0);
            columnsArray[1] = AVERAGE = new Columns(1);
            columnsArray[2] = LAST = new Columns(2);
            columnsArray[3] = TOTAL = new Columns(3);
            columnsArray[4] = COUNT = new Columns(4);
            $VALUES = columnsArray;
        }

        public final int getIndex() {
            return this.index;
        }

        private Columns(int index) {
            this.index = index;
        }

        public static Columns[] values() {
            return (Columns[])$VALUES.clone();
        }

        public static Columns valueOf(String string) {
            return Enum.valueOf(Columns.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$EditorEventListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel;)V", "focusGained", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "intellij.c.clangd"})
    public final class EditorEventListener
    implements FocusChangeListener {
        public void focusGained(@NotNull Editor editor) {
            ClangdTimingsPanel.this.setLastEditor(editor);
        }

        public void focusLost(@NotNull Editor editor) {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;", "", "fileName", "", "actions", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionActionStats;", "(Ljava/lang/String;Ljava/util/List;)V", "getActions", "()Ljava/util/List;", "getFileName", "()Ljava/lang/String;", "intellij.c.clangd"})
    public static final class FileStats {
        @NotNull
        private final String fileName;
        @NotNull
        private final List<ClionActionStats> actions;

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final List<ClionActionStats> getActions() {
            return this.actions;
        }

        public FileStats(@NotNull String fileName, @NotNull List<ClionActionStats> actions) {
            this.fileName = fileName;
            this.actions = actions;
        }
    }
}

