/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.VersionUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionChecksDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyUpdateStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(ClangTidyUpdateStartupActivity.class);
    private static final int TIMEOUT_IN_MS = 30000;

    public void runActivity(final @NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !CommonClangTidyUtil.getBuiltinClangTidyPath().exists()) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, ClangdBundle.message("clang.tidy.check.for.update.task", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                ClangTidySettings settings = ClangTidySettings.getInstance();
                Version actualClangTidyVersion = ClangTidyUpdateStartupActivity.getActualClangTidyVersion(indicator);
                if (actualClangTidyVersion == null) {
                    return;
                }
                Version previousClangTidyVersion = VersionUtil.parseVersion((String)StringUtil.notNullize((String)settings.getPreviousClangTidyVersion()), (Pattern[])new Pattern[]{CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN});
                Pair<Set<String>, Set<String>> tidyAndMisraChecks = ClangTidyUpdateStartupActivity.getActualClangTidyChecks(indicator);
                if (tidyAndMisraChecks == null) {
                    return;
                }
                Set actualClangTidyChecks = (Set)tidyAndMisraChecks.first;
                Set<String> previousClangTidyChecks = settings.getPreviousClangTidyChecks();
                ClangTidyUpdateStartupActivity.showNotificationOnUpdate(actualClangTidyVersion, previousClangTidyVersion, actualClangTidyChecks, previousClangTidyChecks, project);
                settings.setPreviousClangTidyVersion(actualClangTidyVersion.toString());
                settings.setPreviousClangTidyChecks(actualClangTidyChecks);
                settings.setAvailableMisraChecks((Set)tidyAndMisraChecks.second);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static void showNotificationOnUpdate(@NotNull Version actualClangTidyVersion, @Nullable Version previousClangTidyVersion, @NotNull Set<String> actualClangTidyChecks, @Nullable Set<String> previousClangTidyChecks, final @NotNull Project project) {
        if (previousClangTidyVersion == null || previousClangTidyChecks == null) {
            return;
        }
        if (!ClangTidyUpdateStartupActivity.isVersionUpdated(actualClangTidyVersion, previousClangTidyVersion)) {
            return;
        }
        final HashSet<String> newChecks = new HashSet<String>(actualClangTidyChecks);
        newChecks.removeAll(previousClangTidyChecks);
        if (newChecks.isEmpty()) {
            return;
        }
        final ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(null, project);
        if (inspection == null) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Clang-Tidy Updated");
        Notification notification = notificationGroup.createNotification(ClangdBundle.message("clang.tidy.update.notification.title", new Object[0]), ClangTidyUpdateStartupActivity.getNotificationMessage(newChecks), NotificationType.INFORMATION);
        notification.addAction((AnAction)new DumbAwareAction(ClangdBundle.message("clang.tidy.update.review.new.checks.link", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                InspectionChecksDialog dialog = new InspectionChecksDialog(newChecks, inspection.getClangTidyChecks(), ClangdBundle.message("clang.tidy.update.new.checks.dialog.title", new Object[0]), inspection, true, Collections.emptyMap(), project);
                dialog.showAndGet();
            }
        });
        notification.notify(project);
    }

    @NotNull
    @NlsContexts.NotificationContent
    private static String getNotificationMessage(@NotNull Collection<String> newChecks) {
        int howManyChecks = newChecks.size() == 1 ? 1 : 2;
        return ClangdBundle.message("clang.tidy.update.notification.message", newChecks.size(), howManyChecks);
    }

    private static boolean isVersionUpdated(@NotNull Version actualClangTidyVersion, @NotNull Version previousClangTidyVersion) {
        return previousClangTidyVersion.compareTo(actualClangTidyVersion) <= 0;
    }

    @Nullable
    private static Version getActualClangTidyVersion(@NotNull ProgressIndicator indicator) {
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), "--version"});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 30000);
            return VersionUtil.parseVersion((String)output.getStdout().trim(), (Pattern[])new Pattern[]{CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN});
        }
        catch (Exception e) {
            LOG.warn("Cannot get Clang-Tidy version", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Pair<Set<String>, Set<String>> getActualClangTidyChecks(@NotNull ProgressIndicator indicator) {
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), "--checks=*", "--list-checks"});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 30000);
            String[] outputLines = StringUtil.splitByLines((String)output.getStdout());
            HashSet<String> checks = new HashSet<String>();
            HashSet<String> misraChecks = new HashSet<String>();
            for (String line : outputLines) {
                String trimmedLine = line.trim();
                if (StringUtil.isEmpty((String)trimmedLine)) continue;
                if (StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"clion-")) {
                    if (!StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"clion-misra-")) continue;
                    misraChecks.add(trimmedLine);
                    continue;
                }
                if (StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"Enabled checks:")) continue;
                checks.add(trimmedLine);
            }
            return Pair.create(checks, misraChecks);
        }
        catch (Exception e) {
            LOG.warn("Cannot get Clang-Tidy checks", (Throwable)e);
            return null;
        }
    }
}

