/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClangTidyStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(ClangTidyStartupActivity.class);
    private QueueProcessor<ScanEvent> queueProcessor = null;

    public void runActivity(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.doRunActivity(project);
    }

    public void doRunActivity(final @NotNull Project project) {
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        this.queueProcessor = new QueueProcessor(e -> ClangTidyStartupActivity.doScan(e));
        this.queueProcessor.add((Object)new ScanEvent(null, project));
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    ClangTidyStartupActivity.this.queueProcessor.add((Object)new ScanEvent(vFileEvent, project));
                }
            }
        });
    }

    @TestOnly
    public void waitForQueueProcessor() {
        this.queueProcessor.waitFor();
    }

    private static void doScan(@NotNull ScanEvent scanEvent) {
        VFileEvent fileEvent = scanEvent.myEvent;
        Project project = scanEvent.myProject;
        if (((Boolean)ReadAction.compute(() -> project.isDisposed())).booleanValue()) {
            return;
        }
        ClangTidyFilesState state = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        if (fileEvent == null) {
            String basePath = project.getBasePath();
            if (StringUtil.isEmpty((String)basePath)) {
                LOG.info("Cannot run ClangTidyStartupActivity since basePath is empty");
                return;
            }
            List<File> clangTidyFiles = ClangTidyStartupActivity.findClangTidyFiles(new File(basePath));
            state.setClangTidyFiles(clangTidyFiles);
            ClangTidyStartupActivity.dumpClangTidyFiles(state);
            return;
        }
        VirtualFile file = fileEvent.getFile();
        if (file == null) {
            LOG.debug("Cannot process VFileEvent: VirtualFile is null");
            return;
        }
        boolean hasChanges = false;
        if (fileEvent instanceof VFileDeleteEvent) {
            hasChanges = ClangTidyStartupActivity.removeFileOrDirectory(file.getPath(), file.isDirectory(), state);
        } else if (fileEvent instanceof VFileMoveEvent) {
            hasChanges = ClangTidyStartupActivity.removeFileOrDirectory(((VFileMoveEvent)fileEvent).getOldPath(), file.isDirectory(), state);
            hasChanges |= ClangTidyStartupActivity.addFileOrDirectory(file, state);
        } else if (fileEvent instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)fileEvent;
            if (propertyChangeEvent.getPropertyName().equals("name")) {
                hasChanges = ClangTidyStartupActivity.removeFileOrDirectory(propertyChangeEvent.getOldPath(), file.isDirectory(), state);
                hasChanges |= ClangTidyStartupActivity.addFileOrDirectory(file, state);
            }
        } else if (fileEvent instanceof VFileCreateEvent) {
            hasChanges = ClangTidyStartupActivity.addFileOrDirectory(file, state);
        } else if (fileEvent instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)fileEvent;
            VirtualFile createdFile = copyEvent.findCreatedFile();
            if (createdFile == null) {
                LOG.debug("Cannot process VFileEvent: created file is null");
                return;
            }
            hasChanges = ClangTidyStartupActivity.addFileOrDirectory(createdFile, state);
        }
        if (hasChanges) {
            ClangTidyStartupActivity.dumpClangTidyFiles(state);
        }
    }

    private static boolean addFileOrDirectory(@NotNull VirtualFile file, @NotNull ClangTidyFilesState state) {
        if (!file.isValid()) {
            LOG.debug("Cannot process VFileEvent: VirtualFile is not valid");
            return false;
        }
        if (file.isDirectory()) {
            List<VirtualFile> childFiles = ClangTidyStartupActivity.findClangTidyFiles(file);
            if (!childFiles.isEmpty()) {
                for (VirtualFile childFile : childFiles) {
                    state.addClangTidyFile(new File(childFile.getPath()));
                }
                return true;
            }
        } else if (ClangTidyStartupActivity.isClangTidyFile(file)) {
            state.addClangTidyFile(new File(file.getPath()));
            return true;
        }
        return false;
    }

    private static boolean removeFileOrDirectory(@NotNull String filePath, boolean isDirectory, @NotNull ClangTidyFilesState state) {
        File file = new File(filePath);
        if (!isDirectory && ClangTidyStartupActivity.isClangTidyFile(file)) {
            state.removeClangTidyFile(file);
            return true;
        }
        boolean hasChanges = false;
        List<File> clangTidyFiles = state.getClangTidyFiles();
        for (File clangTidyFile : clangTidyFiles) {
            if (!FileUtil.isAncestor((File)file, (File)clangTidyFile, (boolean)true)) continue;
            state.removeClangTidyFile(clangTidyFile);
            hasChanges = true;
        }
        return hasChanges;
    }

    @NotNull
    private static List<VirtualFile> findClangTidyFiles(@NotNull VirtualFile rootFile) {
        final ArrayList<VirtualFile> clangTidyFiles = new ArrayList<VirtualFile>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (ClangTidyStartupActivity.isClangTidyFile(file)) {
                    clangTidyFiles.add(file);
                }
                return CONTINUE;
            }
        });
        return clangTidyFiles;
    }

    @NotNull
    private static List<File> findClangTidyFiles(@NotNull File baseDir) {
        ArrayList<File> clangTidyFiles = new ArrayList<File>();
        ClangTidyStartupActivity.visitFilesIgnoringSymlinks(baseDir, (Processor<? super File>)((Processor)file -> {
            if (ClangTidyStartupActivity.isClangTidyFile(file)) {
                clangTidyFiles.add((File)file);
            }
            return true;
        }), true);
        for (File parentDirectory = baseDir.getParentFile(); parentDirectory != null; parentDirectory = parentDirectory.getParentFile()) {
            ClangTidyStartupActivity.visitFilesIgnoringSymlinks(parentDirectory, (Processor<? super File>)((Processor)file -> {
                if (ClangTidyStartupActivity.isClangTidyFile(file)) {
                    clangTidyFiles.add((File)file);
                }
                return true;
            }), false);
        }
        return clangTidyFiles;
    }

    private static boolean visitFilesIgnoringSymlinks(@NotNull File root, @NotNull Processor<? super File> processor, boolean recursive) {
        if (!processor.process((Object)root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!(child.isFile() ? !processor.process((Object)child) : child.isDirectory() && recursive && !Files.isSymbolicLink(child.toPath()) && !ClangTidyStartupActivity.visitFilesIgnoringSymlinks(child, processor, true))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isClangTidyFile(@NotNull VirtualFile file) {
        return file.getName().equals(".clang-tidy");
    }

    private static boolean isClangTidyFile(@NotNull File file) {
        return file.getName().equals(".clang-tidy");
    }

    private static void dumpClangTidyFiles(@NotNull ClangTidyFilesState state) {
        LOG.debug("Clang-Tidy files in project: [" + StringUtil.join(state.getClangTidyFiles(), (String)",") + "]");
    }

    private static class ScanEvent {
        VFileEvent myEvent;
        Project myProject;

        ScanEvent(@Nullable VFileEvent event, @NotNull Project project) {
            this.myEvent = event;
            this.myProject = project;
        }
    }
}

