/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesPaths;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyStatusBarWidgetFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangLanguageServiceStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangLanguageServiceStartupActivity.runStartupActivity(project);
    }

    public static void runStartupActivity(final @NotNull Project project) {
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            final ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
            if (provider2 == null) {
                return;
            }
            final ClangLanguageServiceProvider[] providers = new ClangLanguageServiceProvider[]{provider2};
            if (ClangUtils.isClangdOn(project)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(providers, project);
            }
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

                public void profileChanged(@NotNull InspectionProfile profile) {
                    StatusBarWidgetsManager manager = (StatusBarWidgetsManager)project.getService(StatusBarWidgetsManager.class);
                    if (manager != null) {
                        manager.updateWidget(ClangTidyStatusBarWidgetFactory.class);
                    }
                }
            });
            connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

                public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        ClangLanguageService indexer;
                        ClangLanguageService service;
                        if (project.isDisposed()) {
                            return;
                        }
                        if (ClangdBridge.isClangdOnlyMode() && (service = provider2.getIfStarted()) != null) {
                            service.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(project));
                        }
                        if ((indexer = provider2.getIfStartedIndexer()) != null) {
                            indexer.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(project));
                        }
                    });
                }
            });
            connection.subscribe(ClangdSettingsListener.TOPIC, (Object)new MyClangdSettingsListener(project, providers));
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                    boolean isDocumentSaved = !FileDocumentManager.getInstance().isDocumentUnsaved(event.getDocument());
                    for (ClangLanguageServiceProvider provider2 : providers) {
                        ClangLanguageService indexer;
                        if (file == null) continue;
                        ClangLanguageService service = provider2.getIfStarted();
                        if (service != null) {
                            service.notifyDocumentChanged(file, event);
                            if (isDocumentSaved) {
                                service.notifyDocumentSaved(file);
                            }
                        }
                        if ((indexer = provider2.getIfStartedIndexer()) == null) continue;
                        indexer.notifyDocumentChanged(file, event);
                        if (!isDocumentSaved) continue;
                        indexer.notifyDocumentSaved(file);
                    }
                }
            }, (Disposable)project);
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorCreated(@NotNull EditorFactoryEvent event) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                    if (file != null) {
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService indexer;
                            ClangLanguageService service = provider2.getIfStarted();
                            if (service != null) {
                                service.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                            }
                            if ((indexer = provider2.getIfStartedIndexer()) == null) continue;
                            indexer.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                    if (file != null) {
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService indexer;
                            ClangLanguageService service = provider2.getIfStarted();
                            if (service != null) {
                                service.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                            }
                            if ((indexer = provider2.getIfStartedIndexer()) == null) continue;
                            indexer.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }
            }, (Disposable)project);
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file;
                        VFileMoveEvent event;
                        if (vFileEvent instanceof VFileMoveEvent) {
                            event = (VFileMoveEvent)vFileEvent;
                            file = event.getFile();
                            String oldUrl = event.getOldParent().getUrl() + "/" + file.getName();
                            String newUrl = file.getUrl();
                            for (ClangLanguageServiceProvider provider2 : providers) {
                                ClangLanguageService indexer;
                                ClangLanguageService service = provider2.getIfStarted();
                                if (service != null) {
                                    service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                                }
                                if ((indexer = provider2.getIfStarted()) == null) continue;
                                indexer.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                            }
                            continue;
                        }
                        if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                            event = (VFilePropertyChangeEvent)vFileEvent;
                            if (Objects.equals(event.getNewValue(), event.getOldValue())) continue;
                            String newName = (String)event.getNewValue();
                            String newUrl = event.getFile().getUrl();
                            assert (newUrl.endsWith(newName));
                            String oldName = (String)event.getOldValue();
                            String oldUrl = newUrl.substring(0, newUrl.length() - newName.length()) + oldName;
                            for (ClangLanguageServiceProvider provider3 : providers) {
                                ClangLanguageService indexer;
                                ClangLanguageService service = provider3.getIfStarted();
                                if (service != null) {
                                    service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                                }
                                if ((indexer = provider3.getIfStarted()) == null) continue;
                                indexer.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                            }
                            continue;
                        }
                        if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        event = (VFileContentChangeEvent)vFileEvent;
                        if (!vFileEvent.isFromSave()) continue;
                        file = event.getFile();
                        for (ClangLanguageServiceProvider provider4 : providers) {
                            ClangLanguageService indexer;
                            ClangLanguageService service = provider4.getIfStarted();
                            if (service != null) {
                                service.notifyDocumentSaved(file);
                            }
                            if ((indexer = provider4.getIfStartedIndexer()) == null) continue;
                            indexer.notifyDocumentSaved(file);
                        }
                    }
                }
            });
            connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

                public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                    this.selectedResolveConfigurationChanged();
                }

                public void selectedResolveConfigurationChanged() {
                    @Nullable ClangLanguageService langService = provider2.getIfStarted();
                    if (langService == null) {
                        return;
                    }
                    String wslMsId = ClangUtils.getCurrentWslMsId(project);
                    if (langService.getWslMsId() != wslMsId) {
                        ClangLanguageServiceProvider[] providers = new ClangLanguageServiceProvider[]{provider2};
                        ClangLanguageServiceStartupActivity.stopLanguageServices(providers);
                        ClangLanguageServiceStartupActivity.initLanguageServices(providers, project);
                    }
                }
            });
        });
    }

    private static void initLanguageServices(ClangLanguageServiceProvider @NotNull [] providers, @NotNull Project project) {
        for (ClangLanguageServiceProvider provider2 : providers) {
            File symbolsDir;
            final ClangLanguageService service = provider2.getOrStart();
            ClangLanguageService indexer = provider2.getOrStartIndexer();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (project.isDisposed()) {
                    return;
                }
                ReadAction.run(() -> {
                    ClangLanguageServiceStartupActivity.openAtService(project, service);
                    ClangLanguageServiceStartupActivity.openAtService(project, indexer);
                });
                Set<VirtualFile> projectRoots = ClangLanguageServiceStartupActivity.getProjectRoots(project);
                if (!projectRoots.isEmpty()) {
                    if (service.isActive() && ClangdBridge.isClangdOnlyMode()) {
                        service.notifySetCDB(projectRoots);
                    }
                    if (indexer.isActive()) {
                        indexer.notifySetCDB(projectRoots);
                    }
                }
            });
            if (indexer.isDummy()) continue;
            File includeGraphFile = Paths.get(service.getClangdModulesPath(), "compilation_graph.txt").toFile();
            if (includeGraphFile.exists()) {
                service.notifyLoadGraph(includeGraphFile.getPath());
            }
            if ((symbolsDir = Paths.get(service.getClangdModulesPath(), "symbols").toFile()).exists()) {
                service.notifyLoadIndex(Collections.emptyList(), symbolsDir.getPath());
            }
            indexer.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

                @Override
                public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                    service.notifyLoadIndex(deletedSymbolsPaths, symbolsDirPath);
                }

                @Override
                public void onGraphFinished(@NotNull String path) {
                    service.notifyLoadGraph(path);
                }

                @Override
                public void onIndexPartFinished(@NotNull String path) {
                    service.notifyIndexPartFinished(path);
                }
            });
        }
    }

    private static Set<VirtualFile> getProjectRoots(@NotNull Project project) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            sources.addAll(config.getSources());
        }
        return sources;
    }

    private static void openAtService(@NotNull Project project, @NotNull ClangLanguageService service) {
        if (project.isDisposed()) {
            return;
        }
        if (!service.isActive()) {
            return;
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject != project || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
            service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
        }
        Cpp20Modules modules = ClangLanguageServiceStartupActivity.findCpp20Modules(project, service);
        if (!modules.cppModName2Source.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> modNameAndFile : modules.cppModName2Source.entrySet()) {
                sb.append("module ").append(modNameAndFile.getKey()).append(" {\n");
                sb.append("  header \"").append(modNameAndFile.getValue()).append("\"\n");
                sb.append("}\n");
            }
            service.notifyDocumentChanged(VirtualFileManager.constructUrl((String)"file", (String)modules.paths.moduleMapPath), sb.toString());
            service.getClangIdeFacade().enableCpp20Modules(modules.paths.moduleMapPath, modules.paths.modulesCachePath);
        }
    }

    private static void stopLanguageServices(ClangLanguageServiceProvider @NotNull [] providers) {
        for (ClangLanguageServiceProvider provider2 : providers) {
            provider2.stop();
            provider2.stopIndexer();
        }
    }

    @NotNull
    private static Cpp20Modules findCpp20Modules(@NotNull Project project, @NotNull ClangLanguageService service) {
        if (!Registry.is((String)"clion.clang.clangd.enable.cpp20.modules")) {
            return new Cpp20Modules(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), new Cpp20ModulesPaths("", ""));
        }
        ClangUrlConverter converter = service.getUrlConverter();
        ArrayList<String> cppModuleNames = new ArrayList<String>();
        ArrayList<ClionCompileCommandParams> cppModuleCompileCommands = new ArrayList<ClionCompileCommandParams>();
        HashMap<String, String> cppModName2Source = new HashMap<String, String>();
        String moduleMapPath = SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/cpp20/module.modulemap" : "/clion_clangd_inmemory_directory/cpp20/module.modulemap";
        String cpp20ModulesPath = service.getCpp20ModulesPath();
        Cpp20ModulesPaths cpp20Paths = new Cpp20ModulesPaths(moduleMapPath, cpp20ModulesPath);
        Pattern exportModulePattern = Pattern.compile("export\\s+module\\s+\\w+\\s*;");
        List<File> cpp20Modules = ClangLanguageServiceStartupActivity.findCpp20ModuleFiles(new File(project.getBasePath()));
        for (File path : cpp20Modules) {
            Matcher m;
            Document document;
            VirtualFile srcFile = VfsUtil.findFileByIoFile((File)path, (boolean)false);
            if (srcFile == null || (document = FileDocumentManager.getInstance().getDocument(srcFile)) == null || !(m = exportModulePattern.matcher(document.getText())).find()) continue;
            String line = m.group(0);
            @NotNull List parts = StringUtil.split((String)StringUtil.trimEnd((String)line, (String)";"), (String)" ");
            String modName = (String)parts.get(parts.size() - 1);
            cppModName2Source.put(modName, srcFile.getPath());
        }
        return new Cpp20Modules(cppModuleNames, cppModuleCompileCommands, cppModName2Source, cpp20Paths);
    }

    @NotNull
    private static List<File> findCpp20ModuleFiles(@NotNull File baseDir) {
        ArrayList<File> clangTidyFiles = new ArrayList<File>();
        ClangLanguageServiceStartupActivity.visitFilesIgnoringSymlinks(baseDir, (Processor<? super File>)((Processor)file -> {
            if (ClangLanguageServiceStartupActivity.isCpp20ModuleFile(file)) {
                clangTidyFiles.add((File)file);
            }
            return true;
        }), true);
        for (File parentDirectory = baseDir.getParentFile(); parentDirectory != null; parentDirectory = parentDirectory.getParentFile()) {
            ClangLanguageServiceStartupActivity.visitFilesIgnoringSymlinks(parentDirectory, (Processor<? super File>)((Processor)file -> {
                if (ClangLanguageServiceStartupActivity.isCpp20ModuleFile(file)) {
                    clangTidyFiles.add((File)file);
                }
                return true;
            }), false);
        }
        return clangTidyFiles;
    }

    private static boolean visitFilesIgnoringSymlinks(@NotNull File root, @NotNull Processor<? super File> processor, boolean recursive) {
        if (!processor.process((Object)root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!(child.isFile() ? !processor.process((Object)child) : child.isDirectory() && recursive && !Files.isSymbolicLink(child.toPath()) && !ClangLanguageServiceStartupActivity.visitFilesIgnoringSymlinks(child, processor, true))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isCpp20ModuleFile(@NotNull File file) {
        return file.getName().endsWith(".ixx") || file.getName().endsWith(".cppm");
    }

    private static class MyClangdSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;
        private final ClangLanguageServiceProvider @NotNull [] myProviders;

        MyClangdSettingsListener(@NotNull Project project, ClangLanguageServiceProvider @NotNull [] providers) {
            this.myProject = project;
            this.myProviders = providers;
        }

        @Override
        public void onClangdOnChanged(boolean value) {
            if (ClangUtils.isClangdOn(this.myProject)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(this.myProviders, this.myProject);
            } else {
                ClangLanguageServiceStartupActivity.stopLanguageServices(this.myProviders);
            }
        }
    }

    private static class Cpp20Modules {
        @NotNull
        final List<String> cppModuleNames;
        @NotNull
        final List<ClionCompileCommandParams> cppModuleCompileCommands;
        @NotNull
        final Map<String, String> cppModName2Source;
        @NotNull
        final Cpp20ModulesPaths paths;

        private Cpp20Modules(@NotNull List<String> cppModuleNames, @NotNull List<ClionCompileCommandParams> cppModuleCompileCommands, @NotNull Map<String, String> cppModName2Source, @NotNull Cpp20ModulesPaths paths) {
            this.cppModuleNames = cppModuleNames;
            this.cppModuleCompileCommands = cppModuleCompileCommands;
            this.cppModName2Source = cppModName2Source;
            this.paths = paths;
        }
    }
}

