/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyFilesStateImpl
implements ClangTidyFilesState {
    private final Map<Integer, File> clangTidyFilesMap = new HashMap<Integer, File>();

    @Override
    @NotNull
    public synchronized List<File> getClangTidyFiles() {
        return ContainerUtil.immutableList(new ArrayList<File>(this.clangTidyFilesMap.values()));
    }

    @Override
    @Nullable
    public synchronized File findNearestClangTidyFile(@NotNull File file) {
        File directory;
        File file2 = directory = file.isDirectory() ? file : file.getParentFile();
        while (directory != null) {
            File clangTidyFile = this.clangTidyFilesMap.get(ClangTidyFilesStateImpl.getHashCode(directory));
            if (clangTidyFile != null) {
                return clangTidyFile;
            }
            directory = directory.getParentFile();
        }
        return null;
    }

    @Override
    public synchronized void setClangTidyFiles(@NotNull List<File> clangTidyFiles) {
        this.clangTidyFilesMap.clear();
        for (File clangTidyFile : clangTidyFiles) {
            this.processClangTidyFile(clangTidyFile);
        }
    }

    @Override
    public synchronized void addClangTidyFile(@NotNull File clangTidyFile) {
        this.processClangTidyFile(clangTidyFile);
    }

    @Override
    public synchronized void removeClangTidyFile(@NotNull File clangTidyFile) {
        File parentDirectory = clangTidyFile.getParentFile();
        if (parentDirectory != null) {
            this.clangTidyFilesMap.remove(ClangTidyFilesStateImpl.getHashCode(parentDirectory));
        }
    }

    @Override
    public synchronized boolean hasClangTidyFilesInPath(@NotNull File file) {
        return this.findNearestClangTidyFile(file) != null;
    }

    private void processClangTidyFile(@NotNull File clangTidyFile) {
        File parentDirectory = clangTidyFile.getParentFile();
        if (parentDirectory != null) {
            this.clangTidyFilesMap.put(ClangTidyFilesStateImpl.getHashCode(parentDirectory), clangTidyFile);
        }
    }

    private static int getHashCode(@NotNull File file) {
        return FileUtil.fileHashCode((File)file);
    }
}

