/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageServiceReparsingPassFactory
implements DirtyScopeTrackingHighlightingPassFactory {
    private final int myPassId;

    public OCLanguageServiceReparsingPassFactory(@NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myPassId = highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 4, false, false);
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (!ClangdBridge.isSupported(file.getProject(), file.getVirtualFile())) {
            return null;
        }
        if (FileStatusMap.getDirtyTextRange((Editor)editor, (int)this.myPassId) == null) {
            return null;
        }
        return new OCLanguageServiceReparsingPass(file.getProject(), file, editor.getDocument());
    }
}

