/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPassListener;
import org.jetbrains.annotations.NotNull;

public final class OCLanguageServiceReparsingPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)OCLanguageServiceReparsingPass.class.getName());
    @NotNull
    private final PsiFile myFile;

    public OCLanguageServiceReparsingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document) {
        super(project, document);
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (!ClangAnnotatorUtil.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            LOG.warn("Unsupported PSI file: " + this.myFile.getName());
            return;
        }
        ((OCLanguageServiceReparsingPassListener)this.myProject.getMessageBus().syncPublisher(OCLanguageServiceReparsingPassListener.TOPIC)).onReparsing(this.myFile);
    }

    public void doApplyInformationToEditor() {
    }
}

