/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WorkspaceFileImpl
implements WorkspaceFile {
    @NotNull
    @NlsSafe
    private final String myUrl;
    @NotNull
    private final WorkspaceFileListener myListener;
    @NotNull
    private final Map<WorkspaceFile.Key<?>, Object> myData = new HashMap();

    protected WorkspaceFileImpl(@NlsSafe @NotNull String url, @NotNull WorkspaceFileListener listener) {
        this.myUrl = url;
        this.myListener = listener;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    @NotNull
    public Set<WorkspaceFile.Key<?>> keys() {
        return this.myData.keySet();
    }

    @Override
    public <T> T get(@NotNull WorkspaceFile.Key<T> key) {
        return (T)this.myData.get(key);
    }

    @Override
    public <T> T getOrDefault(@NotNull WorkspaceFile.Key<T> key) {
        if (this.hasKey(key)) {
            return this.get(key);
        }
        T result = key.createDefaultValue();
        this.put(key, result);
        return result;
    }

    @Override
    public <T> void put(@NotNull WorkspaceFile.Key<T> key, T data) {
        this.myData.put(key, data);
        this.myListener.onChanged(this.getUrl(), key, data);
    }

    @Override
    public boolean hasKey(@NotNull WorkspaceFile.Key<?> key) {
        return this.myData.containsKey(key);
    }
}

