/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingRequestsStorage;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalWorkspaceFileImpl
extends WorkspaceFileImpl
implements LocalWorkspaceFile {
    private static final int FILE_INITIAL_VERSION = 2;
    @NotNull
    private static final WorkspaceFile.Key<Integer> VERSION = new WorkspaceFile.Key<Integer>("WorkspaceFileVersion", () -> -1);
    @NotNull
    private static final WorkspaceFile.Key<Integer> PREAMBLE_VERSION = new WorkspaceFile.Key<Integer>("WorkspaceFilePreambleVersion", () -> -1);
    @NotNull
    private static final WorkspaceFile.Key<Integer> PREAMBLE_BOUNDS = new WorkspaceFile.Key<Integer>("WorkspaceFilePreambleBounds", () -> 0);
    @NotNull
    private static final WorkspaceFile.Key<Boolean> IS_OPENED = new WorkspaceFile.Key<Boolean>("WorkspaceFileIsOpened", () -> false);
    @NotNull
    static final WorkspaceFile.Key<PendingRequestsStorage> REQUESTS_STORAGE = new WorkspaceFile.Key("REQUESTS_STORAGE");
    @NotNull
    private final AtomicLong myGlobalVersionCounter;
    @NotNull
    private final ClangUrlConverter myConverter;
    private int myMaxSizeOfPending;

    LocalWorkspaceFileImpl(@NotNull String url, @NotNull AtomicLong globalVersionCounter, @NotNull ClangUrlConverter converter, @NotNull WorkspaceFileListener wfListener, @NotNull PendingParseListener ppListener) {
        super(url, wfListener);
        this.myGlobalVersionCounter = globalVersionCounter;
        this.myConverter = converter;
        this.put(REQUESTS_STORAGE, new PendingRequestsStorage(ppListener));
    }

    @Override
    public int getVersion() {
        return this.getOrDefault(VERSION);
    }

    @Override
    public int getPreambleVersion() {
        return this.getOrDefault(PREAMBLE_VERSION);
    }

    @Override
    public int getPreambleBounds() {
        return this.getOrDefault(PREAMBLE_BOUNDS);
    }

    @Override
    public int preambleChanged(int preambleBounds) {
        int nextPreambleVersion = LocalWorkspaceFileImpl.incVersion(this.getOrDefault(PREAMBLE_VERSION));
        this.put(PREAMBLE_VERSION, nextPreambleVersion);
        this.put(PREAMBLE_BOUNDS, preambleBounds);
        return nextPreambleVersion;
    }

    @Override
    public int nextOpen() {
        this.put(IS_OPENED, true);
        return this.nextVersionImpl();
    }

    @Override
    public int nextChange() {
        return this.nextVersionImpl();
    }

    @Override
    public int nextClose() {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        files.clearLast();
        this.put(IS_OPENED, false);
        return this.nextVersionImpl();
    }

    @Override
    public int nextDelete() {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        files.clearLast();
        this.put(IS_OPENED, false);
        return this.nextVersionImpl();
    }

    @Override
    @NotNull
    public ClangParseResponse nextParse(@Nullable VirtualFile virtualFile, boolean cancellable) {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        ClangParseResponseImpl nextFile = this.createNextParseRequest(files, this.getUrl(), cancellable);
        if (virtualFile != null) {
            nextFile.putUserData(ClangParseResponse.MODIFICATION_STAMP, virtualFile.getModificationStamp());
            nextFile.putUserData(ClangParseResponse.MODIFICATION_COUNT, virtualFile.getModificationCount());
        }
        return nextFile;
    }

    private int nextVersionImpl() {
        int newVersion = LocalWorkspaceFileImpl.incVersion(this.getOrDefault(VERSION));
        this.put(VERSION, newVersion);
        return newVersion;
    }

    @Override
    public boolean isOpened() {
        return this.getOrDefault(IS_OPENED);
    }

    @Override
    @Nullable
    public ClangParseResponse getLastParseResponse() {
        return this.getOrDefault(REQUESTS_STORAGE).getLast();
    }

    @Override
    @Nullable
    public ClangParseResponse getPendingParseResponse(int version) {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        ClangParseResponseImpl lastResponse = files.getLast();
        if (lastResponse != null && lastResponse.getVersion() == version) {
            return lastResponse;
        }
        Ref found = Ref.create();
        files.forEachPending(pending -> {
            if (pending.getVersion() == version) {
                found.set(pending);
                return false;
            }
            return true;
        });
        return (ClangParseResponse)found.get();
    }

    @Override
    public int getMaxSizeOfPendingParsesQueue() {
        return this.myMaxSizeOfPending;
    }

    @Override
    public void forEachPendingParse(@NotNull Predicate<ClangParseResponse> consumer) {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        files.forEachPending(consumer);
    }

    @NotNull
    private ClangParseResponseImpl createNextParseRequest(@NotNull PendingRequestsStorage files, @NotNull String url, boolean cancellable) {
        ClangParseResponseImpl nextFile = new ClangParseResponseImpl(url, VfsUtilCore.urlToPath((String)url), this.nextVersionImpl(), this.getPreambleVersion(), cancellable);
        files.onParse(nextFile);
        int newSize = files.sizeOfPending();
        if (this.myMaxSizeOfPending < newSize) {
            this.myMaxSizeOfPending = newSize;
        }
        return nextFile;
    }

    private static int incVersion(int version) {
        if (version == -1) {
            return 2;
        }
        return version + 1;
    }
}

