/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.sourceglider.contextSensitive.DFATuple;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface ClangParseResponse
extends UserDataHolderEx {
    public static final Key<Set<String>> UNSAVED_FILES = new Key("UnsavedFiles");
    public static final Key<Long> MODIFICATION_STAMP = new Key("ModificationStamp");
    public static final Key<Long> MODIFICATION_COUNT = new Key("ModificationCount");
    public static final Key<Long> PSI_GLOBAL_MODIFICATION_COUNTER = new Key("PsiGlobalModificationCounter");
    public static final Key<Long> PROFILE_MODIFICATION_COUNTER = new Key("ProfileModificationCounter");
    public static final Key<Trustworthiness> TRUSTWORTHINESS = new Key("Trustworthiness");

    @NotNull
    public String getUrl();

    public int getVersion();

    public int getPreambleVersion();

    public boolean isCancellable();

    @NotNull
    public CompletableFuture<Boolean> getOperationState();

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getClazyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<DFATuple>>> getDFAInput();

    @NotNull
    public CompletableFuture<Boolean> getCompletionCacheReady();

    @NotNull
    default public Trustworthiness getTrustworthiness() {
        Trustworthiness trustworthiness = (Trustworthiness)this.getUserData(TRUSTWORTHINESS);
        return trustworthiness != null ? trustworthiness : new Trustworthiness();
    }

    public static boolean isInDoneState(@NotNull ClangParseResponse file) {
        return file.getOperationState().isDone();
    }

    public static boolean isInFinishedState(@NotNull ClangParseResponse file) {
        try {
            return ClangParseResponse.isInDoneState(file) && file.getOperationState().get() != false;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)"How can this happen?!");
        }
    }

    public static boolean isInFailedState(@NotNull ClangParseResponse file) {
        try {
            return ClangParseResponse.isInDoneState(file) && file.getOperationState().get() == false;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)"How can this happen?!");
        }
    }

    public static CompletableFuture<?>[] getAllAnswers(@NotNull ClangParseResponse file) {
        return new CompletableFuture[]{file.getDiagnostics(), file.getHighlightings(), file.getCompletionCacheReady(), file.getDFAInput(), file.getOurTidyDiagnostics(), file.getTidyDiagnostics(), file.getClazyDiagnostics()};
    }

    public static void completeAnswers(@NotNull ClangParseResponse file) {
        for (CompletableFuture<?> future : ClangParseResponse.getAllAnswers(file)) {
            if (future.isDone()) continue;
            future.complete(null);
        }
    }

    public static void completeAnswersExceptionally(@NotNull ClangParseResponse file, @NotNull Throwable ex) {
        for (CompletableFuture<?> future : ClangParseResponse.getAllAnswers(file)) {
            if (future.isDone()) continue;
            future.completeExceptionally(ex);
        }
    }

    public static boolean didAnswersCome(@NotNull ClangParseResponse file) {
        CompletableFuture<?>[] answers;
        for (CompletableFuture<?> answer : answers = ClangParseResponse.getAllAnswers(file)) {
            if (answer.isDone() && !answer.isCompletedExceptionally()) continue;
            return false;
        }
        return true;
    }

    public static boolean areAnswersCompleted(@NotNull ClangParseResponse file) {
        CompletableFuture<?>[] answers;
        for (CompletableFuture<?> answer : answers = ClangParseResponse.getAllAnswers(file)) {
            if (answer.isDone()) continue;
            return false;
        }
        return true;
    }
}

