/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.memory;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangMemoryUsagePanel
extends JButton
implements CustomStatusBarWidget,
Activatable {
    public static final String WIDGET_ID = "ClangdMemory";
    private static final Color USED_COLOR = new JBColor((Color)Gray._185, (Color)Gray._110);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String mySample;
    private volatile long myLastReported = 0L;
    private volatile long myShown = 0L;
    private volatile long myLastLimit = 0L;
    private volatile long myLimitShown = 0L;
    private volatile long myLastAvgUsed = 0L;
    private volatile long myLastAvgUsedShown = 0L;
    private volatile long myLastMaxUsed = 0L;
    private volatile long myLastMaxUsedShown = 0L;
    private volatile long myIndexerLastReported = 0L;
    private volatile long myIndexerShown = 0L;
    private volatile long myIndexerLastLimit = 0L;
    private volatile long myIndexerLimitShown = 0L;
    private volatile long myIndexerLastAvgUsed = 0L;
    private volatile long myIndexerLastAvgUsedShown = 0L;
    private volatile long myIndexerLastMaxUsed = 0L;
    private volatile long myIndexerLastMaxUsedShown = 0L;
    private BufferedImage myBufferedImage;
    private boolean myWasPressed;

    public ClangMemoryUsagePanel(@NotNull Project project) {
        ClangLanguageService indexerService;
        ClangLanguageService mainService;
        this.myProject = project;
        this.mySample = ClangdBundle.message("language.cpp.clangd.memory.usage.message", 99999, 99999);
        this.setOpaque(false);
        this.setFocusable(false);
        ClangLanguageServiceProvider clangServiceProvider = ClangLanguageServiceProvider.getProvider(this.myProject);
        this.addActionListener(e -> ClangLanguageServiceProvider.getIfStarted(clangServiceProvider).shutDownServer());
        this.setBorder(JBUI.CurrentTheme.StatusBar.Widget.border());
        this.updateToolTip();
        this.updateUI();
        new UiNotifyConnector((Component)this, (Activatable)this);
        project.getMessageBus().connect().subscribe(ClangLanguageServiceProviderListener.TOPIC, (Object)new ClangLanguageServiceProviderListener(){

            @Override
            public void onServiceStarted(@NotNull ClangLanguageService service) {
                if (!service.isIndexer()) {
                    service.getMessageBus().connect(service.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new MainListener());
                } else {
                    service.getMessageBus().connect(service.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new IndexerListener());
                }
            }
        });
        ClangLanguageService clangLanguageService = mainService = clangServiceProvider != null ? clangServiceProvider.getIfStarted() : null;
        if (mainService != null && mainService.isActive()) {
            mainService.getMessageBus().connect(mainService.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new MainListener());
        }
        ClangLanguageService clangLanguageService2 = indexerService = clangServiceProvider != null ? clangServiceProvider.getIfStartedIndexer() : null;
        if (indexerService != null && indexerService.isActive()) {
            indexerService.getMessageBus().connect(indexerService.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new IndexerListener());
        }
        this.setVisible(true);
        this.revalidate();
    }

    public void showNotify() {
        this.updateState();
    }

    public void dispose() {
        this.myBufferedImage = null;
    }

    public void install(@NotNull StatusBar statusBar) {
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    @Override
    public void updateUI() {
        this.myBufferedImage = null;
        super.updateUI();
        this.setFont(ClangMemoryUsagePanel.getWidgetFont());
    }

    private static Font getWidgetFont() {
        return JBUI.Fonts.label((float)11.0f);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean pressed = this.getModel().isPressed();
        boolean stateChanged = this.myWasPressed != pressed;
        this.myWasPressed = pressed;
        if (this.myBufferedImage == null || stateChanged) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            this.myBufferedImage = ImageUtil.createImage((Graphics)g, (int)size.width, (int)size.height, (int)2);
            Graphics2D g2 = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)this.myBufferedImage.createGraphics());
            UISettings.setupAntialiasing((Graphics)g2);
            g2.setFont(this.getFont());
            int textHeight = g2.getFontMetrics().getAscent();
            boolean disabled = this.myLimitShown <= 0L;
            long maxMem = disabled ? 0L : this.myLimitShown;
            long usedMem = disabled ? 0L : this.myShown;
            int usedBarLength = disabled ? 0 : (int)((long)size.width * usedMem / maxMem);
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(0, 0, size.width, size.height);
            g2.setColor(USED_COLOR);
            g2.fillRect(0, 0, usedBarLength, size.height);
            g2.setColor(pressed ? UIUtil.getLabelDisabledForeground() : JBColor.foreground());
            String text = ClangdBundle.message("language.cpp.clangd.memory.usage.message", usedMem / 0x100000L, maxMem / 0x100000L);
            int textX = insets.left;
            int textY = insets.top + (size.height - insets.top - insets.bottom - textHeight) / 2 + textHeight - JBUIScale.scale((int)1);
            g2.drawString(text, textX, textY);
            g2.dispose();
        }
        StartupUiUtil.drawImage((Graphics)g, (Image)this.myBufferedImage, (int)0, (int)0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics metrics = this.getFontMetrics(ClangMemoryUsagePanel.getWidgetFont());
        Insets insets = this.getInsets();
        int width = metrics.stringWidth(this.mySample) + insets.left + insets.right + JBUIScale.scale((int)2);
        int height = metrics.getHeight() + insets.top + insets.bottom + JBUIScale.scale((int)2);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void updateState() {
        if (this.myLastReported != this.myShown || this.myLastAvgUsed != this.myLastAvgUsedShown || this.myLastMaxUsed != this.myLastMaxUsedShown || this.myLastLimit != this.myLimitShown || this.myIndexerLastReported != this.myIndexerShown || this.myIndexerLastLimit != this.myIndexerLimitShown || this.myIndexerLastAvgUsed != this.myIndexerLastAvgUsedShown || this.myIndexerLastMaxUsed != this.myIndexerLastMaxUsedShown) {
            this.myShown = this.myLastReported;
            this.myLimitShown = this.myLastLimit;
            this.myLastAvgUsedShown = this.myLastAvgUsed;
            this.myLastMaxUsedShown = this.myLastMaxUsed;
            this.myIndexerShown = this.myIndexerLastReported;
            this.myIndexerLimitShown = this.myIndexerLastLimit;
            this.myIndexerLastAvgUsedShown = this.myIndexerLastAvgUsed;
            this.myIndexerLastMaxUsedShown = this.myIndexerLastMaxUsed;
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myBufferedImage = null;
                this.repaint();
            });
            this.updateToolTip();
        }
    }

    private void updateToolTip() {
        HtmlBuilder tooltip = new HtmlBuilder();
        tooltip.append(ClangdBundle.message("language.cpp.clangd.memory.usage.tooltip.message", this.myShown / 0x100000L, this.myLimitShown / 0x100000L, this.myLastAvgUsedShown / 0x100000L, this.myLastMaxUsedShown / 0x100000L));
        if (Registry.is((String)"clion.clang.clangd.index.on")) {
            tooltip.br();
            tooltip.append(ClangdBundle.message("language.cpp.clangd.indexer.memory.usage.tooltip.message", this.myIndexerShown / 0x100000L, this.myIndexerLimitShown / 0x100000L, this.myIndexerLastAvgUsedShown / 0x100000L, this.myIndexerLastMaxUsedShown / 0x100000L));
        }
        this.setToolTipText(tooltip.toString());
    }

    private class IndexerListener
    implements ClangMemoryUsageWatchDogListener {
        private IndexerListener() {
        }

        @Override
        public void onMaxMemoryChanged(long maxMemory) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!ClangMemoryUsagePanel.this.myProject.isDisposed()) {
                    ClangMemoryUsagePanel.this.myIndexerLastLimit = maxMemory;
                    if (ClangMemoryUsagePanel.this.isShowing()) {
                        ClangMemoryUsagePanel.this.updateState();
                    }
                }
            });
        }

        @Override
        public void onUsedMemoryChanged(long usedMemory) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!ClangMemoryUsagePanel.this.myProject.isDisposed()) {
                    ClangMemoryUsagePanel.this.myIndexerLastReported = usedMemory;
                    ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(ClangMemoryUsagePanel.this.myProject);
                    if (provider2 == null) {
                        return;
                    }
                    ClangLanguageService indexer = provider2.getIfStartedIndexer();
                    if (indexer == null) {
                        return;
                    }
                    ClangMemoryUsageWatchDog memoryUsageWatchDog = indexer.getMemoryUsageWatchDog();
                    if (memoryUsageWatchDog != null) {
                        ClangMemoryUsagePanel.this.myIndexerLastLimit = memoryUsageWatchDog.getMaxMemory();
                        ClangMemoryUsagePanel.this.myIndexerLastAvgUsed = memoryUsageWatchDog.getUsedAverageMemory();
                        ClangMemoryUsagePanel.this.myIndexerLastMaxUsed = memoryUsageWatchDog.getUsedMaxMemory();
                    }
                    if (ClangMemoryUsagePanel.this.isShowing()) {
                        ClangMemoryUsagePanel.this.updateState();
                    }
                }
            });
        }
    }

    private class MainListener
    implements ClangMemoryUsageWatchDogListener {
        private MainListener() {
        }

        @Override
        public void onMaxMemoryChanged(long maxMemory) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!ClangMemoryUsagePanel.this.myProject.isDisposed()) {
                    ClangMemoryUsagePanel.this.myLastLimit = maxMemory;
                    if (ClangMemoryUsagePanel.this.isShowing()) {
                        ClangMemoryUsagePanel.this.updateState();
                    }
                }
            });
        }

        @Override
        public void onUsedMemoryChanged(long usedMemory) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!ClangMemoryUsagePanel.this.myProject.isDisposed()) {
                    ClangMemoryUsagePanel.this.myLastReported = usedMemory;
                    ClangMemoryUsageWatchDog memoryUsageWatchDog = ClangLanguageServiceProvider.getIfStarted(ClangMemoryUsagePanel.this.myProject).getMemoryUsageWatchDog();
                    if (memoryUsageWatchDog != null) {
                        ClangMemoryUsagePanel.this.myLastLimit = memoryUsageWatchDog.getMaxMemory();
                        ClangMemoryUsagePanel.this.myLastAvgUsed = memoryUsageWatchDog.getUsedAverageMemory();
                        ClangMemoryUsagePanel.this.myLastMaxUsed = memoryUsageWatchDog.getUsedMaxMemory();
                    }
                    if (ClangMemoryUsagePanel.this.isShowing()) {
                        ClangMemoryUsagePanel.this.updateState();
                    }
                }
            });
        }
    }
}

