/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry;

import com.intellij.openapi.application.ApplicationManager;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangGeneralTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetryListener;
import org.jetbrains.annotations.NotNull;

public final class ClangTelemetry {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangGeneralTelemetry myGeneralTelemetry;
    @NotNull
    private final ClangPreambleTelemetry myPreambleTelemetry;

    public ClangTelemetry(@NotNull ClangDaemonContext context) {
        this.myContext = context;
        this.myGeneralTelemetry = new ClangGeneralTelemetry(context.getUrlConverter());
        this.myPreambleTelemetry = new ClangPreambleTelemetry();
    }

    public void onServerTelemetryEvent(Object rawEvent) {
        if (this.myGeneralTelemetry.handle(rawEvent)) {
            this.fireGeneralEvent();
        } else if (this.myPreambleTelemetry.handle(rawEvent)) {
            this.firePreambleEvent();
        }
    }

    @NotNull
    public ClangGeneralTelemetry getGeneralTelemetry() {
        return this.myGeneralTelemetry;
    }

    @NotNull
    public ClangPreambleTelemetry getPreambleTelemetry() {
        return this.myPreambleTelemetry;
    }

    private void fireGeneralEvent() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myContext.canPublishMessage()) {
                ((ClangTelemetryListener)this.myContext.getMessageBus().syncPublisher(ClangTelemetryListener.TOPIC)).onGeneralTelemetry(this);
            }
        });
    }

    private void firePreambleEvent() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myContext.canPublishMessage()) {
                ((ClangTelemetryListener)this.myContext.getMessageBus().syncPublisher(ClangTelemetryListener.TOPIC)).onPreambleTelemetry(this);
            }
        });
    }
}

