/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.AbstractTelemetryEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.NewModuleCompiledEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ParseFinishedEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ParseStartedEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class ClangGeneralTelemetry {
    @NotNull
    private final ClangUrlConverter myConverter;
    private final Map<String, ParseStats> myParsedFiles = new HashMap<String, ParseStats>();
    private final Map<String, Integer> myCompiledModules = new HashMap<String, Integer>();
    private final AtomicInteger myParseStartedCounter = new AtomicInteger();
    private final AtomicInteger myParseFinishedCounter = new AtomicInteger();

    public ClangGeneralTelemetry(@NotNull ClangUrlConverter converter) {
        this.myConverter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handle(Object rawEvent) {
        String eventName = AbstractTelemetryEvent.getEventName(rawEvent);
        if (eventName == null) {
            return false;
        }
        switch (eventName) {
            case "ParseStarted": {
                this.myParseStartedCounter.incrementAndGet();
                ParseStartedEvent parseStartedEvent = ParseStartedEvent.tryInstantiate(rawEvent);
                assert (parseStartedEvent != null);
                Map<String, ParseStats> map = this.myParsedFiles;
                synchronized (map) {
                    ParseStats stats = this.getStatsNoSync(parseStartedEvent.targetFile);
                    ++stats.parseStartedCounter;
                }
                return true;
            }
            case "ParseFinished": {
                this.myParseFinishedCounter.incrementAndGet();
                ParseFinishedEvent parseFinishedEvent = ParseFinishedEvent.tryInstantiate(rawEvent);
                assert (parseFinishedEvent != null);
                Map<String, ParseStats> stats = this.myParsedFiles;
                synchronized (stats) {
                    ParseStats stats2 = this.getStatsNoSync(parseFinishedEvent.targetFile);
                    ++stats2.parseFinishedCounter;
                }
                return true;
            }
            case "NewModuleCompiled": {
                NewModuleCompiledEvent newModuleCompiledEvent = NewModuleCompiledEvent.tryInstantiate(rawEvent);
                assert (newModuleCompiledEvent != null);
                Map<String, Integer> map = this.myCompiledModules;
                synchronized (map) {
                    this.myCompiledModules.compute(newModuleCompiledEvent.moduleName, (k, v) -> v == null ? 1 : v + 1);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReparseSent(@NotNull ClangReparseNotification notification) {
        Map<String, ParseStats> map = this.myParsedFiles;
        synchronized (map) {
            ParseStats stats = this.getStatsNoSync(this.myConverter.fromUrl(notification.getUrl()));
            ++stats.parseRequestSentCounter;
        }
    }

    public int getParseStartedCounter() {
        return this.myParseStartedCounter.get();
    }

    public int getParseFinishedCounter() {
        return this.myParseFinishedCounter.get();
    }

    public int getNumberOfParsedFiles() {
        return this.myParsedFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachParsedFile(@NotNull BiConsumer<String, ParseStats> consumer) {
        Map<String, ParseStats> map = this.myParsedFiles;
        synchronized (map) {
            this.myParsedFiles.forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachCompiledModule(@NotNull BiConsumer<String, Integer> consumer) {
        Map<String, Integer> map = this.myCompiledModules;
        synchronized (map) {
            this.myCompiledModules.forEach(consumer);
        }
    }

    @NotNull
    private ParseStats getStatsNoSync(@NotNull String targetFile) {
        return this.myParsedFiles.computeIfAbsent(targetFile, k -> new ParseStats());
    }

    public static final class ParseStats {
        public int parseRequestSentCounter;
        public int parseStartedCounter;
        public int parseFinishedCounter;
    }
}

