/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ServerInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ExtendedServerInfo;", "", "serverInfo", "Lorg/eclipse/lsp4j/ServerInfo;", "(Lorg/eclipse/lsp4j/ServerInfo;)V", "clangMajor", "", "getClangMajor", "()I", "clangMinor", "getClangMinor", "clangPatch", "getClangPatch", "clangVersion", "", "getClangVersion", "()Ljava/lang/String;", "getServerInfo", "()Lorg/eclipse/lsp4j/ServerInfo;", "intellij.c.clangd"})
public final class ExtendedServerInfo {
    private final int clangMajor;
    private final int clangMinor;
    private final int clangPatch;
    @NotNull
    private final String clangVersion;
    @NotNull
    private final ServerInfo serverInfo;

    public final int getClangMajor() {
        return this.clangMajor;
    }

    public final int getClangMinor() {
        return this.clangMinor;
    }

    public final int getClangPatch() {
        return this.clangPatch;
    }

    @NotNull
    public final String getClangVersion() {
        return this.clangVersion;
    }

    @NotNull
    public final ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public ExtendedServerInfo(@NotNull ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
        Matcher matcher = ClangUtils.VERSION_PATTERN.matcher(this.serverInfo.getVersion());
        if (matcher.matches()) {
            boolean bl;
            String version = matcher.group(1);
            List majorMinorPatch = StringsKt.split$default((CharSequence)version, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = bl = majorMinorPatch.size() == 3;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.clangMajor = Integer.parseInt((String)majorMinorPatch.get(0));
            this.clangMinor = Integer.parseInt((String)majorMinorPatch.get(1));
            this.clangPatch = Integer.parseInt((String)majorMinorPatch.get(2));
            this.clangVersion = this.serverInfo.getVersion();
        } else {
            CidrLogService.logOnce((Level)Level.SEVERE, (String)("Failed to parse version string: " + this.serverInfo.getVersion()), (Throwable)new Exception());
            this.clangMajor = 14;
            this.clangMinor = 0;
            this.clangPatch = 0;
            this.clangVersion = "clangd version 14.0.0 (ssh://git@git.jetbrains.team/llvm-project.git 41b6170636aabaa99c5f78e36da3e741212c7190 based on LLVM 42b588a2000e872d63326a623982c75ab5ac28a9 revision)";
        }
    }
}

