/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangRequestBuilder {
    @NotNull
    @NonNls
    private final String myRequestName;
    @Nullable
    private BiConsumer<? super ClangServer, ? super ClangRemoteWorkspace> myAction;
    private boolean myRequiresRecover;
    @Nullable
    private Consumer<? super ClangRemoteWorkspace> myOnSkipped;
    @Nullable
    private Runnable myOnRejected;

    public ClangRequestBuilder(@NonNls @NotNull String requestName) {
        this.myRequestName = requestName;
    }

    @NotNull
    public ClangRequestBuilder action(@NotNull Consumer<? super ClangServer> action) {
        this.myAction = (server, workspace) -> action.consume(server);
        return this;
    }

    @NotNull
    public ClangRequestBuilder action(@NotNull BiConsumer<? super ClangServer, ? super ClangRemoteWorkspace> action) {
        this.myAction = action;
        return this;
    }

    @NotNull
    public ClangRequestBuilder requiresRecover() {
        return this.requiresRecover(true);
    }

    @NotNull
    public ClangRequestBuilder requiresRecover(boolean requiresRecover) {
        this.myRequiresRecover = requiresRecover;
        return this;
    }

    @NotNull
    public ClangRequestBuilder onSkipped(@NotNull Runnable runnable) {
        this.myOnSkipped = ws -> runnable.run();
        return this;
    }

    @NotNull
    public ClangRequestBuilder onSkipped(@NotNull Consumer<? super ClangRemoteWorkspace> consumer) {
        this.myOnSkipped = consumer;
        return this;
    }

    @NotNull
    public ClangRequestBuilder onRejected(@NotNull Runnable runnable) {
        this.myOnRejected = runnable;
        return this;
    }

    @NotNull
    public ClangInteraction create() {
        return new ClangInteraction(){

            @Override
            public String getName() {
                return ClangRequestBuilder.this.myRequestName;
            }

            @Override
            public void send(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
                if (ClangRequestBuilder.this.myAction != null) {
                    ClangRequestBuilder.this.myAction.accept(server, ws);
                }
            }

            @Override
            public boolean requiresRecover() {
                return ClangRequestBuilder.this.myRequiresRecover;
            }

            @Override
            public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
                if (ClangRequestBuilder.this.myOnSkipped != null) {
                    ClangRequestBuilder.this.myOnSkipped.consume((Object)ws);
                }
            }

            @Override
            public void onRejected() {
                if (ClangRequestBuilder.this.myOnRejected != null) {
                    ClangRequestBuilder.this.myOnRejected.run();
                }
            }
        };
    }
}

