/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidOpenTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangOpenNotification
extends ClangFileBasedNotification<OpenData>
implements ClangPlannedInteraction {
    @Nullable
    public static ClangOpenNotification create(@NotNull ClangDaemonContext context, @NotNull VirtualFile file, int version) {
        OpenData data = ClangOpenNotification.doPrepare(context, file, version);
        return data != null ? new ClangOpenNotification(context, file.getUrl(), version, data) : null;
    }

    private ClangOpenNotification(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull OpenData data) {
        super(context, url, version, false, data);
    }

    @Override
    @NotNull
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        return Arrays.asList(Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Ast)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Content)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.SavedFlag)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.FormatConfiguration)));
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        assert (ws.isClosedRemotely(this.myUrl));
        return ClangOpenNotification.doSend(server, (OpenData)this.myParams);
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull OpenData params) {
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.IS_OPENED, true);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.params.isSaved());
        wf.put(RemoteWorkspaceFile.CONTENT, params.params.getTextDocument().getText());
    }

    @Nullable
    static OpenData doPrepare(@NotNull ClangDaemonContext context, @NotNull VirtualFile file, int version) {
        CharSequence fileText;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context.getProject().isDisposed()) {
            return null;
        }
        String url = file.getUrl();
        ClangIdeFacade ideFacade = context.getIdeFacade();
        boolean isFileSaved = !ideFacade.isModified(file);
        ClangFileFacade helper = ideFacade.getFileFacade(file);
        CharSequence charSequence = fileText = helper != null ? helper.getText() : null;
        if (fileText == null) {
            ClangUtils.warnClangd(LOG, "Failed to get text of a file " + url);
            return null;
        }
        return ClangOpenNotification.doPrepare(context, url, version, fileText.toString(), isFileSaved);
    }

    @NotNull
    static OpenData doPrepare(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull String content, boolean saved) {
        String uri = context.getUrlConverter().toUriFromUrl(url);
        TextDocumentItem docItem = new TextDocumentItem(uri, "cpp", version, content);
        ClionDidOpenTextDocumentParams params = new ClionDidOpenTextDocumentParams(docItem, saved);
        return new OpenData(context, url, params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull OpenData data) {
        server.clionDidOpen(data.params);
        return true;
    }

    public static class OpenData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionDidOpenTextDocumentParams params;

        OpenData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionDidOpenTextDocumentParams params) {
            this.context = context;
            this.url = url;
            this.params = params;
        }
    }
}

