/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTypehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionInlayHintFragment;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionInlayHintInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.InlayHintsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTReadRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdInlayHintData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.InlayHintKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangInlayHintsRequest
extends ClangASTReadRequest<InlayHintsParams, CachingSupplier<ClangdInlayHintData>> {
    @NotNull
    final ClangDaemonContext myContext;
    @NotNull
    final VirtualFile myVirtualFile;

    public ClangInlayHintsRequest(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull VirtualFile virtualFile, @NotNull TextDocumentIdentifier docIdent, @Nullable ClionClangNamehintConfigParams parameterConfig, @Nullable ClionClangTypehintConfigParams typeConfig) {
        super(url, new InlayHintsParams(docIdent, parameterConfig, typeConfig));
        this.myContext = context;
        this.myVirtualFile = virtualFile;
    }

    @Override
    @Nullable
    protected CompletableFuture<CachingSupplier<ClangdInlayHintData>> sendRequestImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        return server.clangdInlayHints((InlayHintsParams)this.myParams).thenApply(it -> new CachingSupplier<ClangdInlayHintData>(() -> this.toClangdInlayHintData((List<ClangdInlayHint>)it)));
    }

    @Nullable
    private ClangdInlayHintData toClangdInlayHintData(@Nullable List<ClangdInlayHint> hints) {
        if (ContainerUtil.isEmpty(hints)) {
            return null;
        }
        Document document = this.myContext.getIdeFacade().getDocument(this.myVirtualFile);
        if (document == null) {
            return null;
        }
        int numLinesInDocument = document.getLineCount();
        HashMap<Integer, ClangdInlayHint> paramHints = new HashMap<Integer, ClangdInlayHint>();
        HashMap<Integer, ClangdInlayHint> typeHints = new HashMap<Integer, ClangdInlayHint>();
        hints.forEach(it -> {
            Range range;
            String kindValue = Objects.requireNonNull(it.getKind());
            InlayHintKind kind = InlayHintKind.valueOf(StringUtil.capitalize((String)kindValue));
            Position hintPos = ClangInlayHintsRequest.getHintPosition(kind, range = Objects.requireNonNull(it.getRange()));
            int hintLine = hintPos.getLine();
            if (hintLine < 0 || hintLine >= numLinesInDocument) {
                return;
            }
            int offset = ClangLanguageServiceUtils.lspPos2Offset(document, hintPos);
            if (kind == InlayHintKind.Parameter || kind == InlayHintKind.Designator) {
                paramHints.put(offset, (ClangdInlayHint)it);
            } else {
                this.fixTypehintLocations((ClangdInlayHint)it);
                typeHints.put(offset, (ClangdInlayHint)it);
            }
        });
        return new ClangdInlayHintData(paramHints, typeHints);
    }

    @NotNull
    private static Position getHintPosition(@NotNull InlayHintKind kind, @NotNull Range range) {
        return kind == InlayHintKind.Parameter || kind == InlayHintKind.Designator ? range.getStart() : range.getEnd();
    }

    private void fixTypehintLocations(@NotNull ClangdInlayHint hint) {
        ClionInlayHintInfo typeInfo = hint.getTypeInfo();
        if (typeInfo != null && typeInfo.getHintFragments() != null) {
            this.fixTypeLocations(typeInfo.getHintFragments());
        }
    }

    private void fixTypeLocations(@Nullable List<ClionInlayHintFragment> fragments) {
        if (fragments != null) {
            fragments.forEach(this::fixFragmentLocation);
        }
    }

    private void fixFragmentLocation(@NotNull ClionInlayHintFragment fragment) {
        Location loc = fragment.getTypeLocation();
        if (loc == null) {
            return;
        }
        URI javaURI = VfsUtil.toUri((File)new File(this.myContext.getUrlConverter().fromUri(loc.getUri())));
        Location fixedLoc = new Location(javaURI.toString(), loc.getRange());
        fragment.setTypeLocation(fixedLoc);
        this.fixTypeLocations(fragment.getTemplateArgs());
    }
}

