/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTReadRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColPosition;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangGotoRequestBase
extends ClangASTReadRequest<TextDocumentPositionParams, List<ClangSym>> {
    @NotNull
    protected final ClangDaemonContext myContext;

    ClangGotoRequestBase(@NotNull ClangDaemonContext context, @NotNull LocalWorkspaceFile wf, @NotNull TextDocumentPositionParams params) {
        super(wf.getUrl(), params);
        this.myContext = context;
    }

    @Nullable
    protected List<ClangSym> collectResults(@Nullable List<? extends SymbolInformation> infos) {
        if (ContainerUtil.isEmpty(infos)) {
            return null;
        }
        ArrayList<ClangSym> answer = new ArrayList<ClangSym>(infos.size());
        for (SymbolInformation symbolInformation : infos) {
            Location loc = symbolInformation.getLocation();
            URI javaURI = VfsUtil.toUri((File)new File(this.myContext.getUrlConverter().fromUri(loc.getUri())));
            SourceLocation srcLoc = new SourceLocation(javaURI, new ClangLineColPosition(loc.getRange().getStart()));
            answer.add(new ClangSym(symbolInformation.getName(), srcLoc, ClangRequestsHelper.isMacroLSPSymbolKind(symbolInformation.getKind())));
        }
        return answer;
    }
}

