/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidCloseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public final class ClangCloseNotification
extends ClangFileBasedNotification<ClionDidCloseTextDocumentParams>
implements ClangPlannedInteraction {
    @NotNull
    public static ClangCloseNotification create(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull String closedContent, boolean isSaved) {
        ClionDidCloseTextDocumentParams params = new ClionDidCloseTextDocumentParams(new TextDocumentIdentifier(context.getUrlConverter().toUriFromUrl(url)), closedContent, isSaved, version);
        return new ClangCloseNotification(context, url, version, params);
    }

    private ClangCloseNotification(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull ClionDidCloseTextDocumentParams params) {
        super(context, url, version, false, params);
    }

    @Override
    @NotNull
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        return Arrays.asList(Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Ast)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Content)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.SavedFlag)));
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        server.clionDidClose((ClionDidCloseTextDocumentParams)((Object)this.myParams));
        return true;
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ClionDidCloseTextDocumentParams params) {
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.IS_OPENED, false);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.isSaved());
        wf.put(RemoteWorkspaceFile.CONTENT, !params.isSaved() ? params.getText() : null);
    }
}

