/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidChangeTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangChangeNotification
extends ClangFileBasedNotification<ClionDidChangeTextDocumentParams>
implements ClangPlannedInteraction {
    @NotNull
    public static ClangChangeNotification create(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull DidChangeTextDocumentParams params, boolean isSaved) {
        ClionDidChangeTextDocumentParams clangParams = new ClionDidChangeTextDocumentParams(params.getTextDocument(), params.getContentChanges(), isSaved, params.getTextDocument().getVersion());
        return new ClangChangeNotification(context, url, version, clangParams);
    }

    private ClangChangeNotification(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull ClionDidChangeTextDocumentParams params) {
        super(context, url, version, false, params);
    }

    @Override
    @NotNull
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        return Arrays.asList(Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Ast)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Content)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.SavedFlag)));
    }

    @Override
    @Nullable
    public List<Pair<String, ClangProperty>> getReadProperties() {
        return null;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        return ClangChangeNotification.doSend(server, (ClionDidChangeTextDocumentParams)((Object)this.myParams));
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ClionDidChangeTextDocumentParams params) {
        super.toNextRemoteState(wf, params);
        assert (params.getContentChanges().size() == 1) : "Fixme!";
        String content = ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText();
        wf.put(RemoteWorkspaceFile.CONTENT, content);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.isSaved());
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ClionDidChangeTextDocumentParams params) {
        server.clionDidChange(params);
        return true;
    }
}

