/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangASTReadRequest<P, R>
extends ClangAbstractRequest<P, R>
implements ClangPlannedInteraction {
    @NotNull
    private final String myAstFileUrl;

    ClangASTReadRequest(@NotNull String astFileUrl, @NotNull P params) {
        super(params);
        this.myAstFileUrl = astFileUrl;
    }

    @NotNull
    public String getAstFileUrl() {
        return this.myAstFileUrl;
    }

    @Override
    @Nullable
    public List<Pair<String, ClangProperty>> getReadProperties() {
        return Collections.singletonList(Pair.create((Object)this.getAstFileUrl(), (Object)((Object)ClangProperty.Ast)));
    }

    @Override
    @Nullable
    protected final CompletableFuture<R> sendRequest(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (!ws.isParsed(this.myAstFileUrl)) {
            return null;
        }
        return this.sendRequestImpl(server, ws);
    }

    @Nullable
    protected abstract CompletableFuture<R> sendRequestImpl(@NotNull ClangServer var1, @NotNull ClangRemoteWorkspace var2);
}

