/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangdMemoryUsageCollector;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ClangMemoryUsageWatchDogImpl
implements ClangMemoryUsageWatchDog,
ClangServerListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ClangMemoryUsageWatchDog.class.getName());
    private static final int DELAY = 10000;
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangLanguageService myService;
    @NotNull
    private final AtomicLong myLastReportedMemory = new AtomicLong(0L);
    @NotNull
    private final AtomicLong myMaxReportedMemory = new AtomicLong(0L);
    @NotNull
    private final AtomicLong myAverageReportedMemory = new AtomicLong(0L);
    @NotNull
    private final AtomicLong myReportedMemoryCounter = new AtomicLong(0L);
    @NotNull
    private final ScheduledFuture<?> myFuture;

    public ClangMemoryUsageWatchDogImpl(final @NotNull ClangDaemonContext context, @NotNull ClangLanguageService service) {
        this.myContext = context;
        this.myService = service;
        Disposer.register((Disposable)context, (Disposable)this);
        ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue(context.isIndexer()).addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (context.canPublishMessage()) {
                    ((ClangMemoryUsageWatchDogListener)context.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onMaxMemoryChanged(ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(value));
                }
            }
        }, (Disposable)context);
        context.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)this);
        this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::requestState, 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getCurrentMemory() {
        return this.myLastReportedMemory.get();
    }

    @Override
    public long getUsedAverageMemory() {
        return this.myAverageReportedMemory.get();
    }

    @Override
    public long getUsedMaxMemory() {
        return this.myMaxReportedMemory.get();
    }

    @Override
    public long getMaxMemory() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue(this.myContext.isIndexer()));
    }

    @Override
    public void onServerFailure() {
        this.reportMemoryUsed(0L);
    }

    @Override
    public void onServerShutDown() {
        this.reportMemoryUsed(0L);
    }

    private void requestState() {
        block8: {
            if (ClangMemoryUsageWatchDogImpl.isEnabled(this.myContext.isIndexer())) {
                try {
                    ClangMemoryUsageInfo memoryUsage = (ClangMemoryUsageInfo)CidrConcurrentUtilsKt.waitCancelAware(this.myService.debugDumpMemoryStat(), (long)10000L, (String)"memory stats");
                    if (memoryUsage == null) break block8;
                    long workingSet = (long)memoryUsage.getWorkingSet() * 1024L;
                    this.myLastReportedMemory.set(workingSet);
                    long measurementsCounter = this.myReportedMemoryCounter.incrementAndGet();
                    this.myAverageReportedMemory.accumulateAndGet(workingSet, (prevAvg, newWorkingSet) -> Double.valueOf((double)prevAvg * (((double)measurementsCounter - 1.0) / (double)measurementsCounter) + (double)newWorkingSet / (double)measurementsCounter).longValue());
                    this.myMaxReportedMemory.accumulateAndGet(workingSet, (prevMax, newWorkingSet) -> Math.max(prevMax, newWorkingSet));
                    long maxMemory = this.getMaxMemory();
                    if (ClangMemoryUsageWatchDogImpl.isEnabled(this.myContext.isIndexer()) && workingSet > maxMemory) {
                        String nativeStackTrace = maxMemory >= 4096L ? "\n\n" + this.myService.getNativeStacktrace() : "";
                        ClangStopData stopData = this.myService.shutDownServer();
                        LOG.warn("Server was restarted because the memory limit was exceeded: " + workingSet / 0x100000L + "M used of " + maxMemory / 0x100000L + "M" + nativeStackTrace);
                        ClangdMemoryUsageCollector.MEMORY_LIMIT_EXCEED.log();
                        try {
                            stopData.exitCode.get(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            LOG.warn((Throwable)ex);
                        }
                        catch (TimeoutException ex) {
                            LOG.warn("clangd is not down after 5 seconds, killing it.");
                            stopData.killRunnable.run();
                        }
                    }
                    this.reportMemoryUsed(workingSet);
                }
                catch (ExecutionException ex) {
                    LOG.warn((Throwable)ex);
                }
                catch (TimeoutException ex) {
                    LOG.warn("Timeout when getting memory stats");
                }
            }
        }
    }

    public void dispose() {
        this.myFuture.cancel(true);
        this.reportMemoryUsed(0L);
    }

    private void reportMemoryUsed(long howMuch) {
        if (this.myContext.canPublishMessage()) {
            ((ClangMemoryUsageWatchDogListener)this.myContext.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(howMuch);
        }
    }

    private static boolean isEnabled(boolean indexer) {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue(indexer)) > 0L;
    }

    private static long getMaxMemoryImpl(@NotNull RegistryValue value) {
        return (long)value.asInteger() * 0x100000L;
    }

    @NotNull
    private static RegistryValue getMaxMemoryRegistryValue(boolean indexer) {
        return indexer ? Registry.get((String)"clion.clangd.indexer.max.memory") : Registry.get((String)"clion.clangd.max.memory");
    }
}

