/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionCacheReadyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangIndexDiag;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangIndexNote;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCodeAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGraphFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexDiagsUpdatedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexPartFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingMessageParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingProgressParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingTaskParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.problems.ClangIndexProblem;
import com.jetbrains.cidr.lang.problems.ClangIndexProblemReporter;
import com.jetbrains.sourceglider.contextSensitive.DFATuple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientImpl
implements ClangClient {
    private static final Logger LOG = Logger.getInstance((String)ClangClient.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;

    public ClangClientImpl(@NotNull ClangDaemonContext context) {
        this.myContext = context;
    }

    private List<ClionDiagnostic> convertPathsIfRequired(List<ClionDiagnostic> diagnostics) {
        if (!this.myContext.getUrlConverter().isWslMode()) {
            return diagnostics;
        }
        diagnostics.forEach(d -> {
            String path = ClangUrlConverter.fromWslPath(d.getClionFilePath(), this.myContext.getUrlConverter().getWslMsId());
            d.setClionFilePath(path);
        });
        return diagnostics;
    }

    @Override
    public void clionPublishDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getDiagnostics().complete(this.clionDiags2ClangDiagsSupplier(this.convertPathsIfRequired(diagnostics.getDiagnostics())));
        }
    }

    @Override
    public void clionPublishClazyDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getClazyDiagnostics().complete(this.clionDiags2ClangDiagsSupplier(this.convertPathsIfRequired(diagnostics.getDiagnostics())));
        }
    }

    @NotNull
    private Supplier<List<ClangDiagnostic>> clionDiags2ClangDiagsSupplier(@NotNull List<ClionDiagnostic> regularDiags) {
        return new CachingSupplier<List<ClangDiagnostic>>(() -> {
            HashSet<ClangDiagnostic> antiDuplicatesGuard = new HashSet<ClangDiagnostic>();
            ArrayList<ClangDiagnostic> clangDiagnostics = new ArrayList<ClangDiagnostic>();
            ListIterator<ClionDiagnostic> lspDiagsIter = regularDiags.listIterator();
            while (lspDiagsIter.hasNext()) {
                ClangDiagnostic diag;
                ClionDiagnostic lspDiag = (ClionDiagnostic)((Object)((Object)lspDiagsIter.next()));
                if (ClangClientImpl.isForMainFile(lspDiag)) {
                    diag = this.createClangDiag(lspDiag);
                    if (!antiDuplicatesGuard.add(diag)) continue;
                    clangDiagnostics.add(diag);
                    continue;
                }
                if (lspDiag.getSeverity() != DiagnosticSeverity.Error || (diag = this.createOtherFileDiag(lspDiag, lspDiagsIter)) == null || !antiDuplicatesGuard.add(diag)) continue;
                clangDiagnostics.add(diag);
            }
            return clangDiagnostics;
        });
    }

    @NotNull
    private ClangDiagnostic createClangDiag(@NotNull ClionDiagnostic lspDiag) {
        List allFixits;
        Range clionRange = lspDiag.getRange();
        List<String> messageAndNotes = ClangClientImpl.splitMessage(lspDiag.getMessage());
        List list = allFixits = lspDiag.getCodeActions() != null ? ContainerUtil.filter(lspDiag.getCodeActions(), ca -> ca != null) : null;
        if (allFixits != null) {
            ClangUrlConverter converter = this.myContext.getUrlConverter();
            for (ClionCodeAction fixit : allFixits) {
                if (fixit.getEdit() == null) continue;
                Map changes = fixit.getEdit().getChanges();
                for (String uri : changes.keySet()) {
                    List textEdits = (List)changes.remove(uri);
                    changes.put(converter.fromUriToUrl(uri), textEdits);
                }
            }
        }
        String diagCode = null;
        if (lspDiag.getCode() != null) {
            diagCode = lspDiag.getCode().isLeft() ? (String)lspDiag.getCode().getLeft() : ((Integer)lspDiag.getCode().getRight()).toString();
        }
        return new ClangDiagnostic(diagCode, lspDiag.getSource(), ClangClientImpl.makeFirstLetterUpperCase(ClangClientImpl.constructMessage(messageAndNotes)), ClangClientImpl.constructNotes(messageAndNotes), allFixits != null ? ContainerUtil.filter((Collection)allFixits, f -> f.getEdit() != null) : Collections.emptyList(), allFixits != null ? ContainerUtil.filter((Collection)ContainerUtil.map((Collection)allFixits, f -> f.getClionFix()), f -> f != null) : Collections.emptyList(), ClangClientImpl.getHighlightSeverity(lspDiag.getSeverity()), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
    }

    @Nullable
    private ClangDiagnostic createOtherFileDiag(@NotNull ClionDiagnostic errorLspDiag, @NotNull ListIterator<ClionDiagnostic> iter) {
        assert (errorLspDiag.getSeverity() == DiagnosticSeverity.Error);
        assert (!ClangClientImpl.isForMainFile(errorLspDiag));
        ClangDiagnostic candidate = null;
        int errorLine = errorLspDiag.getClionRange().getStart().getLine();
        int errorCharacter = errorLspDiag.getClionRange().getStart().getCharacter();
        String wslMsId = ClangUtils.getCurrentWslMsId(this.myContext.getProject());
        while (iter.hasNext()) {
            ClionDiagnostic nextLspDiag = iter.next();
            if (ClangClientImpl.isForMainFile(nextLspDiag) && nextLspDiag.getSeverity() == DiagnosticSeverity.Information) {
                ClangLanguageServiceUtils.ClangNote note;
                List<String> messageAndNotes = ClangClientImpl.splitMessage(nextLspDiag.getMessage());
                assert (messageAndNotes.size() > 0);
                String rawNote = messageAndNotes.get(messageAndNotes.size() - 1);
                if (rawNote.contains("error: ") && (note = ClangLanguageServiceUtils.parseNote(rawNote, wslMsId)) != null && note.line - 1 == errorLine && note.character - 1 == errorCharacter && note.path.contentEquals(errorLspDiag.getClionFilePath())) {
                    if (candidate != null) continue;
                    ClangDiagnostic mainDiag = this.createClangDiag(errorLspDiag);
                    ClangDiagnostic noteDiag = this.createClangDiag(nextLspDiag);
                    candidate = new ClangDiagnostic(noteDiag.getCode(), noteDiag.getSource(), noteDiag.getMessage(), noteDiag.getNotes(), mainDiag.getClangdFixits(), mainDiag.getClionFixits(), HighlightSeverity.ERROR, noteDiag.getStartLine(), noteDiag.getStartColumn(), noteDiag.getEndLine(), noteDiag.getEndColumn());
                    continue;
                }
            }
            iter.previous();
            return candidate;
        }
        return candidate;
    }

    private static boolean isForMainFile(@NotNull ClionDiagnostic diag) {
        return StringUtil.isEmpty((String)diag.getClionFilePath());
    }

    @Override
    public void clionPublishHighlightings(ClionPublishHighlightingsParams highlightings) {
        ClangParseResponse openedFile = this.findFile(highlightings.getUri(), highlightings.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == highlightings.getVersion());
            openedFile.getHighlightings().complete(new CachingSupplier<List>(() -> ContainerUtil.map(highlightings.getHighlightings(), d -> {
                Range clionRange = d.getRange();
                return new ClangHighlighting(d.getType(), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
            })));
        }
    }

    @Override
    public void clionPublishTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, true);
    }

    @Override
    public void clionPublishOurTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, false);
    }

    @Override
    public void clionPublishDFAInput(ClionPublishDFAInputsParams input) {
        ClangParseResponse openedFile = this.findFile(input.getUri(), input.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == input.getVersion());
            List clangTuples = ContainerUtil.map(input.getTuples(), d -> new DFATuple(d.getRelation(), d.getAttributes()));
            openedFile.getDFAInput().complete(new DFASupplier(clangTuples));
        }
    }

    @Override
    public void clionCompletionCacheReady(CLionCompletionCacheReadyParams params) {
        ClangParseResponse openedFile = this.findFile(params.getUri(), params.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == params.getVersion());
            openedFile.getCompletionCacheReady().complete(true);
        }
    }

    private void clionPublishTidyDiagnosticsImpl(ClionPublishTidyDiagnosticsParams diagnostics, boolean completeDefaultTidyDiags) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> responseFuture = completeDefaultTidyDiags ? openedFile.getTidyDiagnostics() : openedFile.getOurTidyDiagnostics();
            responseFuture.complete(new CachingSupplier<List>(() -> {
                String openedPath = this.myContext.getUrlConverter().fromUri(diagnostics.getUri());
                ClangUtils.traceClangd(LOG, "Got " + diagnostics.getClangTidyErrors().size() + " clang-tidy errors before filtering");
                List<ClionClangTidyError> clangTidyErrors = diagnostics.getClangTidyErrors().stream().filter(ClangClientImpl::isValid).filter(d -> {
                    String path = ClangUrlConverter.fromWslPath(d.getFilePath(), this.myContext.getUrlConverter().getWslMsId());
                    if (this.myContext.getUrlConverter().isWslMode()) {
                        d.setFilePath(path);
                        for (ClangTidyRange range : d.getRanges()) {
                            range.setFilePath(ClangUrlConverter.fromWslPath(range.getFilePath(), this.myContext.getUrlConverter().getWslMsId()));
                        }
                        for (ClionClangTidyReplacement replacement : d.getReplacements()) {
                            replacement.setFilePath(ClangUrlConverter.fromWslPath(replacement.getFilePath(), this.myContext.getUrlConverter().getWslMsId()));
                        }
                    }
                    int res = FileUtil.comparePaths((String)FileUtil.toCanonicalPath((String)path), (String)openedPath);
                    ClangUtils.traceClangd(LOG, "Comparing " + d.getFilePath() + " vs " + openedPath + " = " + res);
                    return res == 0;
                }).collect(Collectors.toList());
                ClangUtils.traceClangd(LOG, "Got " + clangTidyErrors.size() + " clang-tidy errors after filtering");
                Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangClientImpl.createByteToCharOffset(clangTidyErrors, openedFile);
                return clangTidyErrors.stream().map(tidyError -> ClangClientImpl.createClangTidyDiagnostic(tidyError, byteToCharOffsetMap)).collect(Collectors.toList());
            }));
        }
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        LOG.warn(ClangdBundle.message("clangd.standard.version.not.supported", new Object[0]));
    }

    @Override
    public void clionIndexingStarted() {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingStarted();
        }
    }

    @Override
    public void clionIndexingCanceled() {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingCanceled();
        }
    }

    @Override
    public void clionIndexingTask(ClionIndexingTaskParams params) {
        if (!this.myContext.isStopped()) {
            switch (params.getId()) {
                case "preprocessing": {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingTaskId(ClangdIndexingTaskId.preprocessing);
                    break;
                }
                case "indexing": {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingTaskId(ClangdIndexingTaskId.indexing);
                }
            }
        }
    }

    @Override
    public void clionIndexingProgress(ClionIndexingProgressParams progress) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingProgress(progress.getProcessed(), progress.getTotal());
        }
    }

    @Override
    public void clionIndexingMessage(ClionIndexingMessageParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingMessage(params.getMessage());
        }
    }

    @Override
    public void clionIndexingFinished(ClionIndexingFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingFinished(params.getDeletedModuleFiles(), params.getSymbolsDir());
            ((ClangIndexProblemReporter)this.myContext.getProject().getService(ClangIndexProblemReporter.class)).cleanupStaleProblems();
        }
    }

    @NotNull
    private ClangIndexProblem buildProblem(ClangIndexDiag D, VirtualFile VF) {
        HtmlBuilder Desc = new HtmlBuilder();
        Desc.append(D.getDescription());
        for (ClangIndexNote Note2 : D.getNotes()) {
            Desc.br();
            Desc.appendLink("#navigation/" + Note2.getPath() + ":" + Note2.getLine() + ":" + Note2.getCol(), Note2.getDescription());
        }
        return new ClangIndexProblem(this.myContext.getProject(), D.getSeverity(), VF.getModificationStamp(), D.getLine() - 1, D.getCol() - 1, VF, D.getMainFile() ? "clangd.indexer.main" : "clangd.indexer.modules", D.getDescription(), Desc.wrapWithHtmlBody().toString());
    }

    @Override
    public void clionIndexDiagsUpdated(ClionIndexDiagsUpdatedParams params) {
        String path = params.getPath();
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        if (vFile == null) {
            return;
        }
        Project proj = this.myContext.getProject();
        List<ClangIndexProblem> problems = params.getDiags().stream().map(it -> this.buildProblem((ClangIndexDiag)it, vFile)).collect(Collectors.toUnmodifiableList());
        ClangIndexProblemReporter service = (ClangIndexProblemReporter)proj.getService(ClangIndexProblemReporter.class);
        service.updateIndexProblems(vFile, problems);
    }

    @Override
    public void clionGraphFinished(ClionGraphFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onGraphFinished(params.getPath());
        }
    }

    @Override
    public void clionIndexPartFinished(ClionIndexPartFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexPartFinished(params.getPath());
        }
    }

    public void telemetryEvent(Object object) {
        this.myContext.getTelemetry().onServerTelemetryEvent(object);
    }

    public void showMessage(MessageParams messageParams) {
        if (messageParams.getType() == MessageType.Info && ClangDebugLevel.isWarnOrMore()) {
            Notification notification = new Notification("System Messages", ClangdBundle.message("language.cpp.clangd.message", new Object[0]), messageParams.getMessage(), NotificationType.INFORMATION);
            Notifications.Bus.notify((Notification)notification);
        }
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        CompletableFuture<MessageActionItem> response = new CompletableFuture<MessageActionItem>();
        response.complete(null);
        return response;
    }

    public void logMessage(MessageParams message) {
        LOG.info("From server: " + message.getMessage());
    }

    @Nullable
    private ClangParseResponse findFile(@NotNull String uri, int version) {
        String vfsUrl = this.myContext.getUrlConverter().fromUriToUrl(uri);
        ClangParseResponse file = this.myContext.getLocalWorkspace().apply(vfsUrl, wf -> wf.getPendingParseResponse(version));
        if (file == null) {
            ClangUtils.traceClangd(LOG, "Failed to find file to report diagnostics: " + uri);
        }
        return file;
    }

    @NotNull
    private static Map<String, Map<Integer, Integer>> createByteToCharOffset(@NotNull List<ClionClangTidyError> errors, @NotNull ClangParseResponse openedFile) {
        HashSet<String> unsavedFileUrls = (HashSet<String>)openedFile.getUserData(ClangParseResponse.UNSAVED_FILES);
        unsavedFileUrls = unsavedFileUrls != null ? new HashSet<String>(unsavedFileUrls) : new HashSet();
        unsavedFileUrls.add(openedFile.getUrl());
        Set<String> unsavedFilePaths = unsavedFileUrls.stream().map(url -> VirtualFileManager.extractPath((String)url)).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder = new ByteToCharOffsetMapBuilder();
        return builder.createFor(errors, unsavedFilePaths);
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull DiagnosticSeverity lspSeverity) {
        switch (lspSeverity) {
            case Error: {
                return HighlightSeverity.ERROR;
            }
            case Warning: {
                return HighlightSeverity.WARNING;
            }
            case Information: {
                return HighlightSeverity.WEAK_WARNING;
            }
            case Hint: {
                return HighlightSeverity.INFORMATION;
            }
        }
        LOG.warn("Unexpected severity: " + lspSeverity);
        return HighlightSeverity.INFORMATION;
    }

    @NotNull
    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull ClionClangTidyError diagnostic, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        List<ClangTidyReplacement> replacements = Collections.emptyList();
        if (diagnostic.getReplacements() != null && !diagnostic.getReplacements().isEmpty()) {
            replacements = diagnostic.getReplacements().stream().map(replacement -> ClangClientImpl.createClangTidyReplacement(replacement, byteToCharOffsetMap)).collect(Collectors.toList());
        }
        int offset = ClangClientImpl.getCharOffset(diagnostic.getFilePath(), diagnostic.getFileOffset(), byteToCharOffsetMap);
        List ranges = Collections.emptyList();
        if (diagnostic.getRanges() != null && !diagnostic.getRanges().isEmpty()) {
            ranges = ContainerUtil.map((Collection)ContainerUtil.filter(diagnostic.getRanges(), ClangClientImpl::isValid), it -> ClangClientImpl.createClangTidyRange(it, byteToCharOffsetMap));
        }
        return new ClangTidyDiagnostic(diagnostic.getMessage(), diagnostic.getName(), diagnostic.getFilePath(), offset, ranges, replacements, diagnostic.getClionFix());
    }

    @NotNull
    private static ClangTidyRange createClangTidyRange(@NotNull ClangTidyRange range, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        int beginOffset = ClangClientImpl.getCharOffset(range.getFilePath(), range.getFileOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(range.getFilePath(), range.getFileOffset() + range.getLength(), byteToCharOffsetMap);
        return new ClangTidyRange(range.getFilePath(), beginOffset, endOffset - beginOffset);
    }

    @NotNull
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull ClionClangTidyReplacement replacement, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        int beginOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset() + replacement.getLength(), byteToCharOffsetMap);
        return new ClangTidyReplacement(replacement.getFilePath(), replacement.getReplacementText(), beginOffset, endOffset);
    }

    private static boolean isValid(@NotNull ClionClangTidyError diagnostic) {
        return StringUtil.isNotEmpty((String)diagnostic.getName()) && StringUtil.isNotEmpty((String)diagnostic.getFilePath()) && StringUtil.isNotEmpty((String)diagnostic.getMessage()) && diagnostic.getFileOffset() >= 0 && (diagnostic.getReplacements() == null || diagnostic.getReplacements().isEmpty() || diagnostic.getReplacements().stream().allMatch(ClangClientImpl::isValid));
    }

    private static boolean isValid(@NotNull ClionClangTidyReplacement replacement) {
        return StringUtil.isNotEmpty((String)replacement.getFilePath()) && replacement.getLength() >= 0 && replacement.getOffset() >= 0;
    }

    private static boolean isValid(@NotNull ClangTidyRange range) {
        return StringUtil.isNotEmpty((String)range.getFilePath());
    }

    private static int getCharOffset(@NotNull String filePath, int byteOffset, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        return byteToCharOffsetMap.getOrDefault(filePath, Collections.emptyMap()).getOrDefault(byteOffset, byteOffset);
    }

    @NotNull
    private static String makeFirstLetterUpperCase(@NotNull String message) {
        if (message.isEmpty()) {
            return message;
        }
        char upperCaseLetter = Character.toUpperCase(message.charAt(0));
        return upperCaseLetter + message.substring(1);
    }

    @NotNull
    private static List<String> splitMessage(@NotNull String message) {
        return Arrays.asList(message.split("\n\n"));
    }

    @NotNull
    private static String constructMessage(@NotNull List<String> messagesAndNotes) {
        String message = messagesAndNotes.get(0);
        if (message.endsWith(" requested here")) {
            return message.substring(0, message.length() - " requested here".length());
        }
        return message;
    }

    @Nullable
    private static List<String> constructNotes(@NotNull List<String> messagesAndNotes) {
        return messagesAndNotes.size() > 1 ? messagesAndNotes.subList(1, messagesAndNotes.size()) : null;
    }

    public static class DFASupplier
    implements Supplier<List<DFATuple>> {
        private final long myCompressionTimeMs;
        private final int myOriginalSize;
        private final byte @NotNull [] myCompressedJSonTuples;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DFASupplier(@NotNull List<DFATuple> clangTuples) {
            long startTime = System.currentTimeMillis();
            String serialized = new Gson().toJson(clangTuples);
            Deflater deflater = new Deflater();
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            try (DeflaterOutputStream compressOutput = new DeflaterOutputStream((OutputStream)output, deflater);){
                compressOutput.write(serialized.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                LOG.warn((Throwable)ex);
            }
            finally {
                deflater.end();
            }
            this.myCompressionTimeMs = System.currentTimeMillis() - startTime;
            this.myOriginalSize = serialized.length();
            this.myCompressedJSonTuples = output.toByteArray();
        }

        public int getOriginalSize() {
            return this.myOriginalSize;
        }

        public int getCompressedSize() {
            return this.myCompressedJSonTuples.length;
        }

        public long getCompressionTimeMs() {
            return this.myCompressionTimeMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<DFATuple> get() {
            List list;
            if (this.myCompressedJSonTuples.length == 0) {
                return Collections.emptyList();
            }
            Inflater inflater = new Inflater();
            InflaterInputStream input = new InflaterInputStream(new ByteArrayInputStream(this.myCompressedJSonTuples), inflater);
            try {
                byte[] decompressed = input.readAllBytes();
                Type tuplesType = new TypeToken<ArrayList<DFATuple>>(){}.getType();
                list = (List)new Gson().fromJson(new String(decompressed, StandardCharsets.UTF_8), tuplesType);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.warn((Throwable)ex);
                        inflater.end();
                        return Collections.emptyList();
                    }
                }
                catch (Throwable throwable3) {
                    inflater.end();
                    throw throwable3;
                }
            }
            input.close();
            inflater.end();
            return list;
        }
    }
}

