/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceHolder;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdLanguageServiceProvider
implements ClangLanguageServiceProvider {
    @NotNull
    private final ClangdLanguageServiceHolder myMainHolder;
    @NotNull
    private final ClangdLanguageServiceHolder myIndexerHolder;

    public ClangdLanguageServiceProvider(@NotNull Project project) {
        String clangdModulesPath = ClangdLanguageServiceProvider.getModulesPath(project);
        String cpp20ModulesPath = clangdModulesPath + "/cpp20";
        if (!FileUtil.exists((String)clangdModulesPath)) {
            FileUtil.createDirectory((File)new File(clangdModulesPath));
        }
        CidrLogService.LOG.info("clangd modules path: " + clangdModulesPath);
        CidrLogService.LOG.info("clangd cpp20 modules path: " + cpp20ModulesPath);
        this.myMainHolder = new ClangdLanguageServiceHolder("main", project, new File(clangdModulesPath), new File(cpp20ModulesPath), false);
        this.myIndexerHolder = new ClangdLanguageServiceHolder("indexer", project, new File(clangdModulesPath), new File(cpp20ModulesPath), true);
        ClangUtils.subscribeToStyleChanges(this, project);
    }

    @Override
    @NotNull
    public ClangLanguageService getOrStart() {
        return this.myMainHolder.getOrStart();
    }

    @Override
    @Nullable
    public ClangLanguageService getIfStarted() {
        return this.myMainHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        return this.myMainHolder.stop();
    }

    @Override
    @NotNull
    public ClangLanguageService getOrStartIndexer() {
        return this.myIndexerHolder.getOrStart();
    }

    @Override
    @Nullable
    public ClangLanguageService getIfStartedIndexer() {
        return this.myIndexerHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stopIndexer() {
        return this.myIndexerHolder.stop();
    }

    @NotNull
    static String getModulesPath(@NotNull Project project) {
        Object clangdModulesPath = System.getProperty("MODULES_PATH");
        if (clangdModulesPath == null && (clangdModulesPath = System.getenv("MODULES_PATH")) == null) {
            String dir = System.getProperty("caches_dir");
            Object object = clangdModulesPath = dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
        }
        if (!((String)clangdModulesPath).endsWith("/")) {
            clangdModulesPath = (String)clangdModulesPath + "/";
        }
        clangdModulesPath = (String)clangdModulesPath + "clangd_modules/" + project.getLocationHash();
        return clangdModulesPath;
    }

    public void dispose() {
        this.myMainHolder.forceStop();
        this.myIndexerHolder.forceStop();
    }
}

