/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.DummyLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClangdLanguageServiceHolder {
    private static final Logger LOG = Logger.getInstance(ClangdLanguageServiceProvider.class);
    @NonNls
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myClangdModulesPath;
    @NotNull
    private final File myCpp20ModulesPath;
    private final boolean myIndexer;
    @NotNull
    private final Object myServiceLock = new Object();
    @Nullable
    private ClangLanguageService myService = null;

    ClangdLanguageServiceHolder(@NonNls @NotNull String descriptor, @NotNull Project project, @NotNull File clangdModulesPath, @NotNull File cpp20ModulesPath, boolean indexer) {
        this.myDescriptor = descriptor;
        this.myProject = project;
        this.myClangdModulesPath = clangdModulesPath;
        this.myCpp20ModulesPath = cpp20ModulesPath;
        this.myIndexer = indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ClangLanguageService getOrStart() {
        if (!ClangUtils.isClangdAllowed(this.myProject)) {
            throw new ClangUtils.NotAllowedException();
        }
        Object object = this.myServiceLock;
        synchronized (object) {
            if (this.myService != null) {
                return this.myService;
            }
            if (this.myIndexer && !ClangUtils.isClangdIndexerOn(this.myProject)) {
                this.myService = DummyLanguageService.INSTANCE;
                return this.myService;
            }
            this.myService = ClangdLanguageServiceHolder.startImpl(this.myDescriptor, this.myProject, this.myClangdModulesPath, this.myCpp20ModulesPath, this.myIndexer);
            if (!this.myProject.isDisposed()) {
                ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStarted(this.myService);
            }
            return this.myService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangLanguageService getIfStarted() {
        Object object = this.myServiceLock;
        synchronized (object) {
            return this.myService;
        }
    }

    @NotNull
    private static ClangLanguageService startImpl(@NonNls @NotNull String descriptor, @NotNull Project project, @NotNull File clangdModulesPath, @NotNull File cpp20ModulesPath, boolean indexer) {
        ClangDaemonContextImpl context = null;
        try {
            ClangUrlConverter urlConverter = (ClangUrlConverter)project.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            if (urlConverter == null) {
                urlConverter = new ClangUrlConverter();
            }
            urlConverter.setWslMsId(ClangUtils.getCurrentWslMsId(project));
            ClangDaemonContextImpl.Builder builder = new ClangDaemonContextImpl.Builder(descriptor, project).setIndexer(indexer).setUrlConverter(urlConverter).setIdeFacade(ClangdBridge.createClangIdeFacade(descriptor, indexer)).setClangdModulesPath(clangdModulesPath.getPath()).setCpp20ModulesPath(cpp20ModulesPath.getPath());
            if (!indexer) {
                builder.setMessageBus(project.getMessageBus());
            }
            context = builder.create();
            return indexer ? new ClangdIndexerService(context) : new ClangdLanguageService(context);
        }
        catch (Throwable thr) {
            if (context != null) {
                Disposer.dispose(context);
            }
            throw thr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ClangStopData stop() {
        Object object = this.myServiceLock;
        synchronized (object) {
            ClangStopData clangStopData;
            if (this.myService == null) {
                return ClangStopData.EMPTY;
            }
            ClangLanguageService service = this.myService;
            this.myService = null;
            try {
                clangStopData = service.stop();
            }
            catch (Throwable throwable) {
                if (!this.myProject.isDisposed()) {
                    ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStopped(service);
                }
                throw throwable;
            }
            if (!this.myProject.isDisposed()) {
                ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStopped(service);
            }
            return clangStopData;
        }
    }

    public void forceStop() {
        ClangStopData stopData = this.stop();
        try {
            stopData.exitCode.get(450L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }
}

