/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Producer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.FullCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdContentDependentCaches;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdRequestsPlanner;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.HoverInfoKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.InlayHintsKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.LineMarkersKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.SignatureHelpKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.TestLineMarkersKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory.ClangMemoryUsageWatchDogImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCheckPreprocessedCaseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionDocumentRangeFormattingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionWorkspaceSymbolParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTypehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReloadIndexParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionTestRunLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTReadRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClionHoverInfoRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClionLineMarkersRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCompletionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDeleteNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpASTRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpTokensRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFindUsagesRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatConfigurationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatRangeRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGetLocalVariablesRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoDefinitionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoTypeDeclarationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangIndentRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangIndexPartFinishedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInlayHintsRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangParseCommandLineRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPreprocessRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadGraphNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadIndexNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSaveRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSetCDBNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSignatureHelpRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangTestLineMarkersRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdInlayHintData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdLanguageService
implements ClangLanguageService,
PendingParseListener,
PsiModificationTracker.Listener {
    private static final Logger LOG = Logger.getInstance((String)ClangdLanguageService.class.getName());
    private static final WorkspaceFile.Key<Map<OpenRequestId, Integer>> OPEN_REQUESTS = new WorkspaceFile.Key<Map>("OpenRequests", () -> new HashMap());
    private static final Key<UsagesInfo> USAGES_MAP = new Key("UsagesMap");
    private static final Key<Object> CANCELED_FLAG = new Key("CanceledFlag");
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final ClangLocalWorkspace myWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    protected final ClangdRequestsPlanner myRequestsPlanner;
    @NotNull
    private final ClangMemoryUsageWatchDog myMemoryUsageWatchDog;
    @NotNull
    private final Set<UserDataHolder> myDebugUsagesSet = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    @NotNull
    private final ClangdContentDependentCaches myContentDependentCache = new ClangdContentDependentCaches();
    @NotNull
    private final AtomicLong myProfileModificationCounter = new AtomicLong(0L);
    @NotNull
    private final Cache<GotoDefinitionKey, ClangGotoDefinitionRequest> myGotoDefinitionCache = CacheBuilder.newBuilder().maximumSize(4096L).build();
    private final Cache<GotoDefinitionKey, ClangGotoTypeDeclarationRequest> myGotoTypeDeclarationCache = CacheBuilder.newBuilder().maximumSize(4096L).build();

    public ClangdLanguageService(@NotNull ClangDaemonContext context) {
        this.myContext = context;
        this.myProject = context.getProject();
        this.myWorkspace = context.getLocalWorkspace();
        this.myIdeFacade = context.getIdeFacade();
        this.myRequestsPlanner = new ClangdRequestsPlanner(context.getDescriptor(), context.getServerAccessorProvider().createServerAccessor(context));
        this.myWorkspace.addPendingParseListener(this);
        this.myMemoryUsageWatchDog = new ClangMemoryUsageWatchDogImpl(context, this);
        context.getProject().getMessageBus().connect((Disposable)context).subscribe(PsiModificationTracker.TOPIC, (Object)this);
        if (context.shouldStartServerImmediately()) {
            this.myRequestsPlanner.sendImmediately(ClangInteraction.createSimple("Misc", (Consumer<? super ClangServer>)((Consumer)server -> {}), true));
        }
        context.getProject().getMessageBus().connect((Disposable)context).subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                ClangdLanguageService.this.myProfileModificationCounter.incrementAndGet();
            }
        });
    }

    @Override
    public void onOverflow(@NotNull ClangParseResponse oldest) {
        this.myWorkspace.modify(oldest.getUrl(), wf -> this.sendCancelParse((LocalWorkspaceFile)wf, oldest));
    }

    public void modificationCountChanged() {
        this.myContentDependentCache.clear();
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    @NotNull
    public Disposable getAssociatedDisposable() {
        return this.myContext;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        return this.myContext.getDescriptor();
    }

    @Override
    @NotNull
    public String getWslMsId() {
        return this.myContext.getUrlConverter().getWslMsId();
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        return this.myContext.getMessageBus();
    }

    @Override
    @NotNull
    public ClangIdeFacade getClangIdeFacade() {
        return this.myIdeFacade;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        return this.myContext.getUrlConverter();
    }

    @Override
    public boolean isActive() {
        return !this.myContext.isStopped();
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        return this.myContext.getTelemetry();
    }

    @Override
    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        return this.myMemoryUsageWatchDog;
    }

    @Override
    public <E extends Throwable> void gotoDefinition(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangSym>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("gotoDefinition", file, (wf, response) -> this.sendGotoDefinition((LocalWorkspaceFile)wf, (ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void findUsages(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangFoundUsage>, E> consumer) throws E {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "findUsages for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            ClangResultImpl result = this.computeWithParsedInternal("findUsages", file, (wf, resp) -> this.sendFindUsages((LocalWorkspaceFile)wf, file, offset));
            ClangdLanguageService.applyConsumer(consumer, result);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void getLocalVariables(@NotNull VirtualFile file, int line, @NotNull ClangResultConsumer<List<String>, E> consumer) throws E {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "getLocalVariables for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            ClangResultImpl result = this.computeWithParsedInternal("getLocalVariables", file, (wf, resp) -> this.sendGetLocalVariables((LocalWorkspaceFile)wf, file, line));
            ClangdLanguageService.applyConsumer(consumer, result);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    @Override
    public <E extends Throwable> void gotoTypeDeclaration(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangSym>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("clionTypeDeclaration", file, (wf, response) -> this.sendGotoTypeDeclaration((LocalWorkspaceFile)wf, (ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getHoverInfo(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<ClionHoverInfo, E> consumer) throws E {
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("clionHoverInfo", file, (wf, response) -> this.sendClionHoverInfo((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void dumpAST(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("dumpAST", file, (wf, response) -> this.sendDumpAST((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void dumpTokens(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("dumpTokens", file, (wf, response) -> this.sendDumpTokens((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void complete(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CompletionTriggerKind kind, @NotNull CLionCompletionKind completionKind, Pair<Integer, ArrayList<String>> postfixTemplates, @NotNull ClangResultConsumer<Either<List<CLionCompletionItem>, CLionCompletionList>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("complete", file, (wf, response) -> this.sendRequestComplete((LocalWorkspaceFile)wf, file, line, column, fileText, kind, completionKind, postfixTemplates));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getFastLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("getFastLineMarkers", file, (wf, response) -> this.sendClionLineMarkers((LocalWorkspaceFile)wf, file, fromOffset, toOffset, true));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getSlowLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("getSlowLineMarkers", file, (wf, response) -> this.sendClionLineMarkers((LocalWorkspaceFile)wf, file, fromOffset, toOffset, false));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getTestLineMarkers(@NotNull VirtualFile file, @NotNull List<String> enabledTestFrameworksNames, @NotNull ClangResultConsumer<List<ClionTestRunLineMarker>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("getTestRunLineMarkers", file, (wf, response) -> this.sendClionTestLineMarkers((LocalWorkspaceFile)wf, file, enabledTestFrameworksNames));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getInlayHints(@NotNull VirtualFile file, @Nullable ClionClangNamehintConfigParams parameterConfig, @Nullable ClionClangTypehintConfigParams typeConfig, @NotNull ClangResultConsumer<CachingSupplier<ClangdInlayHintData>, E> consumer) throws E {
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("getInlayHints", file, (wf, response) -> this.sendInlayHints((LocalWorkspaceFile)wf, file, parameterConfig, typeConfig));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getSignatureHelp(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<SignatureHelp, E> consumer) throws E {
        ClangResultImpl result = this.computeWithParsedInternal("getSignatureHelp", file, (wf, response) -> this.sendSignatureHelp((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    @NotNull
    public CompletableFuture<ClionFileStats> requestTimingStats(@NotNull VirtualFile file) {
        CompletableFuture<ClionFileStats> result = new CompletableFuture<ClionFileStats>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("RequestTimingsStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionRequestTimingsStat(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file))).whenComplete((res, ex) -> result.complete((ClionFileStats)res)))).onSkipped(() -> result.complete(null)).onRejected(() -> result.complete(null)).requiresRecover().create());
        return result;
    }

    @Override
    @NotNull
    public CompletableFuture<String> preprocess(@NotNull VirtualFile file) {
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
            ClangPreprocessRequest request = new ClangPreprocessRequest(wf.getUrl(), identifier);
            this.myRequestsPlanner.send(request);
            return request.getResponse();
        });
    }

    @Override
    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile file) {
        return this.withOpenedFile(file, wf -> this.sendRequestClangFormatConfiguration(file));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style, int cursorOffset) {
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.sendFormatRangeRequest(file, range, style, cursorOffset));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> indentLine(@NotNull VirtualFile file, int lineStartOffset, @Nullable String style) {
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.isAcceptable(file) ? this.sendIndentRequest(file, lineStartOffset, style) : CompletableFuture.completedFuture(null));
    }

    @Override
    @Nullable
    public ClangParseResponse getParsed(@NotNull VirtualFile file) {
        String url = file.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return null;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        return this.myWorkspace.applyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            return this.getOrParse(file, workspaceFile, macrosWorkspaceFile, null);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<CLionSymbolInformation>> getSymbols(@NotNull String query, boolean onlyStatic) {
        CompletableFuture<List<CLionSymbolInformation>> result = new CompletableFuture<List<CLionSymbolInformation>>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("workspace/symbol").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionWorkspaceSymbol(new CLionWorkspaceSymbolParams(query, onlyStatic))))).onSkipped(() -> result.complete(Collections.emptyList())).onRejected(() -> result.complete(Collections.emptyList())).create());
        return result;
    }

    @Override
    public <E extends Throwable> void runWithParsed(@NotNull VirtualFile file, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        this.computeWithParsed(file, response -> {
            consumer.consume(response);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithParsed(@NotNull VirtualFile file, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        Ref response = Ref.create();
        Ref usageID = Ref.create();
        try {
            ReadAction.run(() -> {
                String url = file.getUrl();
                if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                    return;
                }
                String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
                ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
                try {
                    this.myWorkspace.modify(Arrays.asList(url, macrosUrl), files -> {
                        LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
                        assert (workspaceFile != null) : "requested file must not be null!";
                        LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
                        assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
                        if (!workspaceFile.isOpened() && ClangDebugLevel.isWarnOrMore()) {
                            CidrLogService.logOnce((Level)Level.WARNING, (String)("Trying to parse closed file: " + workspaceFile.getUrl()), (Throwable)new Exception());
                        }
                        response.set((Object)this.getOrParse(file, workspaceFile, macrosWorkspaceFile, deferrer));
                        usageID.set((Object)this.trackParseUsage(workspaceFile, (ClangParseResponse)response.get()));
                    });
                }
                finally {
                    deferrer.runDeferred();
                }
            });
            T t = consumer.apply((ClangParseResponse)response.get());
            return t;
        }
        finally {
            if (!response.isNull() && !usageID.isNull()) {
                this.freeParseUsage((ClangParseResponse)response.get(), (Integer)usageID.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithOpenedAndParsed(@NotNull VirtualFile file, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "computeWithOpenedAndParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            T t = this.computeWithParsed(file, consumer);
            return t;
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void runWithOpenedAndParsed(@NotNull VirtualFile file, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "runWithOpenedAndParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            this.runWithParsed(file, consumer);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    @NotNull
    private <T> ClangResultImpl<T> computeWithParsedInternal(@NonNls @NotNull String title, @NotNull VirtualFile file, @NotNull BiFunction<LocalWorkspaceFile, ClangParseResponse, ClangASTReadRequest<?, T>> consumer) {
        return (ClangResultImpl)ReadAction.compute(() -> {
            String url = file.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
            }
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
            try {
                ClangResultImpl clangResultImpl = this.myWorkspace.apply(Arrays.asList(url, macrosUrl), files -> {
                    LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
                    assert (workspaceFile != null) : "requested file must not be null!";
                    LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
                    assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
                    ClangParseResponse response = this.getOrParse(file, workspaceFile, macrosWorkspaceFile, deferrer);
                    if (response != null) {
                        int parseUsageID = this.trackParseUsage(workspaceFile, response);
                        try {
                            ClangASTReadRequest request = (ClangASTReadRequest)consumer.apply(workspaceFile, response);
                            if (request != null) {
                                int reqUsageID = this.trackRequestUsage(workspaceFile, request);
                                return new ClangResultImpl(title, request.getResponse(), () -> {
                                    this.freeRequestUsage(request, reqUsageID);
                                    this.freeParseUsage(response, parseUsageID);
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.freeParseUsage(response, parseUsageID);
                    }
                    return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
                });
                return clangResultImpl;
            }
            finally {
                deferrer.runDeferred();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ClangResultImpl<T> computeWithOpenedAndParsedInternal(@NonNls @NotNull String title, @NotNull VirtualFile file, @NotNull BiFunction<LocalWorkspaceFile, ClangParseResponse, ClangASTReadRequest<?, T>> consumer) {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), title + " for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            ClangResultImpl<T> clangResultImpl = this.computeWithParsedInternal(title, file, consumer);
            return clangResultImpl;
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    private static <T, E extends Throwable> void applyConsumer(@NotNull ClangResultConsumer<T, E> consumer, @NotNull ClangResultImpl<T> res) throws E {
        try {
            consumer.consume(res);
        }
        finally {
            res.release();
        }
    }

    private int trackParseUsage(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (response == null) {
            return -1;
        }
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
        int ID = ++usages.nextID;
        usages.id2Stack.put(ID, this.debugTrackUsage((UserDataHolder)response));
        return ID;
    }

    private void freeParseUsage(@NotNull ClangParseResponse response, int usageID) {
        this.myWorkspace.modify(response.getUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)response);
                this.cancelParse((LocalWorkspaceFile)wf, response);
            }
        });
    }

    private int trackRequestUsage(@NotNull LocalWorkspaceFile wf, @NotNull ClangASTReadRequest<?, ?> request) {
        assert (wf.getUrl().contentEquals(request.getAstFileUrl()));
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent(request, USAGES_MAP, () -> new UsagesInfo());
        int ID = ++usages.nextID;
        usages.id2Stack.put(ID, this.debugTrackUsage((UserDataHolder)request));
        return ID;
    }

    private void freeRequestUsage(@NotNull ClangASTReadRequest<?, ?> request, int usageID) {
        this.myWorkspace.modify(request.getAstFileUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)request, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)request);
                this.cancelRequest(request);
            }
        });
    }

    @Nullable
    private Exception debugTrackUsage(@NotNull UserDataHolder usedObject) {
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            this.myDebugUsagesSet.add(usedObject);
            return new Exception();
        }
        return null;
    }

    private void debugFreeUsage(@NotNull UserDataHolder usedObject) {
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            assert (usages != null && usages.id2Stack.isEmpty());
            this.myDebugUsagesSet.remove(usedObject);
        }
    }

    private static boolean isCanceled(@NotNull UserDataHolder something) {
        return something.getUserData(CANCELED_FLAG) != null;
    }

    private static void setCanceled(@NotNull UserDataHolder something) {
        something.putUserData(CANCELED_FLAG, (Object)true);
    }

    private void cancelParseGently(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (response != null) {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            if (usages.id2Stack.isEmpty()) {
                this.cancelParse(wf, response);
            }
        }
    }

    private void cancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (response.isCancellable() && wf.getVersion() > response.getVersion() && !ClangParseResponse.areAnswersCompleted(response)) {
            this.sendCancelParse(wf, response);
        }
    }

    private void cancelRequest(@NotNull ClangAbstractRequest<?, ?> request) {
        if (!ClangdLanguageService.isCanceled(request) && !request.getResponse().isDone()) {
            this.myRequestsPlanner.sendImmediately(request.cancel());
            ClangdLanguageService.setCanceled(request);
        }
    }

    private void sendCancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (!ClangdLanguageService.isCanceled((UserDataHolder)response)) {
            this.myRequestsPlanner.send(new ClangCancelParseNotification(this.myContext, response));
            ClangdLanguageService.setCanceled((UserDataHolder)response);
            ClangParseResponse.completeAnswersExceptionally(response, new CancellationException());
        }
    }

    @NotNull
    private static <T> T computeIfAbsent(@NotNull UserDataHolder holder, @NotNull Key<T> key, @NotNull Producer<T> producer) {
        Object data = holder.getUserData(key);
        if (data == null) {
            data = producer.produce();
            assert (data != null);
            holder.putUserData(key, data);
        }
        return (T)data;
    }

    @Override
    @NotNull
    public ClangLocalWorkspace getLocalWorkspace() {
        return this.myWorkspace;
    }

    @Override
    @NotNull
    public String getClangdModulesPath() {
        return this.myContext.getClangdModulesPath();
    }

    @Override
    @NotNull
    public String getCpp20ModulesPath() {
        return this.myContext.getCpp20ModulesPath();
    }

    @Override
    public boolean isIndexer() {
        return this.myContext.isIndexer();
    }

    @Override
    @NotNull
    public CompletableFuture<ClangPreprocessedReport> generatePreprocessedReport(@NotNull List<String> urls) {
        CompletableFuture<ClangPreprocessedReport> result = new CompletableFuture<ClangPreprocessedReport>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashReport").action((server, ws) -> {
            ArrayList<CompletionStage> crashReportFutures = new ArrayList<CompletionStage>();
            for (String url : urls) {
                String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
                ClionReparseTextDocumentParams cc = ws.getReparseParams(url);
                String macros = StringUtil.notNullize((String)ws.getContent(macrosUrl));
                if (cc != null) {
                    ClangParseResponse lastParseResponse = this.myContext.getLocalWorkspace().apply(url, wf -> wf.getLastParseResponse());
                    crashReportFutures.add(((CompletableFuture)server.clionPreprocessFile(cc.getCompilationCommand()).thenApply(res -> ClangdLanguageService.createPreprocessedFile(this.myContext.getUrlConverter().fromUrl(url), cc, macros, lastParseResponse, res, null))).exceptionally(ex -> ClangdLanguageService.createPreprocessedFile(this.myContext.getUrlConverter().fromUrl(url), cc, macros, lastParseResponse, null, ex)));
                    continue;
                }
                LOG.warn("Failed to get compilation command for previously parsed file " + url);
            }
            CompletableFuture.allOf(crashReportFutures.toArray(new CompletableFuture[0])).whenComplete((res, ex) -> {
                if (ex != null) {
                    LOG.warn("Failed to generate crash reports!", ex);
                    result.complete(null);
                    return;
                }
                try {
                    ArrayList<ClangPreprocessedReport.PreprocessedFile> crashReports = new ArrayList<ClangPreprocessedReport.PreprocessedFile>();
                    for (CompletableFuture reportFuture : crashReportFutures) {
                        assert (reportFuture.isDone());
                        ClangPreprocessedReport.PreprocessedFile file = (ClangPreprocessedReport.PreprocessedFile)reportFuture.get();
                        if (file == null) continue;
                        crashReports.add(file);
                    }
                    result.complete(new ClangPreprocessedReport(crashReports));
                }
                catch (InterruptedException | ExecutionException ee) {
                    LOG.warn((Throwable)ee);
                    result.complete(null);
                }
            });
        }).requiresRecover().onSkipped(() -> result.complete(null)).onRejected(() -> result.complete(null)).create());
        return result;
    }

    private static @Nullable ClangPreprocessedReport.PreprocessedFile createPreprocessedFile(@NotNull String path, @NotNull ClionReparseTextDocumentParams cc, @NotNull String macros, @Nullable ClangParseResponse lastParseReponse, @Nullable CLionClangPreprocessResult ppRes, @Nullable Throwable ex) {
        List lastDiagsList;
        Supplier lastDiagsSupplier;
        if (ppRes == null && ex == null) {
            return null;
        }
        String lastDiags = null;
        if (lastParseReponse != null && (lastDiagsSupplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(lastParseReponse.getDiagnostics())) != null && (lastDiagsList = (List)lastDiagsSupplier.get()) != null) {
            StringBuilder lastDiagsBuilder = new StringBuilder();
            for (ClangDiagnostic lastDiag : lastDiagsList) {
                lastDiagsBuilder.append(lastDiag.toString()).append("\n");
            }
            lastDiags = lastDiagsBuilder.toString();
        }
        String clangTidyConfig = "";
        String clionClangTidyConfig = "";
        if (cc.getClangTidyOptions() != null) {
            clangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getConfig());
            clionClangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getClionConfig());
        }
        String clazyConfig = "";
        if (cc.getClazyOptions() != null) {
            clazyConfig = StringUtil.notNullize((String)cc.getClazyOptions().getConfig());
        }
        UnusedIncludesInspectionMode uiMode = cc.getUnusedIncludesInspectionMode() != null ? cc.getUnusedIncludesInspectionMode() : UnusedIncludesInspectionMode.Off;
        String diags = ppRes != null ? ppRes.getDiags() : "";
        String ppBody = ppRes != null ? ppRes.getPpOutput() : ExceptionUtil.getThrowableText((Throwable)ex);
        return new ClangPreprocessedReport.PreprocessedFile(path, lastDiags, cc.getCompilationCommand().getCommandLine(), clangTidyConfig, clionClangTidyConfig, clazyConfig, cc.getDFAOptions(), uiMode, diags, ppBody, macros);
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        ClangUtils.warnClangd(LOG, "Stopping " + this.getClass().getSimpleName() + "\n" + this.myContext.getLocalWorkspace().printStats("  ") + this.myContext.getCrashHandler().printStats("  Blacklist: "));
        Disposer.dispose((Disposable)this.myContext);
        return this.myRequestsPlanner.stop();
    }

    @Override
    public int getVersion(@NotNull VirtualFile file) {
        return this.myWorkspace.apply(file.getUrl(), wf -> wf.getVersion());
    }

    @Override
    @NotNull
    public CompletableFuture<ClionPublishDiagnosticsParams> checkPreprocessedCase(@NotNull File crashCase, @NotNull FullCompilationInfo ccInfo) {
        ClangUrlConverter conv = this.myContext.getUrlConverter();
        String crashCaseUri = conv.toUri(crashCase, false);
        CLionCheckPreprocessedCaseParams params = new CLionCheckPreprocessedCaseParams(crashCaseUri, new ClionReparseTextDocumentParams(new VersionedTextDocumentIdentifier(crashCaseUri, Integer.valueOf(1)), new ClionCompileCommandParams(conv.toUri(new File(ccInfo.targetFile), false), conv.toUri(new File(ccInfo.entryFile), false), new File(ccInfo.entryFile).getParent(), ccInfo.compilationCommand, "/dev/null", ccInfo.usePredefines), new ClionClangTidyConfigParams(ccInfo.ourClangTidyConfig, ccInfo.clangTidyConfig, false), ccInfo.unusedMode, new CLionClazyConfigParams(ccInfo.clazyConfig), ClionWantDiagnostics.Yes, ccInfo.dfaOptions, ccInfo.globalCompletionCacheParams, 0));
        CompletableFuture<ClionPublishDiagnosticsParams> result = new CompletableFuture<ClionPublishDiagnosticsParams>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("checkPreprocessedCase").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionCheckPreprocessedCase(params)))).onRejected(() -> result.complete(null)).onSkipped(() -> result.complete(null)).create());
        return result;
    }

    @Override
    public boolean hadCrashes() {
        return this.myContext.getCrashHandler().hadCrashes();
    }

    @Override
    public boolean notifyDocumentOpened(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return false;
            }
            ClangdLanguageService.addOpenRequest(wf, openRequestId);
            if (!wf.isOpened()) {
                Document document = this.myContext.getIdeFacade().getDocument(file);
                wf.preambleChanged(ClangUtils.skipPreamble(document));
                int nextVersion = wf.nextOpen();
                this.myRequestsPlanner.send(ClangOpenNotification.create(this.myContext, file, nextVersion));
            }
            return true;
        });
    }

    private static void addOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        Map<OpenRequestId, Integer> openRequests = wf.getOrDefault(OPEN_REQUESTS);
        if (id.ignoreSame()) {
            openRequests.putIfAbsent(id, 1);
        } else {
            openRequests.merge(id, 1, Integer::sum);
        }
    }

    @Override
    public void notifyDocumentClosed(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        String url = file.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            if (!this.isAcceptable(file)) {
                return;
            }
            if (!workspaceFile.isOpened()) {
                return;
            }
            if (ClangdLanguageService.removeOpenRequest(workspaceFile, openRequestId)) {
                boolean isSaved = !this.myIdeFacade.isModified(file);
                ClangFileFacade helper = this.myIdeFacade.getFileFacade(file);
                String content = helper != null ? helper.getText().toString() : "";
                workspaceFile.preambleChanged(workspaceFile.getPreambleBounds());
                int nextVersion = workspaceFile.nextClose();
                this.myRequestsPlanner.send(ClangCloseNotification.create(this.myContext, workspaceFile.getUrl(), nextVersion, content, isSaved));
                if (macrosWorkspaceFile.getVersion() >= 0) {
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, macrosWorkspaceFile.getUrl(), macrosWorkspaceFile.nextDelete()));
                }
            }
        });
    }

    @NotNull
    private static CharSequence notNullize(@Nullable CharSequence seq) {
        return seq != null ? seq : "";
    }

    private static boolean removeOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        Map<OpenRequestId, Integer> openRequests = wf.get(OPEN_REQUESTS);
        if (openRequests.containsKey(id)) {
            openRequests.merge(id, -1, (oldV, newV) -> oldV + newV > 0 ? Integer.valueOf(oldV + newV) : null);
            return openRequests.isEmpty();
        }
        return false;
    }

    @Override
    public void notifyDocumentChanged(@NotNull VirtualFile file, @NotNull DocumentEvent event) {
        this.myWorkspace.modifyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            int editLine = event.getDocument().getLineNumber(event.getOffset());
            if (editLine <= wf.getPreambleBounds()) {
                wf.preambleChanged(ClangUtils.skipPreamble(event.getDocument()));
            }
            int nextVersion = wf.nextChange();
            DidChangeTextDocumentParams params = this.prepareChangeParams(event, file, nextVersion);
            boolean isSaved = !this.myIdeFacade.isModified(file);
            this.myRequestsPlanner.send(ClangChangeNotification.create(this.myContext, wf.getUrl(), nextVersion, params, isSaved));
        });
    }

    @Override
    public void notifyDocumentChanged(@NotNull String url, @NotNull String content) {
        this.myWorkspace.modifyWithRead(url, wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return;
            }
            wf.preambleChanged(ClangUtils.skipPreamble(content));
            int nextVersion = wf.nextChange();
            DidChangeTextDocumentParams params = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(this.myContext.getUrlConverter().toUriFromUrl(url), Integer.valueOf(nextVersion)), Collections.singletonList(new TextDocumentContentChangeEvent(content)));
            this.myRequestsPlanner.send(ClangChangeNotification.create(this.myContext, wf.getUrl(), nextVersion, params, false));
        });
    }

    @NotNull
    private DidChangeTextDocumentParams prepareChangeParams(@NotNull DocumentEvent event, @NotNull VirtualFile file, int version) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
        ServerCapabilities serverCapabilities = this.myRequestsPlanner.getServerAccessor().getCapabilities();
        if (serverCapabilities != null) {
            syncKind = serverCapabilities.getTextDocumentSync().isLeft() ? (TextDocumentSyncKind)serverCapabilities.getTextDocumentSync().getLeft() : ((TextDocumentSyncOptions)serverCapabilities.getTextDocumentSync().getRight()).getChange();
        }
        Document document = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
        switch (syncKind) {
            case Incremental: {
                changeEvent.setText(ClangdLanguageService.notNullize(this.myIdeFacade.getFileFacade(file, document).getText()).toString());
                break;
            }
            case None: 
            case Full: {
                changeEvent.setText(document.getText());
            }
        }
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
        docId.setUri(this.myContext.getUrlConverter().toUri(file));
        docId.setVersion(Integer.valueOf(version));
        return new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReparseRequired(@NotNull VirtualFile file) {
        ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
        try {
            String url = file.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return;
            }
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
                LocalWorkspaceFile wf = (LocalWorkspaceFile)files.get(url);
                assert (wf != null) : "requested file must not be null!";
                LocalWorkspaceFile macrosWf = (LocalWorkspaceFile)files.get(macrosUrl);
                assert (macrosWf != null) : "requested macros file must not be null!";
                this.notifyReparseRequiredImpl(file, wf, macrosWf, deferrer);
            });
        }
        finally {
            deferrer.runDeferred();
        }
    }

    @Nullable
    private ClangParseResponse notifyReparseRequiredImpl(@NotNull VirtualFile file, @NotNull LocalWorkspaceFile workspaceFile, @NotNull LocalWorkspaceFile macrosWorkspaceFile, @NotNull ClangHeavyRequestBuilder deferrer) {
        if (this.myContext.getProject().isDisposed()) {
            ClangUtils.warnClangd(LOG, "Will not reparse file " + file.getName() + " because project is already disposed.");
            return null;
        }
        if (!this.isAcceptable(file)) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not acceptable.");
            return null;
        }
        if (!workspaceFile.isOpened()) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not opened locally.");
            return null;
        }
        ClangParseResponse prevResponse = workspaceFile.getLastParseResponse();
        ClangParseResponse response = workspaceFile.nextParse(file, true);
        response.putUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER, this.myIdeFacade.getPsiModificationCounter(this.myProject));
        response.putUserData(ClangParseResponse.PROFILE_MODIFICATION_COUNTER, this.myProfileModificationCounter.get());
        this.cancelParseGently(workspaceFile, prevResponse);
        String macrosUrl = macrosWorkspaceFile.getUrl();
        File macrosPath = new File(this.myContext.getUrlConverter().fromUrl(macrosUrl));
        int macrosVersion = macrosWorkspaceFile.nextChange();
        this.myRequestsPlanner.send(ClangReparseNotification.createPromise(deferrer, this.myContext, file, response, macrosUrl, macrosPath, macrosVersion));
        return response;
    }

    @Override
    public void notifyDocumentSaved(@NotNull VirtualFile file) {
        this.myWorkspace.modifyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            this.myRequestsPlanner.send(new ClangSaveRequest(this.myContext, wf.getUrl()));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<? extends ClangCommandLineArgument>> parseCommandLine(@NotNull List<String> switches, @Nullable EnumSet<ClangOptionsFlags> flagsToInclude, @Nullable EnumSet<ClangOptionsFlags> flagsToExclude) {
        ClangCommandLine commandLine = new ClangCommandLine(switches, ClangdLanguageService.flagsEnumSetToBitField(flagsToInclude), ClangdLanguageService.flagsEnumSetToBitField(flagsToExclude));
        ClangParseCommandLineRequest request = new ClangParseCommandLineRequest(commandLine);
        this.myRequestsPlanner.sendImmediately(request);
        return request.getResponse();
    }

    private static int flagsEnumSetToBitField(@Nullable EnumSet<ClangOptionsFlags> flags) {
        if (flags == null) {
            return 0;
        }
        int bitField = 0;
        for (ClangOptionsFlags flag : flags) {
            bitField |= flag.getValue();
        }
        return bitField;
    }

    @Override
    public void notifyDocumentMoved(@NotNull VirtualFile newFile, @NotNull String oldUrl, @NotNull String newUrl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (newUrl.contentEquals(newFile.getUrl()));
        if (oldUrl.contentEquals(newUrl)) {
            return;
        }
        String oldMacrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, oldUrl);
        this.myWorkspace.modifyWithRead(Arrays.asList(oldUrl, newUrl, oldMacrosUrl), mapOfFiles -> {
            LocalWorkspaceFile oldWf = (LocalWorkspaceFile)mapOfFiles.get(oldUrl);
            LocalWorkspaceFile oldMacrosWf = (LocalWorkspaceFile)mapOfFiles.get(oldMacrosUrl);
            LocalWorkspaceFile newWf = (LocalWorkspaceFile)mapOfFiles.get(newUrl);
            ApplicationManager.getApplication().assertReadAccessAllowed();
            boolean oldIsAcceptable = oldWf.getVersion() > 0;
            boolean oldIsOpened = oldWf.isOpened();
            boolean newIsAcceptable = this.isAcceptable(newFile);
            if (oldIsAcceptable && newIsAcceptable) {
                if (oldIsOpened) {
                    Map<OpenRequestId, Integer> newOpenRequests = newWf.getOrDefault(OPEN_REQUESTS);
                    Map<OpenRequestId, Integer> oldOpenRequests = oldWf.getOrDefault(OPEN_REQUESTS);
                    oldOpenRequests.forEach((id, counter) -> newOpenRequests.merge((OpenRequestId)id, (Integer)counter, Integer::sum));
                    oldOpenRequests.clear();
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                    this.myRequestsPlanner.send(ClangOpenNotification.create(this.myContext, newFile, newWf.nextOpen()));
                } else {
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.sendContent(newWf, newFile);
                }
            } else if (oldIsAcceptable) {
                Map<OpenRequestId, Integer> oldEditors = oldWf.getOrDefault(OPEN_REQUESTS);
                oldEditors.clear();
                this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                if (oldIsOpened) {
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                }
            } else if (newIsAcceptable) {
                List<OpenRequestId> openRequests = this.myIdeFacade.getOpenRequests(this.myProject, newFile);
                for (OpenRequestId openRequest : openRequests) {
                    this.notifyDocumentOpened(newFile, openRequest);
                }
                if (!newWf.isOpened() && this.myIdeFacade.isModified(newFile)) {
                    this.sendContent(newWf, newFile);
                }
            }
        });
    }

    @Override
    public void notifySetCDB(@NotNull Collection<VirtualFile> forFiles) {
        ArrayList<ClionCompileCommandParams> commands = new ArrayList<ClionCompileCommandParams>();
        ArrayList<String> macrosPaths = new ArrayList<String>();
        ArrayList<String> macrosContents = new ArrayList<String>();
        for (VirtualFile file : forFiles) {
            String macrosPath;
            ClangUrlConverter urlConv = this.myContext.getUrlConverter();
            ClangdCompilationCommand command = (ClangdCompilationCommand)ReadAction.compute(() -> this.lambda$notifySetCDB$61(urlConv, file, macrosPath = ClangRequestsHelper.getMacrosFilePath(this.myContext, file.getUrl()).getPath()));
            if (command == null) continue;
            commands.add(command.ccParams);
            macrosPaths.add(macrosPath);
            macrosContents.add(command.ppDefines);
        }
        ClionSetCDBParams newCDB = new ClionSetCDBParams(commands, macrosPaths, macrosContents);
        this.myRequestsPlanner.sendImmediately(new ClangSetCDBNotification(newCDB));
    }

    @NotNull
    private TextDocumentIdentifier convertPathToDoc(@NotNull String path) {
        return new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(new File(path), false));
    }

    @Override
    public void notifyLoadIndex(@NotNull List<String> deletedPaths, @NotNull String symbolsDirPath) {
        List deletedPathsDocs = ContainerUtil.map(deletedPaths, p -> this.convertPathToDoc((String)p));
        TextDocumentIdentifier dirPath = this.convertPathToDoc(symbolsDirPath);
        ClionReloadIndexParams NotifParams = new ClionReloadIndexParams(deletedPathsDocs, dirPath);
        this.myRequestsPlanner.sendImmediately(new ClangReloadIndexNotification(NotifParams));
    }

    @Override
    public void notifyLoadGraph(@NotNull String path) {
        this.myRequestsPlanner.sendImmediately(new ClangReloadGraphNotification(this.convertPathToDoc(path)));
    }

    @Override
    public void notifyIndexPartFinished(@NotNull String path) {
        this.myRequestsPlanner.sendImmediately(new ClangIndexPartFinishedNotification(this.convertPathToDoc(path)));
    }

    @Nullable
    public Endpoint remoteEndpoint() {
        return this.myRequestsPlanner.getServerAccessor().getRemoteEndpoint();
    }

    @Nullable
    public ServerConnection serverConnection() {
        return this.myRequestsPlanner.getServerAccessor().getServerConnection();
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> startUpServer() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        ServerConnection connection = this.myRequestsPlanner.getServerAccessor().getServerConnection();
        if (connection == null || !connection.isActive()) {
            this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("startUpServer").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> result.complete(true))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).create());
        } else {
            result.complete(true);
        }
        return result;
    }

    @Override
    @NotNull
    public ClangStopData shutDownServer() {
        return this.myRequestsPlanner.getServerAccessor().shutDown();
    }

    @Override
    public boolean isFileBanned(@NotNull String url) {
        return !ClangRequestsHelper.isAllowedByGuard(this.myContext, url);
    }

    @Override
    public void debugDumpServerState() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpServerState").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDumpServerState())).create());
    }

    @Override
    public String debugDumpUsages(@NotNull String url) {
        if (!Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            return "Did you forgot to turn on 'clion.clang.clangd.debug.cancellation'?\n";
        }
        BiConsumer<StringBuilder, UserDataHolder> usagesDumper = (sb, usedObject) -> {
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            sb.append("usage counter = ").append(usages != null ? usages.id2Stack.size() : 0).append("\n");
            if (usages != null && !usages.id2Stack.isEmpty()) {
                usages.id2Stack.values().forEach(ex -> {
                    sb.append("=== Usage:");
                    if (ex != null) {
                        StackTraceElement[] stackTrace = ex.getStackTrace();
                        for (int i = 0; i < Math.min(stackTrace.length, 20); ++i) {
                            StackTraceElement trace = stackTrace[i];
                            sb.append("  ").append(trace.toString()).append("\n");
                        }
                    } else {
                        sb.append(" stack trace is not available. Did you forgot to turn on 'clion.clang.clangd.debug.cancellation'?\n");
                    }
                });
            }
        };
        return this.myWorkspace.apply(url, wf -> {
            StringBuilder sb = new StringBuilder();
            Set<UserDataHolder> set = this.myDebugUsagesSet;
            synchronized (set) {
                for (UserDataHolder holder : this.myDebugUsagesSet) {
                    if (holder instanceof ClangParseResponse) {
                        ClangParseResponse response = (ClangParseResponse)holder;
                        sb.append("Parse ").append(response.getVersion()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)response) ? "canceled" : "not canceled").append(", ").append(response.isCancellable() ? "cancellable" : "not cancellable").append(", ").append(ClangParseResponse.areAnswersCompleted(response) ? "completed" : "not completed").append(", ");
                        usagesDumper.accept(sb, (UserDataHolder)response);
                        continue;
                    }
                    if (!(holder instanceof ClangASTReadRequest)) continue;
                    ClangASTReadRequest request = (ClangASTReadRequest)holder;
                    sb.append(request.getClass().getSimpleName()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)request) ? "canceled" : "not canceled").append(", ").append(request.getResponse().isDone() ? "completed" : "not completed").append(", ");
                    usagesDumper.accept(sb, (UserDataHolder)request);
                }
            }
            return sb.toString();
        });
    }

    @Override
    @NotNull
    public CompletableFuture<ClangMemoryUsageInfo> debugDumpMemoryStat() {
        CompletableFuture<ClangMemoryUsageInfo> answer = new CompletableFuture<ClangMemoryUsageInfo>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpMemoryStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpMemoryStat().whenComplete((info, ex) -> {
            if (ex != null) {
                answer.completeExceptionally((Throwable)ex);
                return;
            }
            ClangMemoryUsageInfo memoryUsageInfo = new ClangMemoryUsageInfo(info.getWorkingSet(), info.getDrafts(), info.getUnsaved(), ContainerUtil.map(info.getPerFile(), p -> new ClangMemoryUsageInfo.PerFile(p.getPath(), p.getKb())));
            answer.complete(memoryUsageInfo);
            this.myIdeFacade.sendMessageLater(() -> {
                if (this.myContext.canPublishMessage()) {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMemoryUsageInfoReceived(memoryUsageInfo);
                }
            });
        }))).onSkipped(() -> answer.complete(null)).onRejected(() -> answer.complete(null)).create());
        return answer;
    }

    @Override
    public void debugCrashServer() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashServer").action((Consumer<? super ClangServer>)((Consumer)server -> {
            server.shutdown();
            server.exit();
        })).create());
    }

    @Override
    public void waitUntilTasksFinished() {
        if (this.isActive()) {
            this.myRequestsPlanner.waitUntilTasksFinished();
        }
    }

    @Override
    public int getServerPid() {
        return ClangLanguageServiceUtils.getServerPid(this.serverConnection());
    }

    @Override
    @NonNls
    @NotNull
    public String getNativeStacktrace() {
        return ClangLanguageServiceUtils.getNativeStacktrace(this.serverConnection());
    }

    @NotNull
    private <T> CompletableFuture<T> withOpenedFile(@NotNull VirtualFile file, @NotNull Function<LocalWorkspaceFile, CompletableFuture<T>> consumer) {
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            if (!wf.isOpened()) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)consumer.apply((LocalWorkspaceFile)wf);
        });
    }

    @Nullable
    private ClangParseResponse getOrParse(@NotNull VirtualFile file, @NotNull LocalWorkspaceFile workspaceFile, @NotNull LocalWorkspaceFile macrosWorkspaceFile, @Nullable ClangHeavyRequestBuilder deferrer) {
        if (!workspaceFile.isOpened()) {
            return null;
        }
        ClangParseResponse reparsedFile = workspaceFile.getLastParseResponse();
        if (reparsedFile != null) {
            if (reparsedFile.getVersion() < workspaceFile.getVersion()) {
                reparsedFile = null;
            } else if (ClangdLanguageService.isCanceled((UserDataHolder)reparsedFile)) {
                reparsedFile = null;
            } else if (ClangParseResponse.isInFailedState(reparsedFile)) {
                reparsedFile = null;
            } else {
                Long lastReparsedAtCounter = (Long)reparsedFile.getUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER);
                Long currentCounter = this.myIdeFacade.getPsiModificationCounter(this.myProject);
                if (currentCounter != null && lastReparsedAtCounter != null && currentCounter > lastReparsedAtCounter) {
                    reparsedFile = null;
                } else {
                    Long lastReparsedProfileCounter = (Long)reparsedFile.getUserData(ClangParseResponse.PROFILE_MODIFICATION_COUNTER);
                    long curProfileModCounter = this.myProfileModificationCounter.get();
                    if (lastReparsedProfileCounter != null && curProfileModCounter > lastReparsedProfileCounter) {
                        reparsedFile = null;
                    }
                }
            }
        }
        if (reparsedFile == null && deferrer != null) {
            reparsedFile = this.notifyReparseRequiredImpl(file, workspaceFile, macrosWorkspaceFile, deferrer);
        }
        return reparsedFile;
    }

    @Nullable
    private ClangGotoDefinitionRequest sendGotoDefinition(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        ClangGotoDefinitionRequest cachedAnswer = (ClangGotoDefinitionRequest)this.myGotoDefinitionCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange = this.getParamsAndRange(file, offset);
        if (paramsAndRange == null) {
            return null;
        }
        ClangGotoDefinitionRequest gotoRequest = new ClangGotoDefinitionRequest(this.myContext, wf, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(gotoRequest);
        ClangdLanguageService.cacheGotoRequest(this.myGotoDefinitionCache, requestCacheKey, gotoRequest, reparse, (TextRange)paramsAndRange.second);
        return gotoRequest;
    }

    @Nullable
    private ClangGotoTypeDeclarationRequest sendGotoTypeDeclaration(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        ClangGotoTypeDeclarationRequest cachedAnswer = (ClangGotoTypeDeclarationRequest)this.myGotoTypeDeclarationCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange = this.getParamsAndRange(file, offset);
        if (paramsAndRange == null) {
            return null;
        }
        ClangGotoTypeDeclarationRequest gotoRequest = new ClangGotoTypeDeclarationRequest(this.myContext, wf, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(gotoRequest);
        ClangdLanguageService.cacheGotoRequest(this.myGotoTypeDeclarationCache, requestCacheKey, gotoRequest, reparse, (TextRange)paramsAndRange.second);
        return gotoRequest;
    }

    @Nullable
    private ClangClionHoverInfoRequest sendClionHoverInfo(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HoverInfoKey hoverInfoKey = new HoverInfoKey(file.getUrl(), offset);
        ClangClionHoverInfoRequest cachedAnswer = (ClangClionHoverInfoRequest)this.myContentDependentCache.getHoverInfoCache().get(hoverInfoKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange = this.getParamsAndRange(file, offset);
        if (paramsAndRange == null) {
            return null;
        }
        ClangClionHoverInfoRequest hoverInfoRequest = new ClangClionHoverInfoRequest(wf.getUrl(), (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(hoverInfoRequest);
        this.myContentDependentCache.getHoverInfoCache().put(hoverInfoKey, hoverInfoRequest);
        return hoverInfoRequest;
    }

    @Nullable
    private ClangClionLineMarkersRequest sendClionLineMarkers(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int fromOffset, int toOffset, boolean fast) {
        LineMarkersKey lineMarkersCacheKey = new LineMarkersKey(file.getUrl(), fromOffset, toOffset, fast);
        ClangClionLineMarkersRequest cachedAnswer = (ClangClionLineMarkersRequest)this.myContentDependentCache.getLineMarkersCache().get(lineMarkersCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            return null;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        Range lspRange = ClangLanguageServiceUtils.offsets2Range(document, fromOffset, toOffset);
        ClangClionLineMarkersRequest request = new ClangClionLineMarkersRequest(wf.getUrl(), docIdent, lspRange, fast);
        this.myRequestsPlanner.send(request);
        this.myContentDependentCache.getLineMarkersCache().put(lineMarkersCacheKey, request);
        return request;
    }

    @Nullable
    private ClangTestLineMarkersRequest sendClionTestLineMarkers(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, @NotNull List<String> enabledFrameworkNames) {
        TestLineMarkersKey cacheKey = new TestLineMarkersKey(file.getUrl(), enabledFrameworkNames);
        ClangTestLineMarkersRequest cachedAnswer = (ClangTestLineMarkersRequest)this.myContentDependentCache.getTestLineMarkersCache().get(cacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            return null;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        ClangTestLineMarkersRequest request = new ClangTestLineMarkersRequest(wf.getUrl(), docIdent, enabledFrameworkNames);
        this.myRequestsPlanner.send(request);
        this.myContentDependentCache.getTestLineMarkersCache().put(cacheKey, request);
        return request;
    }

    @NotNull
    private ClangInlayHintsRequest sendInlayHints(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, @Nullable ClionClangNamehintConfigParams parameterConfig, @Nullable ClionClangTypehintConfigParams typeConfig) {
        ClangInlayHintsRequest cachedAnswer;
        boolean isLightVirtualFile = file instanceof LightVirtualFile;
        InlayHintsKey cacheKey = new InlayHintsKey(file.getUrl(), parameterConfig, typeConfig);
        if (!isLightVirtualFile && (cachedAnswer = (ClangInlayHintsRequest)this.myContentDependentCache.getInlayHintsCache().get(cacheKey)) != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        ClangInlayHintsRequest request = new ClangInlayHintsRequest(this.myContext, wf.getUrl(), file, docIdent, parameterConfig, typeConfig);
        this.myRequestsPlanner.send(request);
        if (!isLightVirtualFile) {
            this.myContentDependentCache.getInlayHintsCache().put(cacheKey, request);
        }
        return request;
    }

    @Nullable
    private ClangSignatureHelpRequest sendSignatureHelp(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        SignatureHelpKey cacheKey = new SignatureHelpKey(file.getUrl(), offset);
        ClangSignatureHelpRequest cachedAnswer = (ClangSignatureHelpRequest)this.myContentDependentCache.getSignatureHelpCache().get(cacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return null;
        }
        ClangSignatureHelpRequest request = new ClangSignatureHelpRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(request);
        this.myContentDependentCache.getSignatureHelpCache().put(cacheKey, request);
        return request;
    }

    @Nullable
    private ClangFindUsagesRequest sendFindUsages(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        Pair paramsAndRange = this.findLine(file, offset, (text, lineColumn) -> {
            TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
            Position position = new Position(lineColumn.line, lineColumn.column);
            TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
            return Pair.create((Object)params, (Object)ClangUtils.findIdentifierRange(text, offset));
        });
        if (paramsAndRange == null) {
            return null;
        }
        ClangFindUsagesRequest request = new ClangFindUsagesRequest(wf, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(request);
        return request;
    }

    @Nullable
    private ClangGetLocalVariablesRequest sendGetLocalVariables(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int line) {
        TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        Position position = new Position(line, 0);
        TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
        ClangGetLocalVariablesRequest request = new ClangGetLocalVariablesRequest(this.myContext, wf, params);
        this.myRequestsPlanner.send(ClangGetLocalVariablesRequest.createPromise(this.myContext, request));
        return request;
    }

    @Nullable
    private ClangDumpASTRequest sendDumpAST(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return null;
        }
        ClangDumpASTRequest dumpASTRequest = new ClangDumpASTRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(dumpASTRequest);
        return dumpASTRequest;
    }

    @NotNull
    private CompletableFuture<String> sendRequestClangFormatConfiguration(@NotNull VirtualFile file) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, 0);
        if (params == null) {
            return CompletableFuture.completedFuture(null);
        }
        ClangFormatConfigurationRequest formatConfigurationRequest = new ClangFormatConfigurationRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(formatConfigurationRequest);
        return formatConfigurationRequest.getResponse();
    }

    @Nullable
    private ClangDumpTokensRequest sendDumpTokens(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return null;
        }
        ClangDumpTokensRequest request = new ClangDumpTokensRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(request);
        return request;
    }

    @NotNull
    private static FormattingOptions buildFormattingOptions(@Nullable String style) {
        FormattingOptions options = new FormattingOptions(4, true);
        if (style != null) {
            options.putString("style", "#yaml\n" + style);
        }
        return options;
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendFormatRangeRequest(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style, int cursorOffset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        FormattingOptions options = ClangdLanguageService.buildFormattingOptions(style);
        options.putString("code", document.getText());
        Position cursorPosition = cursorOffset < 0 ? new Position(-1, -1) : ClangLanguageServiceUtils.offset2LspPos(document, cursorOffset);
        CLionDocumentRangeFormattingParams params = new CLionDocumentRangeFormattingParams(identifier, options, new Range(ClangLanguageServiceUtils.offset2LspPos(document, range.getStartOffset()), ClangLanguageServiceUtils.offset2LspPos(document, range.getEndOffset())), cursorPosition);
        ClangFormatRangeRequest request = new ClangFormatRangeRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(request);
        return request.getResponse();
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendIndentRequest(@NotNull VirtualFile file, int lineStartOffset, @Nullable String style) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams(ClangLanguageServiceUtils.offset2LspPos(document, lineStartOffset), "\n");
        params.setTextDocument(identifier);
        FormattingOptions options = ClangdLanguageService.buildFormattingOptions(style);
        options.putString("code", document.getText());
        params.setOptions(options);
        ClangIndentRequest request = new ClangIndentRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(request);
        return request.getResponse();
    }

    @NotNull
    private ClangCompletionRequest sendRequestComplete(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CompletionTriggerKind kind, @NotNull CLionCompletionKind completionKind, Pair<Integer, ArrayList<String>> postfixTemplates) {
        CLionCompletionParams params = this.toCompletionParams(file, line, column, fileText, completionKind, postfixTemplates);
        CompletionContext context = new CompletionContext();
        context.setTriggerKind(kind);
        params.setContext(context);
        ClangCompletionRequest request = new ClangCompletionRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(request);
        return request;
    }

    @Nullable
    private Pair<TextDocumentIdentifier, Position> textDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        return this.findLine(file, offset, (text, lineColumn) -> Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file)), (Object)new Position(lineColumn.line, lineColumn.column)));
    }

    private <R> R findLine(@NotNull VirtualFile file, int offset, @NotNull BiFunction<CharSequence, LineColumn, R> lineConsumer) {
        CharSequence content;
        ClangFileFacade helper = this.myIdeFacade.getFileFacade(file);
        LineColumn lineColumn = helper != null ? helper.getLineColumn(offset) : null;
        CharSequence charSequence = content = helper != null ? helper.getText() : null;
        if (content == null || lineColumn == null) {
            return null;
        }
        return lineConsumer.apply(content, lineColumn);
    }

    private static <T> void cacheGotoRequest(@NotNull Cache<GotoDefinitionKey, T> cache, @NotNull GotoDefinitionKey requestCacheKey, @NotNull T gotoRequest, @NotNull ClangParseResponse reparse, @Nullable TextRange range) {
        if (range != null) {
            for (int cacheOffset = range.getStartOffset(); cacheOffset < range.getEndOffset(); ++cacheOffset) {
                cache.put((Object)new GotoDefinitionKey(reparse, cacheOffset), gotoRequest);
            }
        } else {
            cache.put((Object)requestCacheKey, gotoRequest);
        }
    }

    @Nullable
    private Pair<TextDocumentPositionParams, TextRange> getParamsAndRange(@NotNull VirtualFile file, int offset) {
        return this.findLine(file, offset, (text, lineColumn) -> {
            TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
            Position position = new Position(lineColumn.line, lineColumn.column);
            TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
            return Pair.create((Object)params, (Object)ClangUtils.findIdentifierRange(text, offset));
        });
    }

    @Nullable
    private TextDocumentPositionParams toTextDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        Pair<TextDocumentIdentifier, Position> params = this.textDocumentPositionParams(file, offset);
        if (params == null) {
            return null;
        }
        return new TextDocumentPositionParams((TextDocumentIdentifier)params.first, (Position)params.second);
    }

    @NotNull
    private CLionCompletionParams toCompletionParams(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CLionCompletionKind completionKind, Pair<Integer, ArrayList<String>> postfixTemplates) {
        Pair params = Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file)), (Object)new Position(line, column));
        return new CLionCompletionParams((TextDocumentIdentifier)params.first, (Position)params.second, fileText, completionKind, (Integer)postfixTemplates.first, (List)postfixTemplates.second);
    }

    private void sendContent(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile virtFile) {
        CharSequence fileText;
        ClangFileFacade helper = this.myIdeFacade.getFileFacade(virtFile);
        CharSequence charSequence = fileText = helper != null ? helper.getText() : null;
        if (fileText != null) {
            wf.preambleChanged(ClangUtils.skipPreamble(fileText));
            int nextVersion = wf.nextChange();
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(fileText.toString());
            VersionedTextDocumentIdentifier id = new VersionedTextDocumentIdentifier();
            id.setUri(this.myContext.getUrlConverter().toUri(virtFile));
            id.setVersion(Integer.valueOf(nextVersion));
            this.myRequestsPlanner.send(ClangChangeNotification.create(this.myContext, wf.getUrl(), nextVersion, new DidChangeTextDocumentParams(id, Collections.singletonList(changeEvent)), false));
        }
    }

    private boolean isAcceptable(@NotNull VirtualFile file) {
        return this.myContext.getUrlConverter().isAcceptable(file.getUrl()) && ClangdBridge.isSupported(this.myProject, file);
    }

    private /* synthetic */ ClangdCompilationCommand lambda$notifySetCDB$61(ClangUrlConverter urlConv, VirtualFile file, String macrosPath) throws RuntimeException {
        return this.myIdeFacade.getCompilationCommand(urlConv, this.myProject, file, macrosPath);
    }

    private static class UsagesInfo {
        @NotNull
        final Map<Integer, Exception> id2Stack = new HashMap<Integer, Exception>(12);
        int nextID = 0;

        private UsagesInfo() {
        }
    }

    private static final class GotoDefinitionKey {
        @NotNull
        private final String myUrl;
        private final int myFileVersion;
        private final int myOffset;

        private GotoDefinitionKey(@NotNull ClangParseResponse file, int offset) {
            this.myUrl = file.getUrl();
            this.myFileVersion = file.getVersion();
            this.myOffset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GotoDefinitionKey key = (GotoDefinitionKey)o;
            return Objects.equals(this.myUrl, key.myUrl) && this.myOffset == key.myOffset && this.myFileVersion == key.myFileVersion;
        }

        public int hashCode() {
            return Objects.hash(this.myUrl, this.myFileVersion, this.myOffset);
        }
    }
}

