/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdIndexerService
extends ClangdLanguageService {
    @NotNull
    private final List<String> myAppLog = new LinkedList<String>();
    @NotNull
    private final BackgroundTaskQueue myQueue;
    @Nullable
    private MyIndexingProgressTask myLastTask = null;

    public ClangdIndexerService(@NotNull ClangDaemonContext context) {
        super(context);
        this.myQueue = new BackgroundTaskQueue(context.getProject(), ClangdBundle.message("clangd.indexing.message", new Object[0]));
        this.installIndexLoggerIfNeeded();
        this.installIndexingProgressIfNeeded(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getCopyOfAppLog() {
        List<String> list = this.myAppLog;
        synchronized (list) {
            return new ArrayList<String>(this.myAppLog);
        }
    }

    @NotNull
    public CompletableFuture<Boolean> executeCommand(@NotNull String command) {
        return this.executeCommand(command, "");
    }

    @NotNull
    public CompletableFuture<Boolean> executeCommand(@NotNull String command, @NotNull String argument) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction(command).action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionIndexerCommand(new ClionIndexerCommandParams(command, argument))))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).requiresRecover().create());
        return result;
    }

    @NotNull
    public CompletableFuture<Boolean> notifySettingsChanged(@NotNull ClionIndexerParams newParams) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("setMode").action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionIndexerMode(newParams)))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).requiresRecover().create());
        return result;
    }

    private void installIndexLoggerIfNeeded() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){
            private boolean indexStartedCame = false;
            private int lastReportedPercent = -1;

            @Override
            public void onIndexingStarted() {
                this.indexStartedCame = true;
                this.lastReportedPercent = -1;
            }

            @Override
            public void onIndexingProgress(int processed, int total) {
                int newPercent;
                if (this.indexStartedCame) {
                    ClangdIndexerService.this.addAppLogMessage("Indexing started: " + total + " TUs to process");
                    this.indexStartedCame = false;
                }
                if ((newPercent = Double.valueOf((double)processed / (double)total * 100.0).intValue()) != this.lastReportedPercent) {
                    this.lastReportedPercent = newPercent;
                    ClangdIndexerService.this.addAppLogMessage("Progress: " + newPercent + "%");
                }
            }

            @Override
            public void onIndexingFinished(@NotNull List<String> deletedPaths, @NotNull String symbolsDirPath) {
                StringBuilder sb = new StringBuilder("Indexing finished! " + deletedPaths.size() + " deleted  (" + symbolsDirPath + ")");
                if (!deletedPaths.isEmpty()) {
                    sb.append("Deleted paths:\n");
                    for (String path : deletedPaths) {
                        sb.append("  ").append(path).append("\n");
                    }
                }
                ClangdIndexerService.this.addAppLogMessage(sb.toString());
            }

            @Override
            public void onIndexingMessage(@NotNull String message) {
                ClangdIndexerService.this.addAppLogMessage(message);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAppLogMessage(@NotNull String message) {
        List<String> list = this.myAppLog;
        synchronized (list) {
            if (this.myAppLog.size() >= 4096) {
                this.myAppLog.remove(0);
            }
            this.myAppLog.add(message);
        }
    }

    private void installIndexingProgressIfNeeded(@NotNull ClangDaemonContext context) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        context.getMessageBus().connect((Disposable)context).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingStarted() {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    ClangdIndexerService.this.myQueue.clear();
                    if (ClangdIndexerService.this.myLastTask != null) {
                        ClangdIndexerService.this.myLastTask.myFinished.complete(true);
                        ClangdIndexerService.this.myLastTask = null;
                    }
                    ClangdIndexerService.this.myLastTask = new MyIndexingProgressTask(ClangdIndexerService.this.myProject, ClangdIndexerService.this);
                    ClangdIndexerService.this.myQueue.run((Task.Backgroundable)ClangdIndexerService.this.myLastTask);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingTaskId(@NotNull ClangdIndexingTaskId id) {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null && ClangdIndexerService.this.myLastTask.myAssignedIndicator != null) {
                        switch (id) {
                            case preprocessing: {
                                Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setText(ClangdBundle.message("clangd.preprocessing.message", new Object[0]));
                                break;
                            }
                            case indexing: {
                                Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setText(ClangdBundle.message("clangd.indexing.message", new Object[0]));
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingProgress(int processed, int total) {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null && ClangdIndexerService.this.myLastTask.myAssignedIndicator != null) {
                        Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setFraction((double)processed / (double)total);
                    }
                }
            }

            @Override
            public void onIndexingCanceled() {
                this.onIndexingFinishedImpl();
            }

            @Override
            public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                this.onIndexingFinishedImpl();
            }

            @Override
            public void onServerFailure() {
                this.onIndexingFinishedImpl();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onIndexingFinishedImpl() {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null) {
                        ClangdIndexerService.this.myLastTask.myFinished.complete(true);
                        ClangdIndexerService.this.myLastTask = null;
                    }
                }
            }
        });
    }

    private static class MyIndexingProgressTask
    extends Task.Backgroundable {
        private final ClangdIndexerService myService;
        private final CompletableFuture<Object> myFinished = new CompletableFuture();
        @Nullable
        private volatile ProgressIndicator myAssignedIndicator = null;

        private MyIndexingProgressTask(@NotNull Project project, @NotNull ClangdIndexerService service) {
            super(project, ClangdBundle.message("clangd.indexing.message", new Object[0]), true);
            this.myService = service;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                this.myAssignedIndicator = indicator;
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                try {
                    CidrConcurrentUtilsKt.waitCancelAware(this.myFinished, (String)"indexing future");
                }
                catch (ProcessCanceledException ex) {
                    this.myService.executeCommand("cancel", "");
                }
                indicator.setFraction(1.0);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

