/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.URLUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangUrlConverter {
    private static final Logger LOG = Logger.getInstance((String)ClangUrlConverter.class.getName());
    @NotNull
    private String myWslMsId = "";

    public ClangUrlConverter() {
    }

    public ClangUrlConverter(@NotNull String wslMsId) {
        this.myWslMsId = wslMsId;
    }

    public boolean isAcceptable(@NotNull String url) {
        if (url.startsWith("file://")) {
            return true;
        }
        return url.equals("mock:///dummy");
    }

    @NotNull
    public String fromUrl(@NotNull String url) {
        return URLUtil.extractPath((String)url);
    }

    @NotNull
    public String fromUri(@NotNull String uri) {
        return (String)this.fromUriImpl((String)uri).first;
    }

    @NotNull
    public String fromUriToUrl(@NotNull String uri) {
        Pair<String, Boolean> pathAndMock = this.fromUriImpl(uri);
        String protocol = (Boolean)pathAndMock.second != false ? "mock" : "file";
        return VirtualFileManager.constructUrl((String)protocol, (String)((String)pathAndMock.first));
    }

    @NotNull
    public String toUri(@NotNull File file, boolean isMock) {
        assert (!file.getPath().contains("://"));
        try {
            if (isMock) {
                URI uri = file.toURI();
                return ClangUrlConverter.mockPath2Uri(uri, file);
            }
            Object path = ClangUrlConverter.fixWslPathWhenRequired(FileUtil.toSystemIndependentName((String)file.getPath()), this.isWslMode());
            if (SystemInfo.isWindows && ((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
            URI uri = new URI("file", "", (String)path, null, null);
            return uri.toString();
        }
        catch (Error | URISyntaxException ex) {
            LOG.error(ex);
            return ClangUrlConverter.fixWslPathWhenRequired(file.getPath(), this.isWslMode());
        }
    }

    @NotNull
    public String toUri(@NotNull VirtualFile vf) {
        return this.toUriFromUrl(vf.getUrl());
    }

    @NotNull
    public String toUriFromUrl(@NotNull String url) {
        String path = this.fromUrl(url);
        return this.toUri(new File(path), url.startsWith("mock://"));
    }

    @NotNull
    public String path2ClangdPath(@NotNull File path, boolean isMock) {
        int driveLetterPos;
        if (path.getPath().isEmpty()) {
            return "";
        }
        String convertedPath = URI.create(this.toUri(path, isMock)).getPath();
        if (this.isWslMode()) {
            return convertedPath;
        }
        if (SystemInfo.isWindows && (driveLetterPos = ClangUrlConverter.findDriveLetter(convertedPath)) > 0) {
            convertedPath = convertedPath.substring(driveLetterPos);
        }
        return FileUtil.toSystemDependentName((String)convertedPath);
    }

    public void setWslMsId(@NotNull String wslMsId) {
        this.myWslMsId = wslMsId;
    }

    public boolean isWslMode() {
        return !this.myWslMsId.isEmpty();
    }

    @NotNull
    public String getWslMsId() {
        return this.myWslMsId;
    }

    @NotNull
    public static String fixWslPathWhenRequired(@NotNull String path, boolean isWsl) {
        if (!isWsl) {
            return path;
        }
        return StringUtil.replace((String)ClangUrlConverter.doFixWSLPath(path), (String)"\\", (String)"/");
    }

    @NotNull
    private static String doFixWSLPath(@NotNull String path) {
        if (((String)path).startsWith("/mnt/")) {
            return path;
        }
        int schemeIndex = ((String)path).indexOf("://");
        String protocolPrefix = "";
        if (schemeIndex > 0) {
            protocolPrefix = ((String)path).substring(0, schemeIndex);
            path = ((String)path).substring(schemeIndex + "://".length());
        }
        if (((String)path).startsWith("//wsl$/")) {
            path = ((String)path).substring("//wsl$/".length());
            int indexAfterDistribution = ((String)path).indexOf("/");
            path = ((String)path).substring(indexAfterDistribution);
        } else {
            int driveLetterIndex = ((String)path).charAt(0) == '/' ? 1 : 0;
            path = "/mnt/" + StringUtil.toLowerCase((char)((String)path).charAt(driveLetterIndex)) + ((String)path).substring(driveLetterIndex + 2);
        }
        if (schemeIndex >= 0) {
            path = protocolPrefix + "://" + (String)path;
        }
        return path;
    }

    @NotNull
    public static String fromWslPath(@NotNull String path, @NotNull String wslMsId) {
        if (wslMsId.isEmpty() || path.isEmpty()) {
            return path;
        }
        if (path.startsWith("/mnt/")) {
            int mntLength = "/mnt/".length();
            return path.substring(mntLength, mntLength + 1).toUpperCase(Locale.ROOT) + ":" + path.substring(mntLength + 1);
        }
        return "//wsl$/" + wslMsId + path;
    }

    protected Pair<String, Boolean> fromUriImpl(@NotNull String uri) {
        try {
            URI javaUri = URI.create(uri);
            String path = javaUri.getPath();
            String mockPath = ClangUrlConverter.mockUri2Path(javaUri, path);
            if (mockPath != null) {
                return Pair.create((Object)mockPath, (Object)true);
            }
            if (this.isWslMode()) {
                path = ClangUrlConverter.fromWslPath(path, this.getWslMsId());
            } else if (SystemInfo.isWindows && path.startsWith("/") && path.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path.substring(1))) {
                path = path.substring(1);
            }
            return Pair.create((Object)path, (Object)false);
        }
        catch (IllegalArgumentException ex) {
            ClangUtils.warnClangd(LOG, "Failed to decode " + uri);
            return Pair.create((Object)uri, (Object)false);
        }
    }

    @NotNull
    private static String mockPath2Uri(@NotNull URI javaUri, @NotNull File path) {
        Object rawPath = javaUri.getRawPath();
        if (SystemInfo.isWindows) {
            boolean origHadDrive;
            String origPath = path.getPath();
            boolean bl = origHadDrive = ClangUrlConverter.findDriveLetter(origPath) >= 0;
            if (!origHadDrive) {
                int driveLetterIndex = ClangUrlConverter.findDriveLetter((String)rawPath);
                if (driveLetterIndex >= 0) {
                    rawPath = ((String)rawPath).substring(driveLetterIndex + 2);
                }
            } else if (!((String)(rawPath = ((String)rawPath).replaceFirst(":", ""))).startsWith("/")) {
                rawPath = "/" + (String)rawPath;
            }
            return "file://" + ClangUrlConverter.getMockUriRoot(origHadDrive) + (String)rawPath;
        }
        return "file://" + ClangUrlConverter.getMockUriRoot(false) + (String)rawPath;
    }

    @Nullable
    private static String mockUri2Path(@NotNull URI javaUri, @NotNull String path) {
        if (SystemInfo.isWindows && ((String)path).startsWith(ClangUrlConverter.getMockUriRoot(true))) {
            path = ((String)path).substring(ClangUrlConverter.getMockUriRoot(true).length());
            assert (ClangUrlConverter.isAnySeparator(((String)path).charAt(0)) && OSAgnosticPathUtil.isAbsoluteDosPath((String)((String)path).substring(1)));
            char driveLetter = ((String)path).charAt(1);
            path = driveLetter + ":" + ((String)path).substring(2);
            return path;
        }
        if (((String)path).startsWith(ClangUrlConverter.getMockUriRoot(false))) {
            return ((String)path).substring(ClangUrlConverter.getMockUriRoot(false).length());
        }
        return null;
    }

    @NlsSafe
    @NotNull
    private static String getMockUriRoot(boolean hadDriveLetter) {
        if (SystemInfo.isWindows) {
            return hadDriveLetter ? "/X:/cidr_memory_mapped_mock_with_drive" : "/X:/cidr_memory_mapped_mock";
        }
        return "/cidr_memory_mapped_mock";
    }

    public static int findDriveLetter(@NotNull String path) {
        if (!SystemInfo.isWindows) {
            return -1;
        }
        if (path.length() > 3 && OSAgnosticPathUtil.isAbsoluteDosPath((String)path)) {
            return 0;
        }
        if (path.length() > 4 && ClangUrlConverter.isAnySeparator(path.charAt(0)) && OSAgnosticPathUtil.isAbsoluteDosPath((String)path.substring(1))) {
            return 1;
        }
        return -1;
    }

    private static boolean isAnySeparator(char c) {
        return c == '/' || c == '\\';
    }
}

