/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.execution.debugger.NativeStacktraceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangLanguageServiceUtils {
    private static final Logger LOG = Logger.getInstance((String)ClangLanguageServiceUtils.class.getName());
    @NonNls
    private static final String ERROR_FRAGMENT = "error:";
    @NonNls
    private static final String NOTE_FRAGMENT = "note:";
    private static final Pattern NOTE_POSITION_PATTERN = Pattern.compile("(?<path>.*?):(?<line>[0-9]+):(?<character>[0-9]+)\\s*");

    public static int lspPos2Offset(@NotNull Document doc, @NotNull Position pos) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (doc.getLineCount() <= pos.getLine()) {
            return Math.min(doc.getTextLength(), doc.getLineStartOffset(doc.getLineCount() - 1) + pos.getCharacter());
        }
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }

    @NotNull
    public static Position offset2LspPos(@NotNull Document doc, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int lineNumber = doc.getLineNumber(offset);
        int columnNumber = offset - doc.getLineStartOffset(lineNumber);
        return new Position(lineNumber, columnNumber);
    }

    @NotNull
    public static Range offsets2Range(@NotNull Document doc, int from, int to) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new Range(ClangLanguageServiceUtils.offset2LspPos(doc, from), ClangLanguageServiceUtils.offset2LspPos(doc, to));
    }

    public static void finishOperation(@NotNull ClangParseResponse response, boolean success) {
        if (!ClangParseResponse.isInDoneState(response)) {
            response.getOperationState().complete(success);
            if (!success) {
                ClangParseResponse.completeAnswers(response);
            }
        }
    }

    @Nullable
    public static <T> T getFromClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException, InterruptedException {
        assert (future.isDone());
        Supplier<? extends T> supplier = future.get();
        return supplier != null ? (T)supplier.get() : null;
    }

    @Nullable
    public static ClangNote parseNote(@NotNull String note, @NotNull String wslMsId) {
        String pathAndPosition;
        Matcher matcher;
        int separatorLength = NOTE_FRAGMENT.length();
        int separator = note.indexOf(NOTE_FRAGMENT);
        if (separator == -1) {
            separatorLength = ERROR_FRAGMENT.length();
            separator = note.indexOf(ERROR_FRAGMENT);
        }
        if (separator >= 0 && (matcher = NOTE_POSITION_PATTERN.matcher(pathAndPosition = note.substring(0, separator))).find()) {
            String path = matcher.group("path");
            if (!wslMsId.isEmpty()) {
                path = ClangUrlConverter.fromWslPath(path, wslMsId);
            }
            if (path.equals("<command-line>")) {
                return null;
            }
            String lineAsString = matcher.group("line");
            String characterAsString = matcher.group("character");
            String message = note.substring(separator + separatorLength);
            try {
                int line = Integer.parseInt(lineAsString);
                int character = Integer.parseInt(characterAsString);
                return new ClangNote(message, path, line, character);
            }
            catch (NumberFormatException ex) {
                LOG.warn((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public static int getServerPid(@Nullable ServerConnection connection) {
        if (!(connection instanceof ProcessServerConnectionProvider.ProcessServerConnection)) {
            return -1;
        }
        Process serverProcess = ((ProcessServerConnectionProvider.ProcessServerConnection)connection).getProcess();
        return OSProcessUtil.getProcessID((Process)serverProcess);
    }

    @NonNls
    @NotNull
    public static String getNativeStacktrace(@Nullable ServerConnection connection) {
        NativeStacktraceProvider nativeStacktraceProvider;
        int pid = ClangLanguageServiceUtils.getServerPid(connection);
        if (pid != -1 && (nativeStacktraceProvider = (NativeStacktraceProvider)ApplicationManager.getApplication().getService(NativeStacktraceProvider.class)) != null) {
            try {
                String stacktrace = nativeStacktraceProvider.getNativeStacktrace(pid);
                if (stacktrace != null) {
                    return stacktrace;
                }
            }
            catch (ExecutionException ex) {
                return ExceptionUtil.getThrowableText((Throwable)ex);
            }
        }
        return "unavailable";
    }

    public static final class ClangNote {
        @NotNull
        public final String message;
        @NotNull
        public final String path;
        public final int line;
        public final int character;

        private ClangNote(@NotNull String message, @NotNull String path, int line, int character) {
            this.message = message;
            this.path = path;
            this.line = line;
            this.character = character;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClangNote note = (ClangNote)o;
            return this.line == note.line && this.character == note.character && this.message.equals(note.message) && this.path.equals(note.path);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.path, this.line, this.character);
        }
    }
}

