/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClangdUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("oc.clangd.enabled", 2);
    private static final EventId TIDY = GROUP.registerEvent("tidy");
    private static final EventId ERRORS = GROUP.registerEvent("errors");

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        ClangdSettings settings = ClangdSettings.getInstance(project);
        HashSet<MetricEvent> features = new HashSet<MetricEvent>();
        if (settings.isClangdShowErrors()) {
            features.add(ERRORS.metric());
        }
        if (settings.isClangTidyViaClangd()) {
            features.add(TIDY.metric());
        }
        return features;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }
}

