/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangPreprocessedReport {
    @NotNull
    private final List<PreprocessedFile> myPreprocessedFiles;

    public ClangPreprocessedReport(@NotNull List<PreprocessedFile> preprocessedFiles) {
        this.myPreprocessedFiles = preprocessedFiles;
    }

    @NotNull
    public List<PreprocessedFile> getPreprocessedFiles() {
        return Collections.unmodifiableList(this.myPreprocessedFiles);
    }

    public static class PreprocessedFile {
        @NotNull
        public final String targetPath;
        @Nullable
        public final String lastDiagnostics;
        @NotNull
        public final List<String> commandLine;
        @NotNull
        public final String clangTidyConfig;
        @NotNull
        public final String clionClangTidyConfig;
        @NotNull
        public final String clazyConfig;
        @Nullable
        public final ClionClangDFAConfigParams dfaConfigParams;
        @NotNull
        public final UnusedIncludesInspectionMode unusedIncludesMode;
        @NotNull
        public final String diags;
        @Nullable
        public final String content;
        @NotNull
        public final String macros;

        public PreprocessedFile(@NotNull String path, @Nullable String lastDiagnostics, @NotNull List<String> commandLine, @NotNull String clangTidyConfig, @NotNull String clionClangTidyConfig, @NotNull String clazyConfig, @Nullable ClionClangDFAConfigParams dfaConfigParams, @NotNull UnusedIncludesInspectionMode unusedIncludesMode, @NotNull String diags, @Nullable String content, @NotNull String macros) {
            this.targetPath = path;
            this.commandLine = commandLine;
            this.clangTidyConfig = clangTidyConfig;
            this.clionClangTidyConfig = clionClangTidyConfig;
            this.clazyConfig = clazyConfig;
            this.dfaConfigParams = dfaConfigParams;
            this.unusedIncludesMode = unusedIncludesMode;
            this.diags = diags;
            this.content = content;
            this.macros = macros;
            this.lastDiagnostics = lastDiagnostics;
        }

        @NotNull
        public String getCompilationInfoAsString(@Nullable Obfuscator obfuscator) {
            List preparedCommandLine;
            String preparedTargetPath;
            if (obfuscator != null) {
                preparedTargetPath = obfuscator.obfuscatePath(this.targetPath);
                preparedCommandLine = obfuscator.obfuscateCommandLine(this.commandLine);
            } else {
                preparedTargetPath = this.targetPath;
                preparedCommandLine = this.commandLine;
            }
            preparedCommandLine = ContainerUtil.map(preparedCommandLine, opt -> opt.indexOf(32) >= 0 ? "\"" + opt + "\"" : opt);
            return "Target file: " + preparedTargetPath + "\nCompilation command: " + StringUtil.join((Collection)preparedCommandLine, (String)" ") + "\nClang-tidy config: " + this.clangTidyConfig + "\nCLion clang-tidy config: " + this.clionClangTidyConfig + "\nClazy config: " + this.clazyConfig + "\nDFA Input: " + this.getDfaConfigAsString() + "\nUnusedIncludesInspection: " + this.unusedIncludesMode + "\nPP Diagnostics: " + this.diags + "\n";
        }

        @NotNull
        public String getContent(@Nullable Obfuscator obfuscator) {
            if (this.content == null) {
                return "<failed to preprocess>";
            }
            if (obfuscator != null) {
                return obfuscator.obfuscate(this.content);
            }
            return this.content;
        }

        @NotNull
        public String getTargetPath(@Nullable Obfuscator obfuscator) {
            return obfuscator != null ? obfuscator.obfuscatePath(this.targetPath) : this.targetPath;
        }

        @NotNull
        private String getDfaConfigAsString() {
            if (this.dfaConfigParams == null) {
                return "disabled";
            }
            return this.dfaConfigParams.isGlobalMode() ? "global" : "local";
        }
    }
}

