/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.PredefinedVariables;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.CLionCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesPaths;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.util.ClangdCommonUtil;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ClangUtils {
    @NotNull
    public static final String CLANG_UNUSED_INCLUDE_DIAG_ID = "clion_unused_include";
    @NonNls
    public static final String CLANGD_PATH = "CLANGD_PATH";
    @NonNls
    public static final String QT_CORE = "QtCore";
    @NonNls
    public static final String SYSTEM_INDEPENDENT_UNC_PREFIX = "//wsl$/";
    @NonNls
    public static final String WSL_MNT_PATH = "/mnt/";
    public static final Pattern VERSION_PATTERN = Pattern.compile("clangd version (\\S*)(?: \\((.*) (.*) based on LLVM (.*) revision\\)(.*))?", 32);
    private static final String WSL_CLANGD_DIR_PARENT_PATH = "/tmp";
    private static final String WSL_CLANGD_DIR_BASE_PATH = "/tmp/clangd";
    public static final Key<String> CLANGD_ARCHITECTURE = Key.create((String)"CLANGD_ARCHITECTURE");
    public static final Key<String> CLANGD_OS = Key.create((String)"CLANGD_OS");
    public static final Key<String> CLANGD_ENVIRONMENT = Key.create((String)"CLANGD_ENVIRONMENT");
    public static final Key<OCLanguageStandard> CLANGD_C_LANGUAGE_STANDARD = Key.create((String)"CLANGD_C_LANGUAGE_STANDARD");
    public static final Key<OCLanguageStandard> CLANGD_CXX_LANGUAGE_STANDARD = Key.create((String)"CLANGD_CXX_LANGUAGE_STANDARD");
    private static final List<String> CLANG_BINARIES = Arrays.asList("clangd", "clangd.exe", "clang-tidy", "clang-tidy.exe");
    @NotNull
    private static final AtomicReference<String> clangdRevision = new AtomicReference<String>("");
    @NotNull
    public static final Logger LOG = Logger.getInstance((String)ClangUtils.class.getName());
    @NonNls
    private static final String[] ourPathOpts = new String[]{"--include-directory", "--include-directory-after", "--include-prefix", "--include-with-prefix", "--include-with-prefix-after", "--include-with-prefix-before", "--imacros", "--include", "-imacros", "-include", "-isysroot"};
    @NonNls
    private static final String[] ourPrefixPathOpts = new String[]{"-I", "--include-directory=", "-F", "-idirafter", "--include-directory-after=", "-iframework", "-iquote", "-isystem", "-iprefix", "--include-prefix=", "-iwithprefix", "--include-with-prefix-after=", "--include-with-prefix=", "-iwithprefixbefore", "--include-with-prefix-before=", "-isysroot", "-iwithsysroot", "-imacros", "--imacros=", "-include", "--include="};
    private static final int MSVC_MAJOR_LENGTH = 2;
    private static final int MSVC_MINOR_LENGTH = 2;
    private static final Pattern VS_WARNINGS = Pattern.compile("^-[wW](?:[0-4]|d|e)[0-9]{4}$");
    private static final Key<Boolean> CLANGD_ON = Key.create((String)"CLANGD_ON");
    private static final Key<Boolean> CLANGD_INDEXER_ON = Key.create((String)"CLANGD_INDEXER_ON");
    private static final Key<Boolean> CLANGD_CLANG_TIDY_ON = Key.create((String)"CLANG_TIDY_VIA_CLANGD_ON");
    private static final Key<Boolean> CLANGD_SHOW_ERRORS_ON = Key.create((String)"CLANGD_SHOW_ERRORS_ON");
    private static final Key<Boolean> CLANGD_NAVIGATION_ON = Key.create((String)"CLANGD_NAVIGATION_ON");
    private static final Key<Boolean> CLANGD_PARAMETER_INFO_ON = Key.create((String)"CLANGD_PARAMETER_INFO_ON");
    private static final ScheduledExecutorService ourTimeoutHelper = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"TimeoutHelper");

    public static boolean isClangdAllowed(@NotNull Project project) {
        return !ApplicationManager.getApplication().isUnitTestMode() || project.getUserData(CLANGD_ON) == Boolean.TRUE;
    }

    public static boolean isBlacklistedPPDefine(@NotNull String macro) {
        return macro.contains(" __has_include") || macro.contains(" __has_cpp_attribute");
    }

    @NotNull
    public static List<String> filterPPDefines(@NotNull List<String> defines) {
        return ContainerUtil.filter(defines, define -> !ClangUtils.isBlacklistedPPDefine(define));
    }

    @Nullable
    public static CLionCompilationInfo getCLionCompilationInfo(@NotNull Project project, @Nullable ResolveInfo resolveInfo) {
        if (resolveInfo == null) {
            return null;
        }
        OCResolveConfiguration configuration = resolveInfo.configuration;
        OCLanguageKind languageKind = resolveInfo.languageKind;
        VirtualFile root = resolveInfo.root;
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, root);
        UnknownCompilerKind compiler = compilerSettings.getCompilerKind() != null ? compilerSettings.getCompilerKind() : UnknownCompilerKind.INSTANCE;
        File compilerExecutable = compilerSettings.getCompilerExecutable() != null ? compilerSettings.getCompilerExecutable() : new File("unknown");
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir() != null ? compilerSettings.getCompilerWorkingDir() : new File("");
        List headerPaths = compilerSettings.getHeadersSearchPaths();
        return new CLionCompilationInfo(project, configuration, compilerSettings, (OCCompilerKind)compiler, compilerExecutable, compilerWorkingDir, root, headerPaths, languageKind, resolveInfo.guessed);
    }

    @NotNull
    public static String getCurrentWslMsId(@NotNull Project project) {
        if (!Registry.is((String)"clion.clang.clangd.copy.to.wsl")) {
            return "";
        }
        @NotNull List configs = OCWorkspace.getInstance((Project)project).getConfigurations();
        OCResolveConfiguration config = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)configs).first;
        if (config == null) {
            return "";
        }
        @NotNull OCCompilerSettings compiler = config.getCompilerSettings((OCLanguageKind)CLanguageKind.CPP);
        if (compiler.getHeadersSearchPaths().isEmpty()) {
            compiler = config.getCompilerSettings((OCLanguageKind)CLanguageKind.C);
        }
        for (HeadersSearchPath path : compiler.getHeadersSearchPaths()) {
            if (!path.isBuiltInHeaders() || !path.getPath().startsWith(SYSTEM_INDEPENDENT_UNC_PREFIX)) continue;
            String pathStr = path.getPath();
            int afterWslIndex = pathStr.indexOf("/", SYSTEM_INDEPENDENT_UNC_PREFIX.length());
            return pathStr.substring(SYSTEM_INDEPENDENT_UNC_PREFIX.length(), afterWslIndex);
        }
        return "";
    }

    @NotNull
    public static PathOptType getPathOptType(@NotNull String option) {
        return ClangUtils.getPathOptInfo((String)option).type;
    }

    @NotNull
    public static PathOptInfo getPathOptInfo(@NonNls @NotNull String option) {
        if (option.equals("-I-")) {
            return new PathOptInfo(PathOptType.NotAPathOpt, "-I-");
        }
        for (String opt : ourPathOpts) {
            if (!option.equals(opt)) continue;
            return new PathOptInfo(PathOptType.NextWithPath, opt);
        }
        for (String opt : ourPrefixPathOpts) {
            if (!option.startsWith(opt)) continue;
            return new PathOptInfo(PathOptType.ThisWithPath, opt);
        }
        return new PathOptInfo(PathOptType.NotAPathOpt, option);
    }

    /*
     * WARNING - void declaration
     */
    public static void addPreparedCompilerOptions(@NotNull List<String> transformed, @NotNull List<String> original, boolean isWsl) {
        boolean nextIsPathOption = false;
        for (String string : original) {
            void var5_5;
            if (nextIsPathOption) {
                if (isWsl) {
                    String string2 = ClangUrlConverter.fixWslPathWhenRequired(string, true);
                } else {
                    String string3 = FileUtil.toSystemDependentName((String)string);
                }
                nextIsPathOption = false;
            } else if (string.startsWith("-std:")) {
                String string4 = string.replaceFirst(":", "=");
            } else {
                @NotNull PathOptInfo optInfo = ClangUtils.getPathOptInfo(string);
                switch (optInfo.type) {
                    case NextWithPath: {
                        nextIsPathOption = true;
                        break;
                    }
                    case ThisWithPath: {
                        if (isWsl) {
                            String string5 = optInfo.opt + ClangUrlConverter.fixWslPathWhenRequired(string.substring(optInfo.opt.length()), true);
                            break;
                        }
                        String string6 = FileUtil.toSystemDependentName((String)string);
                    }
                }
            }
            transformed.add((String)var5_5);
        }
    }

    @Nullable
    public static ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project, @NotNull VirtualFile file, @NotNull @NonNls String pathToMacrosFile, @NotNull Cpp20ModulesPaths cpp20Paths, @Nullable ResolveInfo resolveInfo) {
        ClangCompilationCommand clangCommand;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CLionCompilationInfo ccInfo = ClangUtils.getCLionCompilationInfo(project, resolveInfo);
        if (ccInfo == null) {
            if (ClangDebugLevel.isWarnOrMore()) {
                CidrLogService.logOnce((Level)Level.WARNING, (String)("Failed to get or create compile command for file " + file.getPath()));
            }
            return null;
        }
        Trustworthiness trustworthiness = new Trustworthiness();
        if (ccInfo.isGuessed()) {
            trustworthiness = trustworthiness.with(2);
        }
        try {
            clangCommand = ClangUtils.createCompilationCommand(converter, file, ccInfo, false);
        }
        catch (IOException ex) {
            LOG.error("Failed to get or create compile command for file " + file.getPath(), (Throwable)ex);
            return null;
        }
        String entryFileUri = converter.toUri(clangCommand.entryFile);
        ArrayList<String> compilerOptions = new ArrayList<String>();
        Map userCompilationCommands = (Map)project.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
        boolean isWsl = converter.isWslMode();
        if (userCompilationCommands == null || !userCompilationCommands.containsKey(clangCommand.inputFile.getPath())) {
            compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.compilerExecutable));
            compilerOptions.add("-nostdinc");
            compilerOptions.add("-nostdlib");
            compilerOptions.add("-nostdlibinc");
            compilerOptions.add("-ccc-no-implicit-pch-or-pth");
            List ideMacros = ContainerUtil.map((Collection)PredefinedVariables.getIDEVariables(), it -> String.format("-D__%s__=%sL", it, PredefinedVariables.getVersionNumber()));
            compilerOptions.addAll(ideMacros);
            ClangUtils.addPreparedCompilerOptions(compilerOptions, clangCommand.compilerOptions, isWsl);
            String macroFile = converter.path2ClangdPath(new File(pathToMacrosFile), false);
            if (!macroFile.isEmpty()) {
                compilerOptions.add("-imacros" + macroFile);
            }
            if (!cpp20Paths.modulesCachePath.isEmpty() && !cpp20Paths.moduleMapPath.isEmpty()) {
                compilerOptions.add("-fmodules");
                compilerOptions.add("-fcxx-modules");
                compilerOptions.add("-fprebuilt-module-path=" + cpp20Paths.modulesCachePath);
                compilerOptions.add("-Xclang");
                compilerOptions.add("-fcpp20-module-map-file=" + cpp20Paths.moduleMapPath);
                compilerOptions.add("-Xclang");
                compilerOptions.add("-fallow-pcm-with-compiler-errors");
            }
            compilerOptions.add(URI.create(entryFileUri).getPath());
        } else {
            String userEntryFile;
            compilerOptions.addAll((Collection)userCompilationCommands.get(clangCommand.inputFile.getPath()));
            if (compilerOptions.size() > 0 && Files.exists(Paths.get(userEntryFile = (String)compilerOptions.get(compilerOptions.size() - 1), new String[0]), new LinkOption[0])) {
                entryFileUri = converter.toUri(new File(userEntryFile), false);
            }
            trustworthiness = new Trustworthiness();
        }
        String macroDefinitions = StringUtil.isNotEmpty((String)clangCommand.preprocessorDefines) ? clangCommand.preprocessorDefines : null;
        String workingDir = clangCommand.workingDir;
        if (isWsl) {
            workingDir = FileUtil.toSystemIndependentName((String)workingDir);
            workingDir = converter.toUri(new File(workingDir), false);
        }
        ClionCompileCommandParams compileCommandParams = new ClionCompileCommandParams(converter.toUri(clangCommand.inputFile), entryFileUri, workingDir, compilerOptions, "/dev/null", Registry.is((String)"clion.clang.clangd.use.predefines"));
        return new ClangdCompilationCommand(compileCommandParams, macroDefinitions, trustworthiness);
    }

    @NotNull
    private static ClangCompilationCommand createCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull VirtualFile inputVirtualFile, @NotNull CLionCompilationInfo info, boolean useInputFileAsEntryFile) throws IOException {
        if (info.getProject().isDisposed()) {
            throw new ProcessCanceledException();
        }
        CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        VirtualFile rootVirtualFile = info.getRootVirtualFile();
        VirtualFile inputFile = inputVirtualFile;
        VirtualFile entryFile = useInputFileAsEntryFile ? inputVirtualFile : rootVirtualFile;
        OCResolveConfiguration configuration = info.getConfiguration();
        OCLanguageKind languageKind = info.getLanguageKind();
        OCCompilerKind compiler = info.getCompilerKind();
        File compilerWorkingDir = info.getCompilerWorkingDir();
        List<String> preprocessorDefines = ClangUtils.filterPPDefines(configuration.getCompilerSettings(languageKind, rootVirtualFile).getPreprocessorDefines());
        String compilerExecutable = compiler == MSVCCompilerKind.INSTANCE || compiler == ClangClCompilerKind.INSTANCE ? (preprocessorDefines.contains("__cplusplus") ? "clang++" : "clang") : info.getCompilerExecutable().getAbsolutePath();
        ClangUtils.addCompilerSwitches(converter, info, compilerOptions);
        ClangUtils.addQobjectDefsDirectories(info, compilerOptions);
        ClangUtils.addIncludeDirectories(info, compilerOptions);
        compilerOptions.addSingleRaw("-ferror-limit=0");
        return new ClangCompilationCommand(inputFile, entryFile, compilerWorkingDir.getAbsolutePath(), compilerExecutable, compilerOptions.getArgs(), ClangUtils.preparePreprocessorDefines(preprocessorDefines));
    }

    private static void addCompilerSwitches(@NotNull ClangUrlConverter converter, @NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        Map compilerFeatures;
        Object hostCompilerSwitches;
        OCCompilerSettings compilerSettings = ccInfo.getCompilerSettings();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compilerSwitches == null) {
            compilerSwitches = CidrCompilerSwitches.EMPTY;
        }
        if (ccInfo.getLanguageKind().isCuda() && (hostCompilerSwitches = (compilerFeatures = compilerSettings.getCompilerFeatures()).get(OCCompilerFeatures.HostCompilerInfo.HOST_COMPILER_FLAGS)) instanceof CidrCompilerSwitches) {
            compilerSwitches = (CidrCompilerSwitches)hostCompilerSwitches;
        }
        String definesString = StringUtil.join(ClangUtils.filterPPDefines(ccInfo.getConfiguration().getCompilerSettings(ccInfo.getLanguageKind(), ccInfo.getRootVirtualFile()).getPreprocessorDefines()), (String)"\n");
        ArrayList<String> XClangArgs = new ArrayList<String>();
        compilerSwitches = ClangUtils.filterOutAndCollectXClangArgs(compilerSwitches, XClangArgs);
        compilerSwitches = ClangUtils.filterOutSearchPaths(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutOrFixUnknownArguments(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.addLanguageStandardIfNeeded(ccInfo, definesString, compilerSwitches);
        compilerSwitches = ClangUtils.addGccConceptsIfNeeded(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.filterOutErroneousFlags(compilerSwitches);
        compilerSwitches = ClangUtils.addSizedDeallocation(compilerSwitches, ccInfo.getCompilerSettings());
        switchBuilder.addAll(compilerSwitches);
        switchBuilder.addAllRaw(XClangArgs);
        ClangUtils.addInputLanguageIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addTargetIfNeeded(ccInfo, definesString, compilerSwitches, switchBuilder);
        ClangUtils.addCompatibilityModeIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addCudaIncludeIfNeeded(converter, ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addCudaSwitches(ccInfo, switchBuilder);
        ClangUtils.applyUserFlags(ccInfo.getProject(), switchBuilder);
    }

    @NotNull
    private static CidrCompilerSwitches addGccConceptsIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo.getCompilerKind() != GCCCompilerKind.INSTANCE) {
            return compilerSwitches;
        }
        ArrayList<String> flags = new ArrayList<String>(compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        boolean hasConceptsFlag = flags.stream().anyMatch(it -> it.equals("-fconcepts"));
        if (!hasConceptsFlag) {
            return compilerSwitches;
        }
        int cxxStandardIdx = ContainerUtil.indexOf(flags, it -> it.startsWith("-std="));
        if (cxxStandardIdx == -1) {
            flags.add("-std=c++20");
        } else {
            flags.set(cxxStandardIdx, "-std=c++20");
        }
        flags.remove("-fconcepts");
        return new CidrCompilerSwitches(flags);
    }

    private static void addCudaSwitches(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        switchBuilder.addSingleRaw("-Xclang");
        switchBuilder.addSingleRaw("-fno-cuda-host-device-constexpr");
        switchBuilder.addSingleRaw("-Xclang");
        switchBuilder.addSingleRaw("-fcuda-allow-variadic-functions");
    }

    private static void addInputLanguageIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.equals("-x")) continue;
            return;
        }
        OCLanguageKind kind = ccInfo.getLanguageKind();
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c");
                    break;
                }
                case OBJ_C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c");
                    break;
                }
                case CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c++");
                    break;
                }
                case OBJ_CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c++");
                    break;
                }
                default: {
                    LOG.warn("Unexpected language kind: " + kind);
                    break;
                }
            }
        } else if (kind instanceof CUDALanguageKind) {
            switchBuilder.addSingleRaw("-x");
            switchBuilder.addSingleRaw("cuda");
        }
    }

    private static void addCompatibilityModeIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getCompilerKind() == MSVCCompilerKind.INSTANCE || ccInfo.getCompilerKind() == ClangClCompilerKind.INSTANCE) {
            switchBuilder.addSingleRaw("-fms-compatibility");
        }
        if ((ccInfo.getCompilerKind() == MSVCCompilerKind.INSTANCE || ccInfo.getCompilerKind() == GCCCompilerKind.INSTANCE) && ccInfo.getLanguageKind().isCpp() && KnownCppStandard.isCpp17OrLater(compilerSwitches)) {
            switchBuilder.addSingleRaw("-frelaxed-template-template-args");
        }
    }

    private static void addCudaIncludeIfNeeded(@NotNull ClangUrlConverter converter, @NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        boolean isWSl = converter.isWslMode();
        switchBuilder.addSingleRaw("-isystem" + ClangUtils.getClangCudaHeaderDir(isWSl) + "/cuda_wrappers");
        switchBuilder.addSingleRaw("-isystem" + ClangUtils.getClangCudaHeaderDir(isWSl));
    }

    @NotNull
    static CidrCompilerSwitches addLanguageStandardIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull String definesString, @NotNull CidrCompilerSwitches compilerSwitches) {
        OCLanguageStandard featureStd = (OCLanguageStandard)ccInfo.getCompilerSettings().getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD);
        boolean gnuMode = ccInfo.getCompilerKind() == GCCCompilerKind.INSTANCE;
        Enum std = null;
        if (featureStd == null && ClangUtils.findLangStandard(compilerSwitches) == null) {
            featureStd = ClangUtils.getFallbackLanguageStandard(ccInfo.getLanguageKind(), ccInfo.getProject());
        }
        if (featureStd == OCLanguageStandard.CPP98) {
            std = gnuMode ? KnownCppStandard.GNU_98 : KnownCppStandard.CPP_98;
        } else if (featureStd == OCLanguageStandard.CPP11) {
            std = gnuMode ? KnownCppStandard.GNU_11 : KnownCppStandard.CPP_11;
        } else if (featureStd == OCLanguageStandard.CPP14) {
            std = gnuMode ? KnownCppStandard.GNU_14 : KnownCppStandard.CPP_14;
        } else if (featureStd == OCLanguageStandard.CPP17) {
            std = gnuMode ? KnownCppStandard.GNU_17 : KnownCppStandard.CPP_17;
        } else if (featureStd == OCLanguageStandard.CPP20) {
            std = gnuMode ? KnownCppStandard.GNU_20 : KnownCppStandard.CPP_20;
        } else if (featureStd == OCLanguageStandard.CPP23) {
            std = gnuMode ? KnownCppStandard.GNU_23 : KnownCppStandard.CPP_23;
        } else if (featureStd == OCLanguageStandard.C89) {
            std = gnuMode ? KnownCStandard.GNU89 : KnownCStandard.C89;
        } else if (featureStd == OCLanguageStandard.C99) {
            std = gnuMode ? KnownCStandard.GNU99 : KnownCStandard.C99;
        } else if (featureStd == OCLanguageStandard.C11) {
            std = gnuMode ? KnownCStandard.GNU11 : KnownCStandard.C11;
        } else if (featureStd == OCLanguageStandard.C17) {
            std = gnuMode ? KnownCStandard.GNU17 : KnownCStandard.C17;
        } else if (featureStd == OCLanguageStandard.C23) {
            Enum enum_ = std = gnuMode ? KnownCStandard.GNU2X : KnownCStandard.C2X;
        }
        if (std != null) {
            return ClangUtils.setLangStandard(std, compilerSwitches);
        }
        return compilerSwitches;
    }

    @NotNull
    private static OCLanguageStandard getFallbackLanguageStandard(@NotNull OCLanguageKind languageKind, @NotNull Project project) {
        if (languageKind.isCpp() || languageKind.isCuda()) {
            OCLanguageStandard keyLangStandard = (OCLanguageStandard)project.getUserData(CLANGD_CXX_LANGUAGE_STANDARD);
            return keyLangStandard != null ? keyLangStandard : OCLanguageStandard.latestCpp();
        }
        OCLanguageStandard keyLangStandard = (OCLanguageStandard)project.getUserData(CLANGD_C_LANGUAGE_STANDARD);
        return keyLangStandard != null ? keyLangStandard : OCLanguageStandard.latestC();
    }

    @NotNull
    private static CidrCompilerSwitches setLangStandard(@NotNull KnownLangStandard std, @NotNull CidrCompilerSwitches switches) {
        if (std != ClangUtils.findLangStandard(switches)) {
            ArrayList<String> updatedFlags = new ArrayList<String>(switches.getList(CidrCompilerSwitches.Format.RAW));
            updatedFlags.add(std.getCommandLineFlag());
            return new CidrCompilerSwitches(updatedFlags);
        }
        return switches;
    }

    private static void addTargetIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull String definesString, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        boolean hasTargetParam = false;
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.startsWith("--target=")) continue;
            hasTargetParam = true;
            break;
        }
        if (!hasTargetParam) {
            String architecture = ClangUtils.detectArchitecture(ccInfo.getProject(), definesString);
            String vendor = "unknown";
            String os = ClangUtils.detectOS(ccInfo.getProject(), definesString);
            String environment = ClangUtils.detectEnvironment(ccInfo.getProject(), definesString, architecture);
            if (architecture != null) {
                switchBuilder.addSingleRaw("--target=" + architecture + "-" + vendor + "-" + os + "-" + environment);
            } else {
                Short sizeTSize = (Short)ccInfo.getCompilerSettings().getCompilerFeatures().get(OCCompilerFeatures.TypeSize.SIZE_T);
                if (sizeTSize != null) {
                    switch (sizeTSize.intValue()) {
                        case 4: {
                            switchBuilder.addSingleRaw("--target=le32-unknown-nacl-unknown");
                            break;
                        }
                        case 8: {
                            switchBuilder.addSingleRaw("--target=le64-unknown-unknown-unknown");
                        }
                    }
                }
            }
        }
    }

    @Nullable
    private static String detectArchitecture(@NotNull Project project, @NotNull String defines) {
        String forced = (String)project.getUserData(CLANGD_ARCHITECTURE);
        if (forced != null) {
            return forced;
        }
        String architecture = null;
        if (defines.contains("__x86_64__") || defines.contains("__amd64__") || defines.contains("_M_X64") || defines.contains("_M_AMD64")) {
            architecture = "x86_64";
        } else if (defines.contains("__i386__") || defines.contains("__i486__") || defines.contains("__i586__") || defines.contains("__i686__") || defines.contains("__i786__") || defines.contains("__i886__") || defines.contains("__i986__") || defines.contains("_M_IX86") || defines.contains("_M_I86") || defines.contains("__X86__") || defines.contains("__I86__") || defines.contains("_X86_")) {
            architecture = "i386";
        } else if (defines.contains("__arm__") || defines.contains("_M_ARM")) {
            architecture = "arm";
        } else if (defines.contains("__aarch64__")) {
            architecture = "arm64";
        } else if (defines.contains("__mips__")) {
            architecture = "mips";
        } else if (defines.contains("__powerpc__") || defines.contains("_M_PPC")) {
            architecture = "powerpc";
        } else if (defines.contains("__powerpc64__")) {
            architecture = "powerpc64";
        } else if (defines.contains("__riscv")) {
            architecture = ClangUtils.getIntValueOfMacroOr(defines, "__riscv_xlen", 64) == 32 ? "riscv32" : "riscv64";
        } else if (defines.contains("__AVR__")) {
            architecture = "avr";
        }
        return architecture;
    }

    @NotNull
    private static String detectOS(@NotNull Project project, @NotNull String defines) {
        String forced = (String)project.getUserData(CLANGD_OS);
        if (forced != null) {
            return forced;
        }
        if (defines.contains("__APPLE__") || defines.contains("__MACH__")) {
            return "darwin";
        }
        if (defines.contains("_WIN32") || defines.contains("_WIN64")) {
            return "windows";
        }
        if (defines.contains("__linux__")) {
            return "linux";
        }
        if (defines.contains("__FreeBSD__")) {
            return "freebsd";
        }
        return "unknown";
    }

    @NotNull
    private static String detectEnvironment(@NotNull Project project, @NotNull String defines, @Nullable String architecture) {
        String forced = (String)project.getUserData(CLANGD_ENVIRONMENT);
        if (forced != null) {
            return forced;
        }
        if (defines.contains("__CYGWIN__")) {
            return "cygnus";
        }
        if (defines.contains("__MINGW32__") || defines.contains("__MINGW64__")) {
            return "gnu";
        }
        if (defines.contains("_MSC_FULL_VER")) {
            String version;
            int versionStartPos = defines.indexOf("_MSC_FULL_VER") + "_MSC_FULL_VER".length() + 1;
            int versionEndPos = defines.indexOf(10, versionStartPos);
            if (versionStartPos >= 0 && versionEndPos >= 0 && (version = defines.substring(versionStartPos, versionEndPos)).length() > 4) {
                return "msvc" + version.substring(0, 2) + "." + version.substring(2, 4) + "." + version.substring(4);
            }
        } else {
            if (defines.contains("__riscv_float_abi_single")) {
                return StringUtil.equals((CharSequence)architecture, (CharSequence)"riscv32") ? "ilp32f" : "lp64f";
            }
            if (defines.contains("__riscv_float_abi_double")) {
                return StringUtil.equals((CharSequence)architecture, (CharSequence)"riscv32") ? "ilp32d" : "lp64d";
            }
            if (defines.contains("__riscv_abi_rve")) {
                return "ilp32e";
            }
            if (defines.contains("__riscv_float_abi_soft")) {
                return "unknown";
            }
        }
        return "unknown";
    }

    @Nullable
    private static String getStringValueOfMacro(@NotNull String defines, @NotNull String macroName) {
        int indexOfMacroValue;
        int indexOfEndOfMacroDefinition;
        int indexOfMacroName = defines.indexOf(macroName);
        if (indexOfMacroName >= 0 && (indexOfEndOfMacroDefinition = defines.indexOf(10, indexOfMacroValue = indexOfMacroName + macroName.length() + 1)) >= 0) {
            return defines.substring(indexOfMacroValue, indexOfEndOfMacroDefinition);
        }
        return null;
    }

    @Nullable
    private static Integer getIntValueOfMacro(@NotNull String defines, @NotNull String macroName) {
        String stringValue = ClangUtils.getStringValueOfMacro(defines, macroName);
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int getIntValueOfMacroOr(@NotNull String defines, @NotNull String macroName, int defaultValue) {
        Integer value = ClangUtils.getIntValueOfMacro(defines, macroName);
        return value != null ? value : defaultValue;
    }

    private static String preparePreprocessorDefines(@NotNull List<String> defines) {
        Stream<Object> definesStream = defines.stream();
        definesStream = definesStream.filter(define -> {
            if (define.startsWith("#define __has_feature(") || define.startsWith("#define __has_extension(") || define.startsWith("#define __has_builtin(") || define.startsWith("#define __has_attribute(") || define.startsWith("#define __has_include(") || define.startsWith("#define __has_include_next(") || define.startsWith("#define __has_warning(") || define.startsWith("#define __is_identifier(") || define.startsWith("#define __building_module(") || define.startsWith("#define __has_cpp_attribute(") || define.startsWith("#define __has_c_attribute(") || define.startsWith("#define __has_declspec(") || define.startsWith("#define __is_target_arch(") || define.startsWith("#define __is_target_vendor(") || define.startsWith("#define __is_target_os(") || define.startsWith("#define __is_target_environment(") || define.startsWith("#define __is_target_variant_os(") || define.startsWith("#define __is_target_variant_environment(")) {
                return false;
            }
            if (define.startsWith("#define __builtin_va_start(list, paramN)") || define.startsWith("#define __builtin_va_arg(list, type)") || define.startsWith("#define __builtin_va_end(list)") || define.startsWith("#define __builtin_va_copy(dest, src)") || define.startsWith("#define __builtin_offsetof(type, member)") || define.startsWith("#define __builtin_types_compatible_p(X,Y)") || define.startsWith("#define __builtin_choose_expr(C,T,E)")) {
                return false;
            }
            return !define.startsWith("#define __extension__");
        });
        StringBuilder filteredDefines = new StringBuilder();
        definesStream.forEach(define -> filteredDefines.append((String)define).append("\n"));
        ClangUtils.appendUnsupportedBuiltins2Intrinsics(filteredDefines);
        return filteredDefines.toString();
    }

    private static void appendUnsupportedBuiltins2Intrinsics(@NotNull StringBuilder defines) {
        defines.append("#define __builtin_ia32_addps _mm_add_ps\n#define __builtin_ia32_addsd _mm_add_sd\n#define __builtin_ia32_addpd _mm_add_pd\n#define __builtin_ia32_addss _mm_add_ss\n#define __builtin_ia32_paddb128 _mm_add_epi8\n#define __builtin_ia32_paddw128 _mm_add_epi16\n#define __builtin_ia32_paddd128 _mm_add_epi32\n#define __builtin_ia32_paddq128 _mm_add_epi64\n#define __builtin_ia32_subps _mm_sub_ps\n#define __builtin_ia32_subsd _mm_sub_sd\n#define __builtin_ia32_subpd _mm_sub_pd\n#define __builtin_ia32_subss _mm_sub_ss\n#define __builtin_ia32_psubb128 _mm_sub_epi8\n#define __builtin_ia32_psubw128 _mm_sub_epi16\n#define __builtin_ia32_psubd128 _mm_sub_epi32\n#define __builtin_ia32_psubq128 _mm_sub_epi64\n#define __builtin_ia32_mulsd _mm_mul_sd\n#define __builtin_ia32_mulpd _mm_mul_pd\n#define __builtin_ia32_mulps _mm_mul_ps\n#define __builtin_ia32_mulss _mm_mul_ss\n#define __builtin_ia32_pmullw128 _mm_mullo_epi16\n#define __builtin_ia32_divsd _mm_div_sd\n#define __builtin_ia32_divpd _mm_div_pd\n#define __builtin_ia32_divps _mm_div_ps\n#define __builtin_ia32_subss _mm_div_ss\n#define __builtin_ia32_andpd _mm_and_pd\n#define __builtin_ia32_andps _mm_and_ps\n#define __builtin_ia32_pand128 _mm_and_si128\n#define __builtin_ia32_andnpd _mm_andnot_pd\n#define __builtin_ia32_andnps _mm_andnot_ps\n#define __builtin_ia32_pandn128 _mm_andnot_si128\n#define __builtin_ia32_orpd _mm_or_pd\n#define __builtin_ia32_orps _mm_or_ps\n#define __builtin_ia32_por128 _mm_or_si128\n#define __builtin_ia32_xorpd _mm_xor_pd\n#define __builtin_ia32_xorps _mm_xor_ps\n#define __builtin_ia32_pxor128 _mm_xor_si128\n#define __builtin_ia32_cvtps2dq _mm_cvtps_epi32\n#define __builtin_ia32_cvtsd2ss _mm_cvtsd_ss\n#define __builtin_ia32_cvtsi2sd _mm_cvtsi32_sd\n#define __builtin_ia32_cvtss2sd _mm_cvtss_sd\n#define __builtin_ia32_cvttsd2si _mm_cvttsd_si32\n#define __builtin_ia32_vec_ext_v2df _mm_cvtsd_f64\n#define __builtin_ia32_loadhpd _mm_loadh_pd\n#define __builtin_ia32_loadlpd _mm_loadl_pd\n#define __builtin_ia32_loadlv4si _mm_loadl_epi64\n#define __builtin_ia32_cmpeqps _mm_cmpeq_ps\n#define __builtin_ia32_cmpltps _mm_cmplt_ps\n#define __builtin_ia32_cmpleps _mm_cmple_ps\n#define __builtin_ia32_cmpgtps _mm_cmpgt_ps\n#define __builtin_ia32_cmpgeps _mm_cmpge_ps\n#define __builtin_ia32_cmpunordps _mm_cmpunord_ps\n#define __builtin_ia32_cmpneqps _mm_cmpneq_ps\n#define __builtin_ia32_cmpnltps _mm_cmpnlt_ps\n#define __builtin_ia32_cmpnleps _mm_cmpnle_ps\n#define __builtin_ia32_cmpngtps _mm_cmpngt_ps\n#define __builtin_ia32_cmpordps _mm_cmpord_ps\n#define __builtin_ia32_cmpeqss _mm_cmpeq_ss\n#define __builtin_ia32_cmpltss _mm_cmplt_ss\n#define __builtin_ia32_cmpless _mm_cmple_ss\n#define __builtin_ia32_cmpunordss _mm_cmpunord_ss\n#define __builtin_ia32_cmpneqss _mm_cmpneq_ss\n#define __builtin_ia32_cmpnltss _mm_cmpnlt_ss\n#define __builtin_ia32_cmpnless _mm_cmpnle_ss\n#define __builtin_ia32_cmpngtss _mm_cmpngt_ss\n#define __builtin_ia32_cmpngess _mm_cmpnge_ss\n#define __builtin_ia32_cmpordss _mm_cmpord_ss\n#define __builtin_ia32_movss _mm_move_ss\n#define __builtin_ia32_movsd _mm_move_sd\n#define __builtin_ia32_movhlps _mm_movehl_ps\n#define __builtin_ia32_movlhps _mm_movelh_ps\n#define __builtin_ia32_movqv4si _mm_move_epi64\n#define __builtin_ia32_unpckhps _mm_unpackhi_ps\n#define __builtin_ia32_unpckhpd _mm_unpackhi_pd\n#define __builtin_ia32_punpckhbw128 _mm_unpackhi_epi8\n#define __builtin_ia32_punpckhwd128 _mm_unpackhi_epi16\n#define __builtin_ia32_punpckhdq128 _mm_unpackhi_epi32\n#define __builtin_ia32_punpckhqdq128 _mm_unpackhi_epi64\n#define __builtin_ia32_unpcklps _mm_unpacklo_ps\n#define __builtin_ia32_unpcklpd _mm_unpacklo_pd\n#define __builtin_ia32_punpcklbw128 _mm_unpacklo_epi8\n#define __builtin_ia32_punpcklwd128 _mm_unpacklo_epi16\n#define __builtin_ia32_punpckldq128 _mm_unpacklo_epi32\n#define __builtin_ia32_punpcklqdq128 _mm_unpacklo_epi64\n#define __builtin_ia32_cmpeqpd _mm_cmpeq_pd\n#define __builtin_ia32_cmpltpd _mm_cmplt_pd\n#define __builtin_ia32_cmplepd _mm_cmple_pd\n#define __builtin_ia32_cmpgtpd _mm_cmpgt_pd\n#define __builtin_ia32_cmpgepd _mm_cmpge_pd\n#define __builtin_ia32_cmpunordpd _mm_cmpunord_pd\n#define __builtin_ia32_cmpneqpd _mm_cmpneq_pd\n#define __builtin_ia32_cmpnltpd _mm_cmpnlt_pd\n#define __builtin_ia32_cmpnlepd _mm_cmpnle_pd\n#define __builtin_ia32_cmpngtpd _mm_cmpngt_pd\n#define __builtin_ia32_cmpngepd _mm_cmpnge_pd\n#define __builtin_ia32_cmpordpd _mm_cmpord_pd\n#define __builtin_ia32_cmpeqsd _mm_cmpeq_sd\n#define __builtin_ia32_cmpltsd _mm_cmplt_sd\n#define __builtin_ia32_cmplesd _mm_cmple_sd\n#define __builtin_ia32_cmpunordsd _mm_cmpunord_sd\n#define __builtin_ia32_cmpneqsd _mm_cmpneq_sd\n#define __builtin_ia32_cmpnltsd _mm_cmpnlt_sd\n#define __builtin_ia32_cmpnlesd _mm_cmpnle_sd\n#define __builtin_ia32_cmpordsd _mm_cmpord_sd\n#define __builtin_ia32_cvtsi642ss _mm_cvtsi64_ss\n#define __builtin_ia32_cvttss2si64 _mm_cvtss_si64\n#define __builtin_ia32_shufpd _mm_shuffle_pd\n#define __builtin_ia32_pshufhw _mm_shufflehi_epi16\n#define __builtin_ia32_pshuflw _mm_shufflelo_epi16\n#define __builtin_ia32_pshufd _mm_shuffle_epi32\n#define __builtin_ia32_movshdup _mm_movehdup_ps\n#define __builtin_ia32_movsldup _mm_moveldup_ps\n#define __builtin_ia32_maxps _mm_max_ps\n#define __builtin_ia32_pslldi128 _mm_slli_epi32\n#define __builtin_ia32_vec_set_v16qi _mm_insert_epi8\n#define __builtin_ia32_vec_set_v8hi _mm_insert_epi16\n#define __builtin_ia32_vec_set_v4si _mm_insert_epi32\n#define __builtin_ia32_vec_set_v2di _mm_insert_epi64\n#define __builtin_ia32_vec_ext_v16qi _mm_extract_epi8\n#define __builtin_ia32_vec_ext_v8hi _mm_extract_epi16\n#define __builtin_ia32_vec_ext_v4si _mm_extract_epi32\n#define __builtin_ia32_vec_ext_v2di _mm_extract_epi64\n#define __builtin_ia32_vec_ext_v4sf _mm_extract_ps\n");
    }

    private static void applyUserFlags(@NotNull Project project, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangdSettings settings = ClangdSettings.getInstance(project);
        List userFlags = ContainerUtil.map((Collection)StringUtil.split((String)settings.getClangFlags(), (String)","), StringUtil::trim);
        List disabledWarnings = (List)project.getUserData(ClangdCommonUtil.DISABLED_WARNINGS);
        if (!ContainerUtil.isEmpty((Collection)userFlags)) {
            for (String flag : userFlags) {
                if (ClangUtils.isWarningOption(flag)) {
                    String warnOptName = ClangUtils.getWarningName(flag);
                    if (disabledWarnings != null && disabledWarnings.contains(warnOptName)) continue;
                }
                switchBuilder.addSingleRaw(flag);
            }
        }
    }

    @NotNull
    private static CidrCompilerSwitches filterOutSearchPaths(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                PathOptType pathOptType = ClangUtils.getPathOptType(parameter);
                switch (pathOptType) {
                    case NextWithPath: {
                        this.skipOptionValue = true;
                        return false;
                    }
                    case ThisWithPath: {
                        return false;
                    }
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions((BiFunction)filter);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutAndCollectXClangArgs(@NotNull CidrCompilerSwitches compilerSwitches, final @NotNull List<String> rawArgs) {
        return compilerSwitches.filterOptions((BiFunction)new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;

            @Override
            public Boolean apply(@NonNls String param, @NonNls String nextParam) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (param.equals("-Xclang")) {
                    rawArgs.add(param);
                    rawArgs.add(nextParam);
                    this.skipNext = true;
                    return false;
                }
                if (param.startsWith("/clang:") && param.length() > "/clang:".length()) {
                    rawArgs.add(param.substring("/clang:".length()));
                    return false;
                }
                return true;
            }
        });
    }

    @NotNull
    private static CidrCompilerSwitches filterOutErroneousFlags(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;
            boolean hasArchArg = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (parameter.equals("-include-pch")) {
                    this.skipNext = true;
                    return false;
                }
                if (parameter.equals("-fconcepts")) {
                    return false;
                }
                if (parameter.equals("-fmodules-ts")) {
                    return false;
                }
                if (parameter.equals("-fprebuilt-module-path")) {
                    return false;
                }
                if (parameter.startsWith("-mabi=")) {
                    return false;
                }
                if (parameter.startsWith("-mfloat-gprs=")) {
                    return false;
                }
                if (parameter.equals("-arch")) {
                    if (this.hasArchArg) {
                        this.skipNext = true;
                        return false;
                    }
                    this.hasArchArg = true;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions((BiFunction)filter);
    }

    @NotNull
    private static CidrCompilerSwitches addSizedDeallocation(@NotNull CidrCompilerSwitches compilerSwitches, @NotNull OCCompilerSettings compilerSettings) {
        OCLanguageStandard featureStd = (OCLanguageStandard)compilerSettings.getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD);
        if (featureStd == null || !featureStd.supports(OCLanguageStandard.CPP14)) {
            return compilerSwitches;
        }
        List switchesList = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        if (switchesList.contains("-fsized-deallocation")) {
            return compilerSwitches;
        }
        ArrayList<String> updatedFlags = new ArrayList<String>(switchesList);
        updatedFlags.add("-fsized-deallocation");
        return new CidrCompilerSwitches(updatedFlags);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutOrFixUnknownArguments(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo.getCompilerKind() != MSVCCompilerKind.INSTANCE && ccInfo.getCompilerKind() != ClangClCompilerKind.INSTANCE) {
            return compilerSwitches;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        List switches = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        boolean addNext = false;
        for (String aSwitch : switches) {
            String parameter = aSwitch.trim();
            if (addNext) {
                filtered.add(parameter);
                addNext = false;
                continue;
            }
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/D", "-D")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/D", "-D")) continue;
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/FI", "-include")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/FI", "-include") || ClangUtils.fixGluedParameter(parameter, filtered, "/std:", "-std=") || ClangUtils.fixGluedParameter(parameter, filtered, "-std:", "-std=") || ClangUtils.isMsvcParam(parameter, "MT") || ClangUtils.isMsvcParam(parameter, "MTd") || ClangUtils.isMsvcParam(parameter, "MD") || ClangUtils.isMsvcParam(parameter, "MDd") || parameter.startsWith("/") || parameter.startsWith("@") || VS_WARNINGS.matcher(parameter).matches() || parameter.equalsIgnoreCase("-bigobj")) continue;
            filtered.add(parameter);
        }
        return filtered.isEmpty() ? CidrCompilerSwitches.EMPTY : new CidrCompilerSwitches(filtered);
    }

    private static boolean fixGluedParameter(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter.startsWith(from) && parameter.length() > from.length()) {
            filtered.add(to + parameter.substring(from.length()));
            return true;
        }
        return false;
    }

    private static boolean fixParameterWithArgument(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter.equals(from)) {
            filtered.add(to);
            return true;
        }
        return false;
    }

    private static boolean isMsvcParam(@NotNull String param, @NotNull String name) {
        return param.equalsIgnoreCase("/" + name) || param.equalsIgnoreCase("-" + name);
    }

    private static void addQobjectDefsDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        boolean hasQtCore = false;
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (!path.getPath().contains(QT_CORE)) continue;
            hasQtCore = true;
            break;
        }
        if (hasQtCore) {
            switchBuilder.addSingleRaw("-I" + ClangRequestsHelper.getMacrosParentPath());
            switchBuilder.addSingleRaw("-I" + ClangRequestsHelper.getMacrosParentPath() + "/QtCore");
        }
    }

    private static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangUtils.addIncludeDirectories(info, switchBuilder, info.getRootVirtualFile().getParent(), false);
    }

    public static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder, @Nullable VirtualFile parentDirectory, boolean restrictToClang) {
        ClangSwitchBuilder clangSwitchBuilder = new ClangSwitchBuilder(switchBuilder);
        if (parentDirectory != null && parentDirectory.isDirectory()) {
            clangSwitchBuilder.withQuoteIncludePath(parentDirectory.getPath());
        }
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (restrictToClang) {
                clangSwitchBuilder.withSwitch("-Xclang");
            }
            clangSwitchBuilder.withHeaderSearchPath(path);
        }
        for (VirtualFile implicitInclude : info.getCompilerSettings().getImplicitIncludes()) {
            clangSwitchBuilder.withForceInclude(implicitInclude.getPath());
        }
    }

    @NotNull
    public static Pair<File, Boolean> getClangdPath() {
        boolean customClangd = true;
        File clangdPath = ClangUtils.getCustomClangdPath();
        if (clangdPath == null) {
            customClangd = false;
            clangdPath = ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clangd.exe" : "clangd");
        }
        return Pair.create((Object)clangdPath, (Object)customClangd);
    }

    @Nullable
    private static File getCustomClangdPath() {
        String path = System.getProperty(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        path = System.getenv(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    private static boolean isRunningFromStudioSources() {
        return PathUtil.toSystemIndependentName((String)PathManager.getHomePath()).contains("/prebuilts/studio/intellij-sdk/");
    }

    private static Path getStudioSourcesRoot() {
        Object relative = "../../../../../../";
        if (SystemInfo.isMac) {
            relative = (String)relative + "../";
        }
        return Paths.get(PathManager.getHomePath(), new String[]{relative}).normalize();
    }

    @NotNull
    public static File getBuiltinClangToolPath(@NonNls @NotNull String toolName) {
        if (ClangUtils.isRunningFromStudioSources() && CLANG_BINARIES.contains(toolName)) {
            Path sourcesRoot = ClangUtils.getStudioSourcesRoot();
            Path prebuilts = sourcesRoot.resolve("prebuilts/tools");
            return prebuilts.resolve("clion/bin/clang/" + CidrPathManager.getPlatformRelativePath((String)toolName)).toFile();
        }
        return CidrPathManager.getBinPath(ClangUtils.class, (String)"clion/bin", (String)("clang/" + CidrPathManager.getPlatformRelativePath((String)toolName)), null).toFile();
    }

    public static String getWslClangdDirPath() {
        if (clangdRevision.get().isEmpty()) {
            try {
                ((CompletableFuture)ClangUtils.getClangToolVersionAsync("clangd", ClangUtils.getBuiltinClangToolPath("clangd").getPath(), (ProgressIndicator)new AbstractProgressIndicatorBase()).thenAccept(output -> {
                    Matcher matcher;
                    Matcher matcher2 = matcher = StringUtil.isNotEmpty((String)output) ? VERSION_PATTERN.matcher((CharSequence)output) : null;
                    if (matcher == null || !matcher.matches()) {
                        return;
                    }
                    clangdRevision.set(matcher.group(3));
                })).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Timeout. Could not get clangd revision.");
            }
        }
        return WSL_CLANGD_DIR_BASE_PATH + clangdRevision.get();
    }

    @NotNull
    @NonNls
    public static String getClangCudaHeaderDir(boolean isWSL) {
        File includeDir = ClangUtils.getBuiltinClangToolPath("include");
        File cudaIncludesDir = ClangUtils.getBuiltinClangToolPath("cuda_includes");
        if (includeDir.exists()) {
            return isWSL ? ClangUtils.getWslClangdDirPath() + "/include" : includeDir.getAbsolutePath();
        }
        return isWSL ? ClangUtils.getWslClangdDirPath() + "/cuda_includes" : cudaIncludesDir.getAbsolutePath();
    }

    @NotNull
    @NonNls
    public static String getClangHeaderDir(boolean isWSL) {
        return isWSL ? ClangUtils.getWslClangdDirPath() + "/include" : ClangUtils.getBuiltinClangToolPath("include").getAbsolutePath();
    }

    private static boolean isWarningOption(@NonNls @NotNull String option) {
        return option.startsWith("-W");
    }

    private static boolean isWarningOptionOn(@NonNls @NotNull String warning) {
        assert (ClangUtils.isWarningOption(warning));
        return !warning.startsWith("-Wno-");
    }

    private static boolean isWarningOptionOff(@NonNls @NotNull String warning) {
        return !ClangUtils.isWarningOptionOn(warning);
    }

    @NotNull
    @NlsSafe
    private static String getWarningName(@NotNull @NlsSafe String warningOption) {
        assert (ClangUtils.isWarningOption(warningOption));
        return ClangUtils.isWarningOptionOn(warningOption) ? warningOption.substring("-W".length()) : warningOption.substring("-Wno-".length());
    }

    @NotNull
    @NlsSafe
    private static String makeWarningOn(@NotNull @NlsSafe String warningOptName) {
        assert (!ClangUtils.isWarningOption(warningOptName));
        return "-W" + warningOptName;
    }

    @NotNull
    @NlsSafe
    private static String makeWarningOff(@NotNull @NlsSafe String warningOptName) {
        assert (!ClangUtils.isWarningOption(warningOptName));
        return "-Wno-" + warningOptName;
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Supplier<@NonNls String> logTask) {
        if (ClangDebugLevel.isWarnOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.warn(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(msg);
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Throwable ex) {
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(ex);
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (ClangDebugLevel.isInfoOrMore()) {
            logger.info(msg);
        }
    }

    public static void traceClangd(@NotNull Logger logger, @NotNull Supplier<@NonNls String> logTask) {
        if (ClangDebugLevel.isTraceOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void traceClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (ClangDebugLevel.isTraceOrMore()) {
            logger.info(msg);
        }
    }

    public static boolean isClangdOn(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_ON, project)) {
            return ClangUtils.getKey(CLANGD_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdOn();
    }

    public static void forceClangdOn(@NotNull Project project) {
        project.putUserData(CLANGD_ON, (Object)true);
    }

    public static void forceClangdOff(@NotNull Project project) {
        project.putUserData(CLANGD_ON, (Object)false);
    }

    public static void nonForceClangd(@NotNull Project project) {
        project.putUserData(CLANGD_ON, null);
    }

    public static boolean isClangdIndexerOn(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_INDEXER_ON, project)) {
            return ClangUtils.getKey(CLANGD_INDEXER_ON, project);
        }
        return Registry.is((String)"clion.clang.clangd.index.on");
    }

    public static void forceClangdIndexerOn(@NotNull Project project) {
        project.putUserData(CLANGD_INDEXER_ON, (Object)true);
    }

    public static void forceClangdIndexerOff(@NotNull Project project) {
        project.putUserData(CLANGD_INDEXER_ON, (Object)false);
    }

    public static void nonForceClangdIndexer(@NotNull Project project) {
        project.putUserData(CLANGD_INDEXER_ON, null);
    }

    public static boolean isClangTidyViaClangdOn(@NotNull Project project) {
        if (ClangUtils.hasKey(CLANGD_CLANG_TIDY_ON, project)) {
            return ClangUtils.getKey(CLANGD_CLANG_TIDY_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdOn() && settings.isClangTidyViaClangd();
    }

    public static void forceClangTidyViaClangdOn(@NotNull Project project) {
        project.putUserData(CLANGD_CLANG_TIDY_ON, (Object)true);
    }

    public static void forceClangTidyViaClangdOff(@NotNull Project project) {
        project.putUserData(CLANGD_CLANG_TIDY_ON, (Object)false);
    }

    public static boolean isClangTidyViaClangdForced(@Nullable Project project) {
        return project != null && project.getUserData(CLANGD_CLANG_TIDY_ON) != null;
    }

    public static void forceClangdShowErrorsOn(@NotNull Project project) {
        project.putUserData(CLANGD_SHOW_ERRORS_ON, (Object)true);
    }

    public static void forceClangdShowErrorsOff(@NotNull Project project) {
        project.putUserData(CLANGD_SHOW_ERRORS_ON, (Object)false);
    }

    public static void nonForceClangdShowErrors(@NotNull Project project) {
        project.putUserData(CLANGD_SHOW_ERRORS_ON, null);
    }

    public static boolean isClangdShowErrors(@NotNull Project project) {
        if (ClangUtils.hasKey(CLANGD_SHOW_ERRORS_ON, project)) {
            return ClangUtils.getKey(CLANGD_SHOW_ERRORS_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdShowErrors();
    }

    public static void forceClangdNavigationOn(@NotNull Project project) {
        project.putUserData(CLANGD_NAVIGATION_ON, (Object)true);
    }

    public static void forceClangdNavigationOff(@NotNull Project project) {
        project.putUserData(CLANGD_NAVIGATION_ON, (Object)false);
    }

    public static void stopForcingClangdNavigation(@NotNull Project project) {
        project.putUserData(CLANGD_NAVIGATION_ON, null);
    }

    public static boolean isNavigationViaClangd(@NotNull Project project) {
        if (ClangUtils.hasKey(CLANGD_NAVIGATION_ON, project)) {
            return ClangUtils.getKey(CLANGD_NAVIGATION_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isNavigationViaClangd();
    }

    public static boolean isParameterInfoViaClangd(@NotNull Project project) {
        if (ClangUtils.hasKey(CLANGD_PARAMETER_INFO_ON, project)) {
            return ClangUtils.getKey(CLANGD_PARAMETER_INFO_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isParameterInfoViaClangd();
    }

    private static boolean hasKey(@NotNull Key<?> projectKey, @Nullable Project project) {
        if (project != null) {
            Object forced = project.getUserData(projectKey);
            return forced != null;
        }
        return false;
    }

    private static boolean getKey(@NotNull Key<Boolean> projectKey, @Nullable Project project) {
        Boolean forced;
        if (project != null && (forced = (Boolean)project.getUserData(projectKey)) != null) {
            return forced;
        }
        return false;
    }

    @Nullable
    public static <T> T waitForClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException {
        Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(future, (String)"clang future");
        return supplier != null ? (T)supplier.get() : null;
    }

    private static boolean isServerException(@NotNull ExecutionException ex) {
        return ex.getCause() instanceof JsonRpcException || ex.getCause() instanceof ResponseErrorException && Objects.equals("invalid AST", ex.getCause().getMessage()) || ex.getCause() instanceof ResponseErrorException && ex.getCause().getMessage() != null && ex.getCause().getMessage().startsWith("Request cancelled");
    }

    public static void logServerException(@NotNull Logger logger, @NotNull String message, @NotNull ExecutionException ex) {
        if (ClangUtils.isServerException(ex)) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)message, (Throwable)ex);
        } else if (ex.getCause() instanceof TimeoutException) {
            logger.warn(message, (Throwable)ex);
        } else {
            logger.error(message, (Throwable)ex);
        }
    }

    public static void logIfServerExceptionOrRethrow(@NotNull ExecutionException ex) throws ExecutionException {
        if (!ClangUtils.isServerException(ex)) {
            throw ex;
        }
        CidrLogService.logOnce((Level)Level.WARNING, (String)ex.getMessage(), (Throwable)ex);
    }

    public static void subscribeToStyleChanges(final @NotNull ClangdLanguageServiceProvider provider2, final @NotNull Project project) {
        final Ref headerExtensions = new Ref((Object)ClangUtils.getCurrentHeaderExtensions(project));
        CodeStyleSettingsManager.getInstance((Project)project).addListener(new CodeStyleSettingsListener(){

            public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
                String currentHeaderExtensions = ClangUtils.getCurrentHeaderExtensions(project);
                if (!currentHeaderExtensions.equals(headerExtensions.get())) {
                    headerExtensions.set((Object)currentHeaderExtensions);
                    ClangLanguageService service = provider2.getIfStarted();
                    if (service != null) {
                        service.shutDownServer();
                    }
                }
            }
        });
    }

    public static String getCurrentHeaderExtensions(@NotNull Project project) {
        ImmutableList<FileExtensionPair> extensionPairs = ClangdBridge.getFileExtensions(project);
        StringBuilder headerExtBuilder = new StringBuilder();
        for (FileExtensionPair extensionPair : extensionPairs) {
            headerExtBuilder.append(extensionPair.myHeaderExt).append(';');
        }
        return headerExtBuilder.toString();
    }

    @NlsSafe
    @NotNull
    public static String getClangTidyConfig(@NlsSafe @NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty("Checks", checks);
        JsonArray checkOptionsObject = new JsonArray();
        for (ClangTidyCheckOption checkOption : checkOptions) {
            checkOptionsObject.add(ClangUtils.toJsonObject(checkOption));
        }
        rootObject.add("CheckOptions", (JsonElement)checkOptionsObject);
        return rootObject.toString();
    }

    @NotNull
    private static JsonElement toJsonObject(@NotNull ClangTidyCheckOption check) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("key", check.getOptionName());
        jsonObject.addProperty("value", check.getOptionValue());
        return jsonObject;
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, null);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds, T completeValue) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, TimeUnit.SECONDS, completeValue);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit, T completeValue) {
        CompletableFuture result = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result.complete(completeValue), timeout, unit);
        return result;
    }

    public static <T> void tie(@NotNull CompletableFuture<T> first, @NotNull CompletableFuture<T> second) {
        ClangUtils.propagate(first, second);
        ClangUtils.propagate(second, first);
    }

    private static <T> void propagate(@NotNull CompletableFuture<T> from, @NotNull CompletableFuture<T> to) {
        from.whenComplete((res, ex) -> {
            if (!to.isDone()) {
                if (ex != null) {
                    to.completeExceptionally((Throwable)ex);
                } else {
                    to.complete(res);
                }
            }
        });
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeoutInSeconds) {
        return ClangUtils.exceptTimeoutAfter(timeoutInSeconds, TimeUnit.SECONDS);
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result.completeExceptionally(new TimeoutException()), timeout, unit);
        return result;
    }

    public static CompletableFuture<String> getClangToolVersionAsync(final @NotNull String toolName, final @NotNull String path, @NotNull ProgressIndicator indicator) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        Task.Backgroundable task = new Task.Backgroundable(null, ClangdBundle.message("configurable.clangTool.version.task.title", toolName)){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(new GeneralCommandLine(new String[]{path, "--version"}));
                    String processOutput = processHandler.runProcessWithProgressIndicator(indicator).getStdout();
                    ProgressManager.checkCanceled();
                    future.complete(processOutput.trim());
                }
                catch (com.intellij.execution.ExecutionException e) {
                    LOG.debug("Failed to check builtin " + toolName + " version", (Throwable)e);
                    future.complete(null);
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Failed to check builtin " + toolName + " version", (Throwable)e);
                    future.completeExceptionally(e);
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
        return future;
    }

    public static int skipPreamble(@Nullable Document document) {
        return document != null ? ClangUtils.skipPreamble(document.getImmutableCharSequence()) : 0;
    }

    public static int skipPreamble(@Nullable CharSequence sequence) {
        if (sequence == null) {
            return 0;
        }
        int i = 0;
        while (i < sequence.length()) {
            char chr = sequence.charAt(i);
            if (chr == '#') {
                i = ClangUtils.skipDirective(sequence, i);
                continue;
            }
            int nextI = ClangUtils.skipBlockComment(sequence, i);
            if (nextI != i) {
                i = nextI;
                continue;
            }
            nextI = ClangUtils.skipLineComment(sequence, i);
            if (nextI != i) {
                i = nextI;
                continue;
            }
            if (chr != '\n') break;
            i = ClangUtils.nextSignificantChar(sequence, i + 1);
        }
        int lines = 0;
        for (int k = 0; k < i; ++k) {
            if (sequence.charAt(k) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private static int skipDirective(@NotNull CharSequence sequence, int i) {
        if (ClangUtils.startsWith(sequence, i, '#')) {
            ++i;
            while (i < sequence.length()) {
                int prevIndex;
                int nextI = ClangUtils.skipBlockComment(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                nextI = ClangUtils.skipLineComment(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                nextI = ClangUtils.skipCharLiteral(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                nextI = ClangUtils.skipStringLiteral(sequence, i);
                if (nextI != i) {
                    i = nextI;
                    continue;
                }
                if (i < sequence.length() && sequence.charAt(i) == '\n' && sequence.charAt(prevIndex = ClangUtils.prevSignificantChar(sequence, i - 1)) != '\\') {
                    return i + 1;
                }
                i = ClangUtils.nextSignificantChar(sequence, i + 1);
            }
        }
        return i;
    }

    private static int skipBlockComment(@NotNull CharSequence sequence, int i) {
        if (StringUtil.startsWith((CharSequence)sequence, (int)i, (CharSequence)"/*")) {
            i += 2;
            while (i < sequence.length()) {
                if (StringUtil.startsWith((CharSequence)sequence, (int)i, (CharSequence)"*/")) {
                    return i + 2;
                }
                ++i;
            }
        }
        return i;
    }

    private static int skipLineComment(@NotNull CharSequence sequence, int i) {
        if (StringUtil.startsWith((CharSequence)sequence, (int)i, (CharSequence)"//")) {
            return ClangUtils.skipUntil(sequence, i, '\n');
        }
        return i;
    }

    private static int skipStringLiteral(@NotNull CharSequence sequence, int i) {
        if (ClangUtils.startsWith(sequence, i, '\"')) {
            return ClangUtils.skipUntil(sequence, i, '\"');
        }
        return i;
    }

    private static int skipCharLiteral(@NotNull CharSequence sequence, int i) {
        if (ClangUtils.startsWith(sequence, i, '\'')) {
            return ClangUtils.skipUntil(sequence, i, '\'');
        }
        return i;
    }

    private static int nextSignificantChar(@NotNull CharSequence sequence, int i) {
        char c;
        while (i < sequence.length() && Character.isWhitespace(c = sequence.charAt(i)) && c != '\n') {
            ++i;
        }
        return i;
    }

    private static int prevSignificantChar(@NotNull CharSequence sequence, int i) {
        char c;
        while (i > 0 && Character.isWhitespace(c = sequence.charAt(i)) && c != '\n') {
            --i;
        }
        return i;
    }

    private static int skipUntil(@NotNull CharSequence sequence, int i, char targetChar) {
        boolean escaped = false;
        while (i < sequence.length()) {
            char c = sequence.charAt(i);
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == targetChar) {
                return i + 1;
            }
            i = ClangUtils.nextSignificantChar(sequence, i + 1);
        }
        return i;
    }

    private static boolean startsWith(@NotNull CharSequence seq, int startIndex, char chr) {
        return startIndex < seq.length() && seq.charAt(startIndex) == chr;
    }

    @Nullable
    public static TextRange findIdentifierRange(@NotNull CharSequence text, int offset) {
        if (offset >= 0 && offset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(offset))) {
            int curOffset;
            for (curOffset = offset; curOffset >= 0 && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); --curOffset) {
            }
            ++curOffset;
            while (Character.isDigit(text.charAt(curOffset)) && curOffset < offset) {
                ++curOffset;
            }
            if (ClangUtils.isCppIdentifierStart(text.charAt(curOffset))) {
                int startRange = curOffset;
                for (curOffset = offset; curOffset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); ++curOffset) {
                }
                int endRange = curOffset;
                return new TextRange(startRange, endRange);
            }
        }
        return null;
    }

    private static boolean isCppIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isCppIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static KnownLangStandard findLangStandard(@NotNull CidrCompilerSwitches switches) {
        @NotNull @Unmodifiable List list = switches.getList(CidrCompilerSwitches.Format.RAW);
        ListIterator iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            String arg = (String)iterator.previous();
            String stdArgPrefix = KnownLangStandard.isStdArgument(arg);
            if (stdArgPrefix == null) continue;
            KnownCppStandard cppStandard = KnownCppStandard.getCppStandard(arg);
            if (cppStandard != null) {
                return cppStandard;
            }
            KnownCStandard cStandard = KnownCStandard.getCStandard(arg);
            if (cStandard != null) {
                return cStandard;
            }
            return null;
        }
        return null;
    }

    public static void prepareClangBinariesInsideWSL(@NotNull ClangUrlConverter converter) {
        boolean needToCopy;
        @NotNull String wslMsId = converter.getWslMsId();
        String tmpWslClangdPath = SYSTEM_INDEPENDENT_UNC_PREFIX + wslMsId + ClangUtils.getWslClangdDirPath();
        boolean bl = needToCopy = !FileUtil.exists((String)tmpWslClangdPath);
        if (needToCopy) {
            File root = new File(SYSTEM_INDEPENDENT_UNC_PREFIX + wslMsId + WSL_CLANGD_DIR_PARENT_PATH);
            File[] dirs = root.listFiles();
            if (dirs != null) {
                String clangdDirPrefix = FileUtil.toSystemDependentName((String)(SYSTEM_INDEPENDENT_UNC_PREFIX + wslMsId + WSL_CLANGD_DIR_BASE_PATH));
                for (File dir : dirs) {
                    if (!dir.getPath().startsWith(clangdDirPrefix)) continue;
                    FileUtil.delete((File)dir);
                }
            }
            File clangdParentDir = ClangUtils.getBuiltinClangToolPath("clangd").getParentFile().getParentFile();
            try {
                FileUtil.copyDirContent((File)new File(clangdParentDir, "wsl"), (File)new File(tmpWslClangdPath));
                ClangUtils.makeClangToolsExecutableInsideWSL(wslMsId);
            }
            catch (com.intellij.execution.ExecutionException | IOException e) {
                LOG.warn(e);
            }
        }
    }

    private static void makeClangToolsExecutableInsideWSL(@NotNull String wslMsId) throws com.intellij.execution.ExecutionException {
        WSLDistribution wslDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(wslMsId);
        WSLCommandLineOptions wslOptions = new WSLCommandLineOptions();
        wslOptions.setSudo(true);
        ImmutableList executables = ContainerUtil.immutableList((Object[])new String[]{"clangd", "clazy-standalone", "clang-tidy"});
        for (String executable : executables) {
            wslDistribution.executeOnWsl(List.of("chmod", "+x", ClangUtils.getWslClangdDirPath() + "/" + executable), wslOptions, 5000, null);
        }
    }

    static final class KnownCppStandard
    extends Enum<KnownCppStandard>
    implements KnownLangStandard {
        public static final /* enum */ KnownCppStandard CPP_98 = new KnownCppStandard("c++98");
        public static final /* enum */ KnownCppStandard GNU_98 = new KnownCppStandard("gnu++98");
        public static final /* enum */ KnownCppStandard CPP_03 = new KnownCppStandard("c++03");
        public static final /* enum */ KnownCppStandard GNU_03 = new KnownCppStandard("gnu++03");
        public static final /* enum */ KnownCppStandard CPP_11 = new KnownCppStandard("c++11", "c++0x");
        public static final /* enum */ KnownCppStandard GNU_11 = new KnownCppStandard("gnu++11", "gnu++0x");
        public static final /* enum */ KnownCppStandard CPP_14 = new KnownCppStandard("c++14", "c++1y");
        public static final /* enum */ KnownCppStandard GNU_14 = new KnownCppStandard("gnu++14", "gnu++1y");
        public static final /* enum */ KnownCppStandard CPP_17 = new KnownCppStandard("c++17", "c++1z");
        public static final /* enum */ KnownCppStandard GNU_17 = new KnownCppStandard("gnu++17", "gnu++1z");
        public static final /* enum */ KnownCppStandard CPP_20 = new KnownCppStandard("c++20", "c++2a");
        public static final /* enum */ KnownCppStandard GNU_20 = new KnownCppStandard("gnu++20", "gnu++2a");
        public static final /* enum */ KnownCppStandard CPP_23 = new KnownCppStandard("c++23", "c++2b");
        public static final /* enum */ KnownCppStandard GNU_23 = new KnownCppStandard("gnu++23", "gnu++2b");
        public static final /* enum */ KnownCppStandard CPP_LATEST = new KnownCppStandard("c++latest");
        @NotNull
        final @NotNull String @NotNull [] myIds;
        private static final /* synthetic */ KnownCppStandard[] $VALUES;

        public static KnownCppStandard[] values() {
            return (KnownCppStandard[])$VALUES.clone();
        }

        public static KnownCppStandard valueOf(String name) {
            return Enum.valueOf(KnownCppStandard.class, name);
        }

        private KnownCppStandard(String ... ids) {
            this.myIds = ids;
        }

        @Override
        @NotNull
        public String getCommandLineFlag() {
            return "-std=" + this.myIds[0];
        }

        public static boolean isCpp17OrLater(@NotNull CidrCompilerSwitches switches) {
            KnownLangStandard std = ClangUtils.findLangStandard(switches);
            return std instanceof KnownCppStandard && std.ordinal() >= CPP_17.ordinal();
        }

        @Nullable
        public static KnownCppStandard getCppStandard(@NotNull String arg) {
            String stdArgPrefix = KnownLangStandard.isStdArgument(arg);
            if (stdArgPrefix != null) {
                String rest = arg.substring(stdArgPrefix.length());
                for (KnownCppStandard std : KnownCppStandard.values()) {
                    for (String id : std.myIds) {
                        if (!rest.startsWith(id)) continue;
                        return std;
                    }
                }
            }
            return null;
        }

        @NotNull
        public static KnownCppStandard getLatestStandard() {
            KnownCppStandard[] values = KnownCppStandard.values();
            assert (values[values.length - 1] == CPP_LATEST);
            return values[values.length - 2];
        }

        static {
            $VALUES = new KnownCppStandard[]{CPP_98, GNU_98, CPP_03, GNU_03, CPP_11, GNU_11, CPP_14, GNU_14, CPP_17, GNU_17, CPP_20, GNU_20, CPP_23, GNU_23, CPP_LATEST};
        }
    }

    static enum KnownCStandard implements KnownLangStandard
    {
        C89("c89", "c90", "iso9899:1990"),
        GNU89("gnu89", "gnu90"),
        ISO9899("iso9899:199409"),
        C99("c99", "iso9899:1999"),
        GNU99("gnu99"),
        C11("c11", "iso9899:2011"),
        GNU11("gnu11"),
        C17("c17"),
        GNU17("gnu17", "gnu18"),
        C2X("c2x"),
        GNU2X("gnu2x");

        @NotNull
        final @NotNull String @NotNull [] myIds;

        private KnownCStandard(String ... ids) {
            this.myIds = ids;
        }

        @Override
        @NotNull
        public String getCommandLineFlag() {
            return "-std=" + this.myIds[0];
        }

        @Nullable
        public static KnownCStandard getCStandard(@NotNull String arg) {
            String stdArgPrefix = KnownLangStandard.isStdArgument(arg);
            if (stdArgPrefix != null) {
                String rest = arg.substring(stdArgPrefix.length());
                for (KnownCStandard std : KnownCStandard.values()) {
                    for (String id : std.myIds) {
                        if (!rest.startsWith(id)) continue;
                        return std;
                    }
                }
            }
            return null;
        }

        @NotNull
        public static KnownCStandard getLatestStandard() {
            KnownCStandard[] values = KnownCStandard.values();
            return values[values.length - 1];
        }
    }

    static interface KnownLangStandard {
        @NotNull
        public String getCommandLineFlag();

        public int ordinal();

        @Nullable
        public static String isStdArgument(@NotNull String arg) {
            if (arg.startsWith("-std=")) {
                return "-std=";
            }
            if (arg.startsWith("-std:")) {
                return "-std:";
            }
            if (arg.startsWith("/std:")) {
                return "/std:";
            }
            return null;
        }
    }

    public static class NotAllowedException
    extends RuntimeException {
        public NotAllowedException() {
            super("Call 'forceClangdOn()' in your test");
        }
    }

    public static final class PathOptInfo {
        @NotNull
        public final PathOptType type;
        @NlsSafe
        @NotNull
        public final String opt;

        public PathOptInfo(@NotNull PathOptType type, @NlsSafe @NotNull String opt) {
            this.type = type;
            this.opt = opt;
        }
    }

    public static enum PathOptType {
        ThisWithPath,
        NextWithPath,
        NotAPathOpt;

    }

    public static class ResolveInfo {
        @NotNull
        public final OCResolveConfiguration configuration;
        @NotNull
        public final VirtualFile root;
        @NotNull
        public final OCLanguageKind languageKind;
        public final boolean guessed;

        public ResolveInfo(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @NotNull OCLanguageKind languageKind, boolean guessed) {
            this.configuration = configuration;
            this.root = root;
            this.languageKind = languageKind;
            this.guessed = guessed;
        }
    }

    private static final class ClangCompilationCommand {
        @NotNull
        public final VirtualFile inputFile;
        @NotNull
        public final VirtualFile entryFile;
        @NotNull
        public final String workingDir;
        @NotNull
        public final String compilerExecutable;
        @NotNull
        public final List<String> compilerOptions;
        @Nullable
        public final String preprocessorDefines;

        ClangCompilationCommand(@NotNull VirtualFile inputFile, @NotNull VirtualFile entryFile, @NotNull String workingDir, @NotNull String compilerExecutable, @NotNull List<String> compilerOptions, @Nullable String defines) {
            this.inputFile = inputFile;
            this.entryFile = entryFile;
            this.workingDir = workingDir;
            this.compilerExecutable = compilerExecutable;
            this.compilerOptions = Collections.unmodifiableList(compilerOptions);
            this.preprocessorDefines = defines;
        }
    }
}

