/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gradle.model.impl.FilePattern;

public class GradleResourceFileFilter
implements FileFilter {
    private final FilePattern myFilePattern;
    private final File myRoot;
    private final Spec<RelativePath> myFileFilterSpec;

    public GradleResourceFileFilter(@NotNull File rootFile, @NotNull FilePattern filePattern) {
        this.myFilePattern = filePattern;
        this.myRoot = rootFile;
        this.myFileFilterSpec = this.getAsSpec();
    }

    @Override
    public boolean accept(@NotNull File file) {
        String relPath = FileUtil.getRelativePath((File)this.myRoot, (File)file);
        return relPath != null && this.isIncluded(relPath);
    }

    private boolean isIncluded(@NotNull String relativePath) {
        RelativePath path = new RelativePath(true, relativePath.split(Pattern.quote(File.separator)));
        return this.myFileFilterSpec.isSatisfiedBy((Object)path);
    }

    private Spec<RelativePath> getAsSpec() {
        return Specs.intersect((Spec[])new Spec[]{this.getAsIncludeSpec(true), Specs.negate(this.getAsExcludeSpec(true))});
    }

    private Spec<RelativePath> getAsExcludeSpec(boolean caseSensitive) {
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>(this.myFilePattern.excludes);
        ArrayList<MyRelativePathSpec> matchers = new ArrayList<MyRelativePathSpec>();
        for (String exclude : allExcludes) {
            PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher((boolean)false, (boolean)caseSensitive, (String)exclude);
            matchers.add(new MyRelativePathSpec(matcher));
        }
        if (matchers.isEmpty()) {
            return Specs.satisfyNone();
        }
        return Specs.union(matchers);
    }

    private Spec<RelativePath> getAsIncludeSpec(boolean caseSensitive) {
        ArrayList<MyRelativePathSpec> matchers = new ArrayList<MyRelativePathSpec>();
        for (String include : this.myFilePattern.includes) {
            PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher((boolean)true, (boolean)caseSensitive, (String)include);
            matchers.add(new MyRelativePathSpec(matcher));
        }
        return Specs.union(matchers);
    }

    private static class MyRelativePathSpec
    implements Spec<RelativePath> {
        @NotNull
        private final PatternMatcher matcher;

        MyRelativePathSpec(@NotNull PatternMatcher matcher) {
            this.matcher = matcher;
        }

        public boolean isSatisfiedBy(RelativePath path) {
            return this.matcher.test(path.getSegments(), path.isFile());
        }
    }
}

