/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gradle.GradleJpsBundle;
import org.jetbrains.jps.gradle.compiler.GradleResourceFileProcessor;
import org.jetbrains.jps.gradle.compiler.ResourceFileProcessor;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleResourceRootDescriptor;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTarget;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTargetType;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class GradleResourcesBuilder
extends TargetBuilder<GradleResourceRootDescriptor, GradleResourcesTarget> {
    private static final Logger LOG = Logger.getInstance(GradleResourcesBuilder.class);

    public GradleResourcesBuilder() {
        super(Arrays.asList(GradleResourcesTargetType.PRODUCTION, GradleResourcesTargetType.TEST));
    }

    public void build(final @NotNull GradleResourcesTarget target, @NotNull DirtyFilesHolder<GradleResourceRootDescriptor, GradleResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        ResourceFileProcessor fileProcessor;
        if (!((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue()) {
            return;
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        GradleProjectConfiguration projectConfig = JpsGradleExtensionService.getInstance().getGradleProjectConfiguration(dataPaths);
        GradleModuleResourceConfiguration config = target.getModuleResourcesConfiguration(dataPaths);
        if (config == null) {
            return;
        }
        final HashMap files = new HashMap();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<GradleResourceRootDescriptor, GradleResourcesTarget>(){

            public boolean apply(GradleResourcesTarget t, File file, GradleResourceRootDescriptor rd) throws IOException {
                assert (target == t);
                ArrayList<File> fileList = (ArrayList<File>)files.get((Object)rd);
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    files.put(rd, fileList);
                }
                fileList.add(file);
                return true;
            }
        });
        GradleResourceRootDescriptor[] roots = files.keySet().toArray(new GradleResourceRootDescriptor[0]);
        Arrays.sort(roots, (r1, r2) -> {
            int res = r1.getIndexInPom() - r2.getIndexInPom();
            if (r1.isOverwrite()) {
                assert (r2.isOverwrite());
                return res;
            }
            if (r1.getConfiguration().isFiltered && !r2.getConfiguration().isFiltered) {
                return 1;
            }
            if (!r1.getConfiguration().isFiltered && r2.getConfiguration().isFiltered) {
                return -1;
            }
            if (!r1.getConfiguration().isFiltered) {
                res = -res;
            }
            return res;
        });
        try {
            fileProcessor = new GradleResourceFileProcessor(projectConfig, target.getModule().getProject(), config);
        }
        catch (Throwable t) {
            LOG.warn("Can not create resource file processor", t);
            fileProcessor = new ResourceFileProcessor(){

                @Override
                public void copyFile(File file, Ref<File> targetFileRef, ResourceRootConfiguration rootConfiguration, CompileContext context, FileFilter filteringFilter) throws IOException {
                    FSOperations.copy((File)file, (File)((File)targetFileRef.get()));
                }
            };
        }
        for (GradleResourceRootDescriptor rd : roots) {
            for (File file : (List)files.get((Object)rd)) {
                File outputDir;
                String relPath = FileUtil.getRelativePath((File)rd.getRootFile(), (File)file);
                if (relPath == null || (outputDir = GradleResourcesTarget.getOutputDir(target.getModuleOutputDir(), rd.getConfiguration(), config.outputDirectory)) == null) continue;
                context.processMessage((BuildMessage)new ProgressMessage(GradleJpsBundle.message("copying.resources.0", target.getModule().getName())));
                Ref fileRef = Ref.create((Object)new File(outputDir, relPath));
                fileProcessor.copyFile(file, (Ref<File>)fileRef, rd.getConfiguration(), context, FileFilters.EVERYTHING);
                outputConsumer.registerOutputFile((File)fileRef.get(), Collections.singleton(file.getPath()));
                if (!context.getCancelStatus().isCanceled()) continue;
                return;
            }
        }
        context.checkCanceled();
        context.processMessage((BuildMessage)new ProgressMessage(""));
    }

    @NotNull
    public String getPresentableName() {
        return GradleJpsBundle.message("gradle.resources.compiler", new Object[0]);
    }
}

