/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions.scheme;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.devkit.actions.scheme.EditEventsTestSchemePanel;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "loadEventsScheme", "Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "project", "Lcom/intellij/openapi/project/Project;", "testSchemeStorage", "Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage;", "update", "Companion", "EventsTestScheme", "intellij.platform.statistics.devkit"})
public final class EditEventsTestSchemeAction
extends DumbAwareAction {
    private final String recorderId;
    private static final LayeredIcon ICON;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Project project = e.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        ValidationTestRulesPersistedStorage testSchemeStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        if (testSchemeStorage == null) {
            StatisticsDevKitUtil.INSTANCE.showNotification(project2, NotificationType.ERROR, StatisticsBundle.message((String)"stats.cannot.find.test.scheme.storage", (Object[])new Object[0]));
            return;
        }
        EventsTestScheme eventsTestScheme = this.loadEventsScheme(project2, testSchemeStorage);
        if (eventsTestScheme == null) {
            return;
        }
        EventsTestScheme scheme = eventsTestScheme;
        EditEventsTestSchemePanel editTestSchemePanel = new EditEventsTestSchemePanel(project2, scheme.getTestScheme(), scheme.getProductionGroups(), scheme.getGeneratedScheme());
        DialogWrapper dialog2 = ComponentsKt.dialog$default((String)StatisticsBundle.message((String)"stats.edit.test.scheme", (Object[])new Object[0]), (JComponent)editTestSchemePanel, (boolean)true, (JComponent)editTestSchemePanel.getFocusedComponent(), (boolean)false, (Project)project2, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(editTestSchemePanel){
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel;

            @Nullable
            public final List<ValidationInfo> invoke() {
                return this.$editTestSchemePanel.validateGroups();
            }
            {
                this.$editTestSchemePanel = editEventsTestSchemePanel;
                super(0);
            }
        }), (int)976, null);
        Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)editTestSchemePanel);
        if (!dialog2.showAndGet()) {
            return;
        }
        String string = StatisticsBundle.message((String)"stats.updating.test.scheme", (Object[])new Object[0]);
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, project2, (String)title$iv, cancellable$iv, testSchemeStorage, editTestSchemePanel, project2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ ValidationTestRulesPersistedStorage $testSchemeStorage$inlined;
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$testSchemeStorage$inlined = validationTestRulesPersistedStorage;
                this.$editTestSchemePanel$inlined = editEventsTestSchemePanel;
                this.$project$inlined = project;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                try {
                    this.$testSchemeStorage$inlined.updateTestGroups(this.$editTestSchemePanel$inlined.getGroups());
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.INFORMATION, StatisticsBundle.message((String)"stats.test.scheme.was.updated", (Object[])new Object[0]));
                }
                catch (IOException ex) {
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.ERROR, StatisticsBundle.message((String)"stats.failed.updating.test.scheme.0", (Object[])new Object[]{ex.getMessage()}));
                }
            }
        });
    }

    private final EventsTestScheme loadEventsScheme(Project project, ValidationTestRulesPersistedStorage testSchemeStorage) {
        return (EventsTestScheme)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<EventsTestScheme, IOException>(this, testSchemeStorage, project, project, StatisticsBundle.message((String)"stats.loading.test.scheme", (Object[])new Object[0]), true){
            final /* synthetic */ EditEventsTestSchemeAction this$0;
            final /* synthetic */ ValidationTestRulesPersistedStorage $testSchemeStorage;
            final /* synthetic */ Project $project;

            @Nullable
            protected EventsTestScheme compute(@NotNull ProgressIndicator indicator) {
                List localGroups = this.$testSchemeStorage.loadValidationTestRules();
                if (indicator.isCanceled()) {
                    return null;
                }
                EventGroupRemoteDescriptors productionGroups = this.$testSchemeStorage.loadProductionGroups();
                if (indicator.isCanceled()) {
                    return null;
                }
                List eventsScheme = EventsSchemeBuilder.buildEventsScheme$default((String)EditEventsTestSchemeAction.access$getRecorderId$p(this.this$0), null, (int)2, null);
                return new EventsTestScheme(localGroups, productionGroups, eventsScheme);
            }
            {
                this.this$0 = this$0;
                this.$testSchemeStorage = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId));
        ValidationTestRulesPersistedStorage validationTestRulesPersistedStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        int testSchemeSize = validationTestRulesPersistedStorage != null ? validationTestRulesPersistedStorage.size() : 0;
        String text = testSchemeSize < 100 ? String.valueOf(testSchemeSize) : "99+";
        TextIcon sizeCountIcon = new TextIcon(text, (Color)JBColor.DARK_GRAY, UIUtil.getLabelBackground(), 1);
        sizeCountIcon.setFont(new Font(StartupUiUtil.getLabelFont().getName(), 1, JBUIScale.scale((int)9)));
        sizeCountIcon.setInsets(1, 1, 0, 0);
        ICON.setIcon((Icon)sizeCountIcon, 1, JBUIScale.scale((int)10), JBUIScale.scale((int)10));
        e.getPresentation().setIcon((Icon)ICON);
    }

    public EditEventsTestSchemeAction(@NotNull String recorderId) {
        super(ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.description", (Object[])new Object[0]), (Icon)ICON);
        this.recorderId = recorderId;
    }

    public /* synthetic */ EditEventsTestSchemeAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    public EditEventsTestSchemeAction() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        ICON = new LayeredIcon(2);
        ICON.setIcon(AllIcons.Actions.Edit, 0);
    }

    public static final /* synthetic */ String access$getRecorderId$p(EditEventsTestSchemeAction $this) {
        return $this.recorderId;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "", "testScheme", "", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "productionGroups", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "generatedScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "(Ljava/util/List;Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Ljava/util/List;)V", "getGeneratedScheme", "()Ljava/util/List;", "getProductionGroups", "()Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "getTestScheme", "intellij.platform.statistics.devkit"})
    public static final class EventsTestScheme {
        @NotNull
        private final List<GroupValidationTestRule> testScheme;
        @NotNull
        private final EventGroupRemoteDescriptors productionGroups;
        @NotNull
        private final List<GroupDescriptor> generatedScheme;

        @NotNull
        public final List<GroupValidationTestRule> getTestScheme() {
            return this.testScheme;
        }

        @NotNull
        public final EventGroupRemoteDescriptors getProductionGroups() {
            return this.productionGroups;
        }

        @NotNull
        public final List<GroupDescriptor> getGeneratedScheme() {
            return this.generatedScheme;
        }

        public EventsTestScheme(@NotNull List<GroupValidationTestRule> testScheme, @NotNull EventGroupRemoteDescriptors productionGroups, @NotNull List<GroupDescriptor> generatedScheme) {
            this.testScheme = testScheme;
            this.productionGroups = productionGroups;
            this.generatedScheme = generatedScheme;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$Companion;", "", "()V", "ICON", "Lcom/intellij/ui/LayeredIcon;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

