/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventMetadataFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestParseEventsSchemeDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(TestParseEventsSchemeDialog.class);
    private static final int IN_DIVIDER_LOCATION = 650;
    private static final int IN_OUT_DIVIDER_LOCATION = 300;
    private JPanel myMainPanel;
    private JPanel myEventsSchemePanel;
    private JPanel myResultPanel;
    private JEditorPane myEventLogPanel;
    private JSplitPane myInputDataSplitPane;
    private JSplitPane myInputOutputSplitPane;
    private final Project myProject;
    private final EditorEx myEventsSchemeEditor;
    private final EditorEx myResultEditor;
    private final List<PsiFile> myTempFiles;

    protected TestParseEventsSchemeDialog(@NotNull Project project, @Nullable Editor selectedEditor) {
        super(project);
        this.$$$setupUI$$$();
        this.myTempFiles = new ArrayList<PsiFile>();
        this.myProject = project;
        this.setOKButtonText("&Filter Event Log");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle((String)(selectedFile == null ? "Event Log Filter" : "Event Log Filter by: " + selectedFile.getName()));
        this.myEventsSchemeEditor = this.initEditor(selectedEditor, "events-scheme", "{\"groups\":[]}");
        this.myEventsSchemeEditor.getSettings().setLineMarkerAreaShown(false);
        this.myResultEditor = this.initEditor(null, "event-log-filter-result", "{}");
        this.myResultEditor.getSettings().setLineMarkerAreaShown(false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEventsSchemeEditor.getContentComponent(), true));
                this.myEventsSchemeEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myEventsSchemeEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }, ModalityState.stateForComponent((Component)this.myMainPanel));
        }
    }

    @NotNull
    private EditorEx initEditor(@Nullable Editor selectedEditor, @NotNull String fileName, @NotNull String templateText) {
        if (selectedEditor != null) {
            return (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
        }
        PsiFile file = TestParseEventsSchemeDialog.createTempFile(this.myProject, fileName, templateText);
        assert (file != null);
        this.myTempFiles.add(file);
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)templateText);
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, file.getVirtualFile(), false);
        editor.setFile(file.getVirtualFile());
        return editor;
    }

    @Nullable
    public static PsiFile createTempFile(@NotNull Project project, @NotNull String filename, @NotNull String request) {
        String fileName = PathUtil.makeFileName((String)filename, (String)"json");
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file = fileService.findFile(RootType.findById((String)"scratches"), fileName, ScratchFileService.Option.create_if_missing);
                fileService.getScratchesMapping().setMapping(file, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            return (PsiFile)WriteCommandAction.writeCommandAction((Project)project).withName(StatisticsBundle.message((String)"stats.creating.temp.json.file.for.event.log", (Object[])new Object[0])).withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void init() {
        TestParseEventsSchemeDialog.configEditorPanel(this.myProject, this.myEventsSchemePanel, this.myEventsSchemeEditor);
        TestParseEventsSchemeDialog.configEditorPanel(this.myProject, this.myResultPanel, this.myResultEditor);
        this.myInputDataSplitPane.setDividerLocation(650);
        this.myInputOutputSplitPane.setDividerLocation(300);
        super.init();
    }

    private static void configEditorPanel(@NotNull Project project, @NotNull JPanel panel2, @NotNull EditorEx editor) {
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)editor.getComponent(), "Center");
        editor.getSettings().setFoldingOutlineShown(false);
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.json", fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, (VirtualFile)lightFile);
        try {
            editor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return TestParseEventsSchemeDialog.class.getCanonicalName();
    }

    protected void doOKAction() {
        this.myEventsSchemeEditor.getSelectionModel().removeSelection();
        this.myResultEditor.getSelectionModel().removeSelection();
        this.updateResultRequest("{}");
        try {
            EventGroupRemoteDescriptors groups = EventLogMetadataUtils.parseGroupRemoteDescriptors((String)this.myEventsSchemeEditor.getDocument().getText());
            EventGroupsFilterRules scheme = EventGroupsFilterRules.create((EventGroupRemoteDescriptors)groups, (EventLogBuildParser)EventLogBuild.EVENT_LOG_BUILD_PRODUCER);
            String parsed = TestParseEventsSchemeDialog.parseLogAndFilter((LogEventFilter)new LogEventMetadataFilter(scheme), this.myEventLogPanel.getText());
            this.updateResultRequest(parsed.trim());
        }
        catch (EventLogMetadataParseException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Failed Parsing Events Scheme");
        }
        catch (ParseEventLogMetadataException | IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Failed Applying Events Scheme to Event Log");
        }
    }

    private void updateResultRequest(@NotNull String text) {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            DocumentEx document = this.myResultEditor.getDocument();
            document.setText((CharSequence)text);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument((Document)this.myResultEditor.getDocument());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String parseLogAndFilter(@NotNull LogEventFilter filter2, @NotNull String text) throws IOException, ParseEventLogMetadataException {
        File log = FileUtil.createTempFile((String)"feature-event-log", (String)".log");
        try {
            FileUtil.writeToFile((File)log, (String)text);
            String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
            TestDataCollectorDebugLogger logger = new TestDataCollectorDebugLogger();
            LogEventRecordRequest request = LogEventRecordRequest.Companion.create(log, "FUS", productCode, "test.device.id", filter2, true, (DataCollectorDebugLogger)logger, new MachineId("test.machine.id", 0));
            if (request == null) {
                throw new ParseEventLogMetadataException("Failed parsing event log");
            }
            String string = LogEventSerializer.INSTANCE.toString(request);
            return string;
        }
        finally {
            FileUtil.delete((File)log);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEventLogPanel;
    }

    public void dispose() {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            for (PsiFile file : this.myTempFiles) {
                try {
                    file.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (!this.myEventsSchemeEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEventsSchemeEditor);
        }
        if (!this.myResultEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myResultEditor);
        }
        super.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JSplitPane jSplitPane;
        JEditorPane jEditorPane;
        JSplitPane jSplitPane2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInputOutputSplitPane = jSplitPane2 = new JSplitPane();
        jSplitPane2.setOrientation(0);
        jPanel3.add((Component)jSplitPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane2.setRightComponent((Component)jBScrollPane);
        this.myEventLogPanel = jEditorPane = new JEditorPane();
        jEditorPane.setText("Add event log to filter here, one event per line");
        jBScrollPane.setViewportView(jEditorPane);
        this.myInputDataSplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(230);
        jSplitPane.setDividerSize(2);
        jSplitPane2.setLeftComponent(jSplitPane);
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane2);
        this.myEventsSchemePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel2);
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jSplitPane.setRightComponent((Component)jBScrollPane3);
        this.myResultPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class TestDataCollectorDebugLogger
    implements DataCollectorDebugLogger {
        private TestDataCollectorDebugLogger() {
        }

        public void info(String message) {
        }

        public void info(String message, Throwable t) {
        }

        public void warn(String message) {
        }

        public void warn(String message, Throwable t) {
        }

        public void trace(String message) {
        }

        public boolean isTraceEnabled() {
            return false;
        }
    }

    public static class ParseEventLogMetadataException
    extends Exception {
        public ParseEventLogMetadataException(String s) {
            super(s);
        }
    }
}

