/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class OpenEventLogFileAction
extends DumbAwareAction {
    private final String myRecorderId;

    public OpenEventLogFileAction(String recorderId) {
        super(StatisticsBundle.message((String)"stats.open.0.event.log", (Object[])new Object[]{recorderId}), ActionsBundle.message((String)"group.OpenEventLogFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
        this.myRecorderId = recorderId;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile logVFile;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        EventLogFile logFile = StatisticsEventLogProviderUtil.getEventLogProvider((String)this.myRecorderId).getActiveLogFile();
        VirtualFile virtualFile = logVFile = logFile != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(logFile.getFile()) : null;
        if (logVFile == null) {
            OpenEventLogFileAction.showNotification(project, StatisticsBundle.message((String)"stats.there.is.no.active.event.log", (Object[])new Object[0]));
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile(logVFile, true);
    }

    private static void showNotification(@NotNull Project project, @NotNull String message) {
        String title = StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]);
        new Notification("FeatureUsageStatistics", title, message, NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimple((String)StatisticsBundle.message((String)"stats.enable.data.sharing", (Object[])new Object[0]), () -> new SingleConfigurableEditor(project, (Configurable)new ConsentConfigurable()).show())).notify(project);
    }
}

