/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.annotations.NotNull;

public final class AndroidIdl {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidIdl");

    private AndroidIdl() {
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> execute(@NotNull IAndroidTarget target, @NotNull String file, @NotNull String outFile, @NotNull String[] sourceRootPaths) throws IOException {
        BuildToolInfo buildToolInfo = target.getBuildToolInfo();
        if (buildToolInfo == null) {
            return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
        }
        ArrayList<String> commands = new ArrayList<String>();
        String frameworkAidlPath = target.getPath(2).toString();
        commands.add(buildToolInfo.getPath(BuildToolInfo.PathId.AIDL));
        commands.add("-p" + frameworkAidlPath);
        for (String path : sourceRootPaths) {
            commands.add("-I" + path);
        }
        commands.add(file);
        commands.add(outFile);
        LOG.info(AndroidBuildCommonUtils.command2string(commands));
        return AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(commands));
    }
}

