/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginManagementModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginsBlockModel;
import com.android.tools.idea.projectsystem.DependencyManagementException;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.extensions.gradle.BuildScriptUtilsKt;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.extensions.gradle.KotlinGradleFacade;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradleFacadeImpl;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J,\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040!H\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J \u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J \u0010&\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J(\u0010'\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0017H\u0016J\u001e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f01H\u0017J$\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001f052\u0006\u0010\u0015\u001a\u00020\u001cJ\"\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0017H\u0014J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u001a\u0010=\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u0015\u001a\u00020\u001cH\u0014J\u0010\u0010@\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u0019H\u0002J\u0014\u0010C\u001a\u00020\u0010*\u00020D2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinWithGradleConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "addDependency", "", "moduleBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/GradleBuildModel;", "groupId", "artifactId", "version", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "originalVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "addKtxDependenciesFromMap", "module", "Lcom/intellij/openapi/module/Module;", "librayMap", "", "addToBuildscriptDependencies", "addToPluginsBlock", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "addToPluginsManagementBlock", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "doConfigure", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "modules", "", "getDependencyVersion", "getKotlinPluginExpression", "forKotlinDsl", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getStdlibArtifactName", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isApplicable", "isFileConfigured", "buildScript", "addRepositoryFor", "Lcom/android/tools/idea/gradle/dsl/api/repositories/RepositoriesModel;", "Companion", "intellij.android.kotlin.idea"})
public final class KotlinAndroidGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final TargetPlatform targetPlatform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
    @NotNull
    private final String presentableText;
    @NotNull
    private final String kotlinPluginName;
    @NotNull
    private static final String NAME = "android-gradle";
    @NotNull
    private static final String KOTLIN_ANDROID = "kotlin-android";
    @NotNull
    private static final String ANDROIDX_CORE_GROUP = "androidx.core";
    @NotNull
    private static final String CORE_KTX = "core-ktx";
    @NotNull
    private static final Map<String, String> nonAndroidxKtxLibraryMap;
    @NotNull
    private static final Map<String, String> androidxKtxLibraryMap;

    public KotlinAndroidGradleModuleConfigurator() {
        this.name = NAME;
        this.presentableText = "Android with Gradle";
        this.kotlinPluginName = KOTLIN_ANDROID;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
            Module module = moduleSourceRootGroup.getBaseModule();
            if (!this.isApplicable(module)) {
                return ConfigureKotlinStatus.NON_APPLICABLE;
            }
            List buildFiles2 = (List)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PsiFile>>(module){
                final /* synthetic */ Module $module;
                {
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final List<PsiFile> invoke() {
                    Object[] objectArray = new PsiFile[2];
                    objectArray[0] = BuildScriptUtilsKt.getBuildScriptPsiFile((Module)this.$module);
                    Project project = this.$module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                    objectArray[1] = BuildScriptUtilsKt.getTopLevelBuildScriptPsiFile((Project)project);
                    return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
                }
            }));
            if (buildFiles2.isEmpty()) {
                return ConfigureKotlinStatus.NON_APPLICABLE;
            }
            Iterable $this$none$iv = buildFiles2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl2 = false;
                    if (!this.isFileConfigured(it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
        }
        return ConfigureKotlinStatus.BROKEN;
    }

    private final boolean isFileConfigured(PsiFile buildScript) {
        GradleBuildScriptManipulator manipulator;
        GradleBuildScriptManipulator gradleBuildScriptManipulator = KotlinGradleFacade.DefaultImpls.findManipulator$default((KotlinGradleFacade)((KotlinGradleFacade)KotlinGradleFacadeImpl.INSTANCE), (PsiFile)buildScript, (boolean)false, (int)2, null);
        if (gradleBuildScriptManipulator == null) {
            return false;
        }
        GradleBuildScriptManipulator $this$isFileConfigured_u24lambda_u2d1 = manipulator = gradleBuildScriptManipulator;
        boolean bl = false;
        return $this$isFileConfigured_u24lambda_u2d1.isConfiguredWithOldSyntax(this.getKotlinPluginName()) || $this$isFileConfigured_u24lambda_u2d1.isConfigured(this.getKotlinPluginExpression(this.isKtDsl(buildScript)));
    }

    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return BuildSystemTypeKt.getBuildSystemType((Module)module) == BuildSystemType.AndroidGradle;
    }

    @NotNull
    protected String getKotlinPluginName() {
        return this.kotlinPluginName;
    }

    @NotNull
    protected String getKotlinPluginExpression(boolean forKotlinDsl) {
        return forKotlinDsl ? "kotlin(\"android\")" : "id 'org.jetbrains.kotlin.android' ";
    }

    private final void addRepositoryFor(RepositoriesModel $this$addRepositoryFor, String version) {
        if (StringsKt.contains$default((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null)) {
            $this$addRepositoryFor.addMavenRepositoryByUrl("https://oss.sonatype.org/content/repositories/snapshots", "Sonatype OSS Snapshot Repository");
        }
        if (!$this$addRepositoryFor.containsMethodCall("jcenter")) {
            $this$addRepositoryFor.addRepositoryByMethodName("mavenCentral");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addToBuildscriptDependencies(GradleBuildModel moduleBuildModel, String version) {
        DependenciesModel dependenciesModel;
        DependenciesModel dependenciesModel2;
        DependenciesModel it = dependenciesModel2 = moduleBuildModel.buildscript().dependencies();
        boolean bl = false;
        Object object = dependenciesModel = it.getPsiElement() != null ? dependenciesModel2 : null;
        if (dependenciesModel != null) {
            Object v2;
            DependenciesModel dependencies;
            block4: {
                void $this$firstOrNull$iv;
                dependencies = dependenciesModel;
                boolean bl2 = false;
                List list = dependencies.artifacts("classpath");
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dependencies\n           \u2026  .artifacts(\"classpath\")");
                Iterable iterable = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ArtifactDependencyModel it2 = (ArtifactDependencyModel)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it2.group().forceString(), (Object)"org.jetbrains.kotlin") && Intrinsics.areEqual((Object)it2.name().forceString(), (Object)"kotlin-gradle-plugin"))) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            ArtifactDependencyModel existing = v2;
            if (existing == null) {
                moduleBuildModel.buildscript().ext().findProperty("kotlin_version").setValue((Object)version);
                dependencies.addArtifact("classpath", "org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version");
                RepositoriesModel repositoriesModel = moduleBuildModel.buildscript().repositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"moduleBuildModel.buildscript().repositories()");
                this.addRepositoryFor(repositoriesModel, version);
                return true;
            }
            String currentVersion = (String)existing.version().resolve().getValue(GradlePropertyModel.STRING_TYPE);
            if (!Intrinsics.areEqual((Object)currentVersion, (Object)version)) {
                existing.version().resolve().setValue((Object)version);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addToPluginsBlock(ProjectBuildModel projectBuildModel, GradleBuildModel moduleBuildModel, String version) {
        List list;
        List list2;
        List it = list2 = moduleBuildModel.plugins();
        boolean bl = false;
        List list3 = list = moduleBuildModel.getPluginsPsiElement() != null ? list2 : null;
        if (list != null) {
            Object v1;
            RepositoriesModel repositoriesModel;
            block5: {
                void $this$firstOrNull$iv;
                List plugins = list;
                boolean bl2 = false;
                Iterable iterable = plugins;
                boolean $i$f$firstOrNull = false;
                repositoriesModel = $this$firstOrNull$iv.iterator();
                while (repositoriesModel.hasNext()) {
                    Object element$iv = repositoriesModel.next();
                    PluginModel it2 = (PluginModel)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2.name().forceString(), (Object)"org.jetbrains.kotlin.android")) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            PluginModel existing = v1;
            if (existing == null) {
                moduleBuildModel.applyPlugin("org.jetbrains.kotlin.android", version, Boolean.valueOf(false));
                GradleSettingsModel gradleSettingsModel = projectBuildModel.getProjectSettingsModel();
                if (gradleSettingsModel != null && (gradleSettingsModel = gradleSettingsModel.pluginManagement()) != null && (gradleSettingsModel = (repositoriesModel = gradleSettingsModel.repositories())) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)gradleSettingsModel, (String)"repositories()");
                    this.addRepositoryFor(repositoriesModel, version);
                }
                return true;
            }
            String currentVersion = (String)existing.version().resolve().getValue(GradlePropertyModel.STRING_TYPE);
            if (!Intrinsics.areEqual((Object)currentVersion, (Object)version)) {
                existing.version().setValue((Object)version);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addToPluginsManagementBlock(ProjectBuildModel projectBuildModel, GradleBuildModel moduleBuildModel, String version) {
        PluginsBlockModel pluginsBlockModel;
        PluginManagementModel pluginManagementModel;
        GradleSettingsModel gradleSettingsModel = projectBuildModel.getProjectSettingsModel();
        if (gradleSettingsModel != null && (pluginManagementModel = gradleSettingsModel.pluginManagement()) != null && (pluginsBlockModel = pluginManagementModel.plugins()) != null) {
            PluginsBlockModel pluginsBlockModel2;
            PluginsBlockModel pluginsBlockModel3;
            PluginsBlockModel it = pluginsBlockModel3 = pluginsBlockModel;
            boolean bl = false;
            Object object = pluginsBlockModel2 = it.getPsiElement() != null ? pluginsBlockModel3 : null;
            if (pluginsBlockModel2 != null) {
                Object v2;
                RepositoriesModel repositoriesModel;
                block6: {
                    void $this$firstOrNull$iv;
                    PluginsBlockModel plugins = pluginsBlockModel2;
                    boolean bl2 = false;
                    List list = plugins.plugins();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"plugins.plugins()");
                    Iterable iterable = list;
                    boolean $i$f$firstOrNull = false;
                    repositoriesModel = $this$firstOrNull$iv.iterator();
                    while (repositoriesModel.hasNext()) {
                        Object element$iv = repositoriesModel.next();
                        PluginModel it2 = (PluginModel)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.name().forceString(), (Object)"org.jetbrains.kotlin.android")) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                PluginModel existing = v2;
                if (existing == null) {
                    moduleBuildModel.applyPlugin("org.jetbrains.kotlin.android", version);
                    GradleSettingsModel gradleSettingsModel2 = projectBuildModel.getProjectSettingsModel();
                    if (gradleSettingsModel2 != null && (gradleSettingsModel2 = gradleSettingsModel2.pluginManagement()) != null && (gradleSettingsModel2 = (repositoriesModel = gradleSettingsModel2.repositories())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)gradleSettingsModel2, (String)"repositories()");
                        this.addRepositoryFor(repositoriesModel, version);
                    }
                    return true;
                }
                String currentVersion = (String)existing.version().resolve().getValue(GradlePropertyModel.STRING_TYPE);
                if (!Intrinsics.areEqual((Object)currentVersion, (Object)version)) {
                    existing.version().setValue((Object)version);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean addElementsToFile(@NotNull PsiFile file, boolean isTopLevelProjectFile, @NotNull IdeKotlinVersion originalVersion) {
        RepositoriesModel repositoriesModel;
        RepositoriesModel repositoriesModel2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)originalVersion, (String)"originalVersion");
        String version = originalVersion.getRawVersion();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            return false;
        }
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(project)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(module2);
        if (gradleBuildModel == null) {
            throw new IllegalStateException(("Build model for module " + module2 + " not found").toString());
        }
        GradleBuildModel moduleBuildModel = gradleBuildModel;
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        String jvmTarget = this.getJvmTarget(sdk, originalVersion);
        if (isTopLevelProjectFile) {
            boolean kotlinPluginAdded;
            boolean bl2 = kotlinPluginAdded = this.addToBuildscriptDependencies(moduleBuildModel, version) || this.addToPluginsBlock(projectBuildModel2, moduleBuildModel, version) || this.addToPluginsManagementBlock(projectBuildModel2, moduleBuildModel, version);
            if (kotlinPluginAdded) {
                RepositoriesModel repositoriesModel3;
                RepositoriesModel it = repositoriesModel3 = moduleBuildModel.repositories();
                boolean bl3 = false;
                Object object = it.getPsiElement() != null ? repositoriesModel3 : null;
                if (object != null) {
                    this.addRepositoryFor((RepositoriesModel)object, version);
                }
                projectBuildModel2.applyChanges();
            }
            return kotlinPluginAdded;
        }
        Project project3 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
        if (MigrateToAndroidxUtil.isAndroidx((Project)project3)) {
            this.addDependency(moduleBuildModel, ANDROIDX_CORE_GROUP, CORE_KTX, "+");
            this.addKtxDependenciesFromMap(module2, moduleBuildModel, androidxKtxLibraryMap);
        }
        this.addKtxDependenciesFromMap(module2, moduleBuildModel, nonAndroidxKtxLibraryMap);
        moduleBuildModel.applyPlugin("org.jetbrains.kotlin.android");
        GradleVersion gradleVersion = GradleVersion.tryParse((String)version);
        if (gradleVersion != null) {
            int it = gradleVersion.compareTo("1.4");
            boolean bl4 = false;
            boolean bl5 = it < 0;
            bl = !bl5;
        } else {
            bl = false;
        }
        if (!bl) {
            String string;
            String stdLibArtifactName = this.getStdlibArtifactName(sdk, originalVersion);
            GradleBuildModel buildModel = projectBuildModel2.getProjectBuildModel();
            GradleBuildModel gradleBuildModel2 = buildModel;
            GradlePropertyModel.ValueType valueType = gradleBuildModel2 != null && (gradleBuildModel2 = gradleBuildModel2.buildscript()) != null && (gradleBuildModel2 = gradleBuildModel2.ext()) != null && (gradleBuildModel2 = gradleBuildModel2.findProperty("kotlin_version")) != null ? gradleBuildModel2.getValueType() : null;
            switch (valueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
                case 1: {
                    if (this.isKtDsl(file)) {
                        string = "${extra[\"kotlin_version\"]}";
                        break;
                    }
                    string = "$kotlin_version";
                    break;
                }
                case -1: {
                    string = version;
                    break;
                }
                default: {
                    string = version;
                }
            }
            String versionString = string;
            ArtifactDependencySpec artifactDependencySpec = ArtifactDependencySpec.create((String)stdLibArtifactName, (String)"org.jetbrains.kotlin", (String)versionString);
            Intrinsics.checkNotNullExpressionValue((Object)artifactDependencySpec, (String)"create(stdLibArtifactNam\u2026s.kotlin\", versionString)");
            ArtifactDependencySpec spec = artifactDependencySpec;
            moduleBuildModel.dependencies().addArtifact("implementation", spec);
        }
        if (jvmTarget != null) {
            moduleBuildModel.android().kotlinOptions().jvmTarget().setValue((Object)jvmTarget);
        }
        RepositoriesModel it = repositoriesModel2 = moduleBuildModel.repositories();
        boolean bl6 = false;
        Object object = it.getPsiElement() != null ? repositoriesModel2 : null;
        if (object != null) {
            this.addRepositoryFor((RepositoriesModel)object, version);
        }
        GradleSettingsModel gradleSettingsModel = projectBuildModel2.getProjectSettingsModel();
        if (gradleSettingsModel != null && (repositoriesModel2 = gradleSettingsModel.dependencyResolutionManagement()) != null && (repositoriesModel = repositoriesModel2.repositories()) != null) {
            RepositoriesModel repositoriesModel4;
            RepositoriesModel repositoriesModel5;
            RepositoriesModel it2 = repositoriesModel5 = repositoriesModel;
            boolean bl7 = false;
            Object object2 = repositoriesModel4 = it2.getPsiElement() != null ? repositoriesModel5 : null;
            if (repositoriesModel4 != null) {
                this.addRepositoryFor(repositoriesModel4, version);
            }
        }
        projectBuildModel2.applyChanges();
        return true;
    }

    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk, @NotNull IdeKotlinVersion version) {
        JavaSdkVersion sdkVersion;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (sdk != null && KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime((IdeKotlinVersion)version) && (sdkVersion = ProjectStructureUtilKt.getVersion((Sdk)sdk)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            return "kotlin-stdlib-jdk7";
        }
        return super.getStdlibArtifactName(sdk, version);
    }

    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog = new ConfigureDialogWithModulesAndVersion(project, (KotlinProjectConfigurator)this, excludeModules, this.getMinimumSupportedVersion());
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        List list = dialog.getModulesToConfigure();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dialog.modulesToConfigure");
        String string = dialog.getKotlinVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dialog.kotlinVersion");
        NotificationMessageCollector collector = this.doConfigure(project, list, IdeKotlinVersion.Companion.get(string));
        collector.showNotification();
    }

    @NotNull
    public final NotificationMessageCollector doConfigure(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull IdeKotlinVersion version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return (NotificationMessageCollector)ApplicationUtilsKt.executeCommand$default((Project)project, (String)KotlinIdeaGradleBundle.message((String)"command.name.configure.kotlin", (Object[])new Object[0]), null, (Function0)((Function0)new Function0<NotificationMessageCollector>(project, this, modules, version){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinAndroidGradleModuleConfigurator this$0;
            final /* synthetic */ List<Module> $modules;
            final /* synthetic */ IdeKotlinVersion $version;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$modules = $modules;
                this.$version = $version;
                super(0);
            }

            @NotNull
            public final NotificationMessageCollector invoke() {
                NotificationMessageCollector collector = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector((Project)this.$project);
                HashSet changedFiles = this.this$0.configureWithVersion(this.$project, this.$modules, this.$version, collector);
                for (PsiFile file : changedFiles) {
                    OpenFileAction.openFile((VirtualFile)file.getVirtualFile(), (Project)this.$project);
                }
                ProjectSystemUtil.getProjectSystem((Project)this.$project).getSyncManager().syncProject(ProjectSystemSyncUtil.toReason((GradleSyncStats.Trigger)GradleSyncStats.Trigger.TRIGGER_LANGUAGE_KOTLIN_CONFIGURED));
                UndoManager.getInstance((Project)this.$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public void undo() {
                        ProjectSystemUtil.getProjectSystem((Project)this.$project).getSyncManager().syncProject(ProjectSystemSyncUtil.toReason((GradleSyncStats.Trigger)GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE));
                    }

                    public void redo() {
                        ProjectSystemUtil.getProjectSystem((Project)this.$project).getSyncManager().syncProject(ProjectSystemSyncUtil.toReason((GradleSyncStats.Trigger)GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE));
                    }
                });
                return collector;
            }
        }), (int)2, null);
    }

    private final void addDependency(GradleBuildModel moduleBuildModel, String groupId, String artifactId, String version) {
        moduleBuildModel.dependencies().addArtifact("implementation", ArtifactDependencySpec.create((String)artifactId, (String)groupId, (String)version));
    }

    private final String getDependencyVersion(Module module, String groupId, String artifactId) {
        try {
            GradleCoordinate coordinate = new GradleCoordinate(groupId, artifactId, "+");
            GradleCoordinate gradleCoordinate = ProjectSystemUtil.getModuleSystem((Module)module).getResolvedDependency(coordinate);
            return gradleCoordinate != null ? gradleCoordinate.getRevision() : null;
        }
        catch (DependencyManagementException e) {
            return null;
        }
    }

    private final void addKtxDependenciesFromMap(Module module, GradleBuildModel moduleBuildModel, Map<String, String> librayMap) {
        for (Map.Entry<String, String> entry : librayMap.entrySet()) {
            String it;
            String library = entry.getKey();
            String ktxLibrary = entry.getValue();
            String[] stringArray = new String[]{":"};
            List ids = StringsKt.split$default((CharSequence)library, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String[] stringArray2 = new String[]{":"};
            List ktxIds = StringsKt.split$default((CharSequence)ktxLibrary, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (this.getDependencyVersion(module, (String)ids.get(0), (String)ids.get(1)) == null) continue;
            boolean bl = false;
            this.addDependency(moduleBuildModel, (String)ktxIds.get(0), (String)ktxIds.get(1), it);
        }
    }

    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Pair pair = WhenMappings.$EnumSwitchMapping$1[feature.ordinal()] == 1 ? TuplesKt.to((Object)"-Xinline-classes", (Object)"-XXLanguage:-InlineClasses") : TuplesKt.to((Object)("-XXLanguage:+" + feature.name()), (Object)("-XXLanguage:-" + feature.name()));
            String enabledString = (String)pair.component1();
            String disabledString = (String)pair.component2();
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Project project2 = project;
            ProjectBuildModel projectBuildModel = ProjectBuildModel.get((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(project)");
            ProjectBuildModel projectBuildModel2 = projectBuildModel;
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(module);
            if (gradleBuildModel == null) {
                throw new IllegalStateException(("Build model for module " + module + " not found").toString());
            }
            GradleBuildModel moduleBuildModel = gradleBuildModel;
            GradlePropertyModel gradlePropertyModel = moduleBuildModel.android().kotlinOptions().freeCompilerArgs();
            Intrinsics.checkNotNullExpressionValue((Object)gradlePropertyModel, (String)"moduleBuildModel.android\u2026ions().freeCompilerArgs()");
            GradlePropertyModel freeCompilerArgs = gradlePropertyModel;
            switch (WhenMappings.$EnumSwitchMapping$2[state.ordinal()]) {
                case 1: {
                    GradlePropertyModel gradlePropertyModel2;
                    GradlePropertyModel gradlePropertyModel3 = freeCompilerArgs.getListValue((Object)disabledString);
                    if (gradlePropertyModel3 != null) {
                        gradlePropertyModel3.delete();
                    }
                    if ((gradlePropertyModel2 = freeCompilerArgs.getListValue((Object)enabledString)) != null) break;
                    GradlePropertyModel gradlePropertyModel4 = freeCompilerArgs.addListValue();
                    if (gradlePropertyModel4 != null) {
                        gradlePropertyModel4.setValue((Object)enabledString);
                        gradlePropertyModel2 = Unit.INSTANCE;
                        break;
                    }
                    gradlePropertyModel2 = null;
                    break;
                }
                case 2: {
                    GradlePropertyModel gradlePropertyModel5;
                    GradlePropertyModel gradlePropertyModel6 = freeCompilerArgs.getListValue((Object)enabledString);
                    if (gradlePropertyModel6 != null) {
                        gradlePropertyModel6.delete();
                    }
                    if ((gradlePropertyModel5 = freeCompilerArgs.getListValue((Object)disabledString)) != null) break;
                    GradlePropertyModel gradlePropertyModel7 = freeCompilerArgs.addListValue();
                    if (gradlePropertyModel7 != null) {
                        gradlePropertyModel7.setValue((Object)disabledString);
                        gradlePropertyModel5 = Unit.INSTANCE;
                        break;
                    }
                    gradlePropertyModel5 = null;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Setting a Kotlin language feature to state " + state + " is unsupported in android-kotlin");
                }
            }
            projectBuildModel2.applyChanges();
            moduleBuildModel.reparse();
            PsiElement psiElement = moduleBuildModel.android().kotlinOptions().freeCompilerArgs().getPsiElement();
            if (psiElement == null) break block9;
            PsiElement it = psiElement;
            boolean bl = false;
            new OpenFileDescriptor(project2, it.getContainingFile().getVirtualFile(), it.getTextRange().getStartOffset()).navigate(true);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"android.arch.navigation:navigation-ui", (Object)"android.arch.navigation:navigation-ui-ktx"), TuplesKt.to((Object)"android.arch.navigation:navigation-fragment", (Object)"android.arch.navigation:navigation-fragment-ktx")};
        nonAndroidxKtxLibraryMap = MapsKt.mapOf((Pair[])pairArray);
        androidxKtxLibraryMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"androidx.lifecycle:lifecycle-extensions", (Object)"androidx.lifecycle:lifecycle-viewmodel-ktx"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator$Companion;", "", "()V", "ANDROIDX_CORE_GROUP", "", "CORE_KTX", "KOTLIN_ANDROID", "NAME", "androidxKtxLibraryMap", "", "nonAndroidxKtxLibraryMap", "intellij.android.kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[GradlePropertyModel.ValueType.values().length];
            nArray[GradlePropertyModel.ValueType.STRING.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LanguageFeature.values().length];
            nArray[LanguageFeature.InlineClasses.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[LanguageFeature.State.values().length];
            nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            nArray[LanguageFeature.State.DISABLED.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

