/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class XmlResourceMapChunk
extends Chunk {
    private static final int RESOURCE_SIZE = 4;
    private final List<Integer> resources = new ArrayList<Integer>();

    protected XmlResourceMapChunk(ByteBuffer buffer2, Chunk parent) {
        super(buffer2, parent);
    }

    @Override
    protected void init(ByteBuffer buffer2) {
        super.init(buffer2);
        this.resources.addAll(this.enumerateResources(buffer2));
    }

    private List<Integer> enumerateResources(ByteBuffer buffer2) {
        int resourceCount = (this.getOriginalChunkSize() - this.getHeaderSize()) / 4;
        ArrayList<Integer> result = new ArrayList<Integer>(resourceCount);
        int offset = this.offset + this.getHeaderSize();
        buffer2.mark();
        buffer2.position(offset);
        for (int i = 0; i < resourceCount; ++i) {
            result.add(buffer2.getInt());
        }
        buffer2.reset();
        return result;
    }

    public BinaryResourceIdentifier getResourceId(int attributeId) {
        return BinaryResourceIdentifier.create(this.resources.get(attributeId));
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_RESOURCE_MAP;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        for (Integer resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

