/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class PackageUtils {
    public static final int PACKAGE_NAME_SIZE = 256;

    private PackageUtils() {
    }

    public static String readPackageName(ByteBuffer buffer2, int offset) {
        byte[] data = buffer2.array();
        int length = 0;
        for (int i = offset; i < data.length && i < 256 + offset; i += 2) {
            if (data[i] != 0 || data[i + 1] != 0) continue;
            length = i - offset;
            break;
        }
        Charset utf16 = Charset.forName("UTF-16LE");
        String str = new String(data, offset, length, utf16);
        buffer2.position(offset + 256);
        return str;
    }

    public static void writePackageName(ByteBuffer buffer2, String packageName) {
        byte[] nameBytes = packageName.getBytes(Charset.forName("UTF-16LE"));
        buffer2.put(nameBytes, 0, Math.min(nameBytes.length, 256));
        if (nameBytes.length < 256) {
            buffer2.put(new byte[256 - nameBytes.length]);
        }
    }
}

