/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Objects;

public class BinaryResourceValue
implements SerializableResource {
    public static final int SIZE = 8;
    private final int size;
    private final Type type;
    private final int data;

    public static BinaryResourceValue create(ByteBuffer buffer2) {
        int size = buffer2.getShort() & 0xFFFF;
        buffer2.get();
        Type type = Type.fromCode(buffer2.get());
        int data = buffer2.getInt();
        return new BinaryResourceValue(size, type, data);
    }

    private BinaryResourceValue(int size, Type type, int data) {
        this.size = size;
        this.type = type;
        this.data = data;
    }

    public int size() {
        return this.size;
    }

    public Type type() {
        return this.type;
    }

    public int data() {
        return this.data;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer2 = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer2.putShort((short)this.size());
        buffer2.put((byte)0);
        buffer2.put(this.type().code());
        buffer2.putInt(this.data());
        return buffer2.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryResourceValue that = (BinaryResourceValue)o;
        return this.size == that.size && this.data == that.data && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.type, this.data});
    }

    public static enum Type {
        NULL(0),
        REFERENCE(1),
        ATTRIBUTE(2),
        STRING(3),
        FLOAT(4),
        DIMENSION(5),
        FRACTION(6),
        DYNAMIC_REFERENCE(7),
        DYNAMIC_ATTRIBUTE(8),
        INT_DEC(16),
        INT_HEX(17),
        INT_BOOLEAN(18),
        INT_COLOR_ARGB8(28),
        INT_COLOR_RGB8(29),
        INT_COLOR_ARGB4(30),
        INT_COLOR_RGB4(31);

        private final byte code;
        private static final Map<Byte, Type> FROM_BYTE;

        private Type(int code) {
            this.code = UnsignedBytes.checkedCast((long)code);
        }

        public byte code() {
            return this.code;
        }

        public static Type fromCode(byte code) {
            return (Type)((Object)Preconditions.checkNotNull((Object)((Object)FROM_BYTE.get(code)), (String)"Unknown resource type: %s", (int)code));
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                builder.put((Object)type.code(), (Object)type);
            }
            FROM_BYTE = builder.build();
        }
    }
}

