/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class BinaryResourceIdentifier {
    private static final int PACKAGE_ID_MASK = -16777216;
    private static final int PACKAGE_ID_SHIFT = 24;
    private static final int TYPE_ID_MASK = 0xFF0000;
    private static final int TYPE_ID_SHIFT = 16;
    private static final int ENTRY_ID_MASK = 65535;
    private static final int ENTRY_ID_SHIFT = 0;
    private final int packageId;
    private final int typeId;
    private final int entryId;

    public static BinaryResourceIdentifier create(int resourceId) {
        int packageId = (resourceId & 0xFF000000) >>> 24;
        int typeId = (resourceId & 0xFF0000) >>> 16;
        int entryId = (resourceId & 0xFFFF) >>> 0;
        return BinaryResourceIdentifier.create(packageId, typeId, entryId);
    }

    public static BinaryResourceIdentifier create(int packageId, int typeId, int entryId) {
        Preconditions.checkState(((packageId & 0xFF) == packageId ? 1 : 0) != 0, (Object)"packageId must be <= 0xFF.");
        Preconditions.checkState(((typeId & 0xFF) == typeId ? 1 : 0) != 0, (Object)"typeId must be <= 0xFF.");
        Preconditions.checkState(((entryId & 0xFFFF) == entryId ? 1 : 0) != 0, (Object)"entryId must be <= 0xFFFF.");
        return new BinaryResourceIdentifier(packageId, typeId, entryId);
    }

    private BinaryResourceIdentifier(int packageId, int typeId, int entryId) {
        this.packageId = packageId;
        this.typeId = typeId;
        this.entryId = entryId;
    }

    public int packageId() {
        return this.packageId;
    }

    public int typeId() {
        return this.typeId;
    }

    public int entryId() {
        return this.entryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryResourceIdentifier that = (BinaryResourceIdentifier)o;
        return this.packageId == that.packageId && this.typeId == that.typeId && this.entryId == that.entryId;
    }

    public int hashCode() {
        return Objects.hash(this.packageId, this.typeId, this.entryId);
    }

    public String toString() {
        int v = this.packageId << 24 | this.typeId << 16 | this.entryId;
        return String.format("0x%1$08x", v);
    }
}

