/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipSourceEntry;
import com.android.zipflinger.ZipSourceEntryPipe;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ZipSource {
    public static final int COMPRESSION_NO_CHANGE = -2;
    private FileChannel channel;
    private ZipMap map;
    private final List<Source> selectedEntries = new ArrayList<Source>();

    public ZipSource(ZipMap map2) {
        this.map = map2;
    }

    public ZipSource(Path file) throws IOException {
        this(ZipMap.from(file, false));
    }

    public void select(String entryName, String newName) {
        this.select(entryName, newName, -2, 0L);
    }

    public void select(String entryName, String newName, int compressionLevel, long alignment) {
        Entry entry = this.map.getEntries().get(entryName);
        if (entry == null) {
            throw new IllegalStateException(String.format("Cannot find '%s' in archive '%s'", entryName, this.map.getPath()));
        }
        Source entrySource = this.newZipSourceEntryFor(newName, entry, compressionLevel);
        entrySource.align(alignment);
        entrySource.versionMadeBy = entry.getVersionMadeBy();
        entrySource.externalAttributes = entry.getExternalAttributes();
        this.selectedEntries.add(entrySource);
    }

    public Map<String, Entry> entries() {
        return this.map.getEntries();
    }

    public static ZipSource selectAll(Path file) throws IOException {
        ZipSource source = new ZipSource(file);
        for (Entry e : source.entries().values()) {
            source.select(e.getName(), e.getName(), -2, 0L);
        }
        return source;
    }

    void open() throws IOException {
        this.channel = FileChannel.open(this.map.getPath(), StandardOpenOption.READ);
    }

    void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    FileChannel getChannel() {
        return this.channel;
    }

    public List<? extends Source> getSelectedEntries() {
        return this.selectedEntries;
    }

    private Source newZipSourceEntryFor(String newName, Entry entry, int compressionLevel) {
        if (compressionLevel == -2 || !entry.isCompressed() && compressionLevel == 0) {
            return new ZipSourceEntry(newName, entry, this);
        }
        return new ZipSourceEntryPipe(newName, entry, this, compressionLevel);
    }

    String getName() {
        return this.map.getPath().toString();
    }

    public byte[] getComment() {
        return this.map.getComment();
    }
}

