/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class Compressor {
    public static ByteBuffer deflate(byte[] bytes, int offset, int size, int compressionLevel) throws IOException {
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream(size);
        Deflater deflater = new Deflater(compressionLevel, true);
        try (DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)out, deflater);){
            dout.write(bytes, offset, size);
            dout.flush();
        }
        return out.getByteBuffer();
    }

    public static ByteBuffer deflate(byte[] bytes, int compressionLevel) throws IOException {
        return Compressor.deflate(bytes, 0, bytes.length, compressionLevel);
    }

    public static ByteBuffer inflate(byte[] bytes) throws IOException {
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream(bytes.length);
        Inflater inflater = new Inflater(true);
        try (InflaterOutputStream dout = new InflaterOutputStream(out, inflater);){
            dout.write(bytes);
            dout.flush();
        }
        return out.getByteBuffer();
    }

    public static void pipe(InputStream in, OutputStream out, boolean inDeflated, int outputCompression) throws IOException {
        Inflater inflater = new Inflater(true);
        Deflater deflater = new Deflater(outputCompression, true);
        boolean outDeflated = outputCompression != 0;
        try (InputStream ins = inDeflated ? new InflaterInputStream(in, inflater) : in;
             OutputStream outs = outDeflated ? new DeflaterOutputStream(out, deflater) : out;){
            int read2;
            byte[] buffer2 = new byte[8192];
            while ((read2 = ins.read(buffer2)) != -1) {
                outs.write(buffer2, 0, read2);
            }
        }
    }

    static InputStream wrapToInflate(InputStream inputStream) {
        Inflater inflater = new Inflater(true);
        return new InflaterInputStream(inputStream, inflater);
    }

    static Deflater getDeflater(int compressionLevel) {
        return new Deflater(compressionLevel, true);
    }

    private Compressor() {
    }
}

