/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MethodProfileData {
    private static final TimeUnit DATA_TIME_UNITS = TimeUnit.NANOSECONDS;
    private final Map<Integer, MethodStats> mPerThreadCumulativeStats;
    private final Table<Integer, Long, MethodStats> mPerThreadStatsByCallee;
    private final Table<Integer, Long, MethodStats> mPerThreadStatsByCaller;
    private final boolean mIsRecursive;

    private MethodProfileData(Builder b) {
        this.mPerThreadCumulativeStats = ImmutableMap.copyOf(b.mPerThreadCumulativeStats);
        this.mPerThreadStatsByCallee = ImmutableTable.copyOf(b.mPerThreadStatsByCallee);
        this.mPerThreadStatsByCaller = ImmutableTable.copyOf(b.mPerThreadStatsByCaller);
        this.mIsRecursive = b.mRecursive;
    }

    public long getInvocationCount(ThreadInfo thread) {
        MethodStats stats = this.mPerThreadCumulativeStats.get(thread.getId());
        return this.getInvocationCount(stats);
    }

    public long getInvocationCountFromCaller(ThreadInfo thread, Long callerId) {
        MethodStats stats = (MethodStats)this.mPerThreadStatsByCaller.get((Object)thread.getId(), (Object)callerId);
        return this.getInvocationCount(stats);
    }

    public boolean isRecursive() {
        return this.mIsRecursive;
    }

    public long getExclusiveTime(ThreadInfo thread, ClockType clockType, TimeUnit unit) {
        MethodStats stats = this.mPerThreadCumulativeStats.get(thread.getId());
        return this.getExclusiveTime(stats, clockType, unit);
    }

    public long getInclusiveTime(ThreadInfo thread, ClockType clockType, TimeUnit unit) {
        MethodStats stats = this.mPerThreadCumulativeStats.get(thread.getId());
        return this.getInclusiveTime(stats, clockType, unit);
    }

    public Set<Long> getCallers(ThreadInfo thread) {
        Map perCallerStats = this.mPerThreadStatsByCaller.row((Object)thread.getId());
        return perCallerStats.keySet();
    }

    public Set<Long> getCallees(ThreadInfo thread) {
        Map perCalleeStats = this.mPerThreadStatsByCallee.row((Object)thread.getId());
        return perCalleeStats.keySet();
    }

    public long getExclusiveTimeByCaller(ThreadInfo thread, Long callerId, ClockType clockType, TimeUnit unit) {
        MethodStats stats = (MethodStats)this.mPerThreadStatsByCaller.get((Object)thread.getId(), (Object)callerId);
        return this.getExclusiveTime(stats, clockType, unit);
    }

    public long getInclusiveTimeByCaller(ThreadInfo thread, Long callerId, ClockType clockType, TimeUnit unit) {
        MethodStats stats = (MethodStats)this.mPerThreadStatsByCaller.get((Object)thread.getId(), (Object)callerId);
        return this.getInclusiveTime(stats, clockType, unit);
    }

    public long getInclusiveTimeByCallee(ThreadInfo thread, Long calleeId, ClockType clockType, TimeUnit unit) {
        MethodStats stats = (MethodStats)this.mPerThreadStatsByCallee.get((Object)thread.getId(), (Object)calleeId);
        return this.getInclusiveTime(stats, clockType, unit);
    }

    private long getExclusiveTime(MethodStats stats, ClockType clockType, TimeUnit unit) {
        return stats != null ? stats.getExclusiveTime(clockType, unit) : 0L;
    }

    private long getInclusiveTime(MethodStats stats, ClockType clockType, TimeUnit unit) {
        return stats != null ? stats.getInclusiveTime(clockType, unit) : 0L;
    }

    private long getInvocationCount(MethodStats stats) {
        return stats != null ? stats.getInvocationCount() : 0L;
    }

    public static class Builder {
        private final Map<Integer, MethodStats> mPerThreadCumulativeStats = Maps.newHashMap();
        private final Table<Integer, Long, MethodStats> mPerThreadStatsByCaller = HashBasedTable.create();
        private final Table<Integer, Long, MethodStats> mPerThreadStatsByCallee = HashBasedTable.create();
        private boolean mRecursive;

        public void addCallTime(Call call, Call parent, ThreadInfo thread) {
            for (ClockType type : ClockType.values()) {
                this.addExclusiveTime(call, parent, thread, type);
                if (call.isRecursive()) continue;
                this.addInclusiveTime(call, parent, thread, type);
            }
        }

        private void addExclusiveTime(Call call, Call parent, ThreadInfo thread, ClockType type) {
            long time = call.getExclusiveTime(type, DATA_TIME_UNITS);
            this.addExclusiveTime(this.getPerThreadStats(thread), time, type);
            if (parent != null) {
                this.addExclusiveTime(this.getPerCallerStats(thread, parent), time, type);
            }
        }

        private void addInclusiveTime(Call call, Call parent, ThreadInfo thread, ClockType type) {
            long time = call.getInclusiveTime(type, DATA_TIME_UNITS);
            this.addInclusiveTime(this.getPerThreadStats(thread), time, type);
            if (parent != null) {
                this.addInclusiveTime(this.getPerCallerStats(thread, parent), time, type);
            }
            for (Call callee : call.getCallees()) {
                this.addInclusiveTime(this.getPerCalleeStats(thread, callee), callee.getInclusiveTime(type, DATA_TIME_UNITS), type);
            }
        }

        private void addInclusiveTime(MethodStats stats, long time, ClockType type) {
            if (type == ClockType.THREAD) {
                stats.mInclusiveThreadTime += time;
            } else {
                stats.mInclusiveGlobalTime += time;
            }
        }

        private void addExclusiveTime(MethodStats stats, long time, ClockType type) {
            if (type == ClockType.THREAD) {
                stats.mExclusiveThreadTime += time;
            } else {
                stats.mExclusiveGlobalTime += time;
            }
        }

        private MethodStats getPerThreadStats(ThreadInfo thread) {
            MethodStats stats = this.mPerThreadCumulativeStats.get(thread.getId());
            if (stats == null) {
                stats = new MethodStats();
                this.mPerThreadCumulativeStats.put(thread.getId(), stats);
            }
            return stats;
        }

        private MethodStats getPerCallerStats(ThreadInfo thread, Call parent) {
            return this.getMethodStatsFromTable(thread.getId(), parent.getMethodId(), this.mPerThreadStatsByCaller);
        }

        private MethodStats getPerCalleeStats(ThreadInfo thread, Call callee) {
            return this.getMethodStatsFromTable(thread.getId(), callee.getMethodId(), this.mPerThreadStatsByCallee);
        }

        private MethodStats getMethodStatsFromTable(Integer threadId, Long methodId, Table<Integer, Long, MethodStats> statsTable) {
            MethodStats stats = (MethodStats)statsTable.get((Object)threadId, (Object)methodId);
            if (stats == null) {
                stats = new MethodStats();
                statsTable.put((Object)threadId, (Object)methodId, (Object)stats);
            }
            return stats;
        }

        public void incrementInvocationCount(Call c, Call parent, ThreadInfo thread) {
            ++this.getPerThreadStats((ThreadInfo)thread).mInvocationCount;
            if (parent != null) {
                ++this.getPerCallerStats((ThreadInfo)thread, (Call)parent).mInvocationCount;
            }
            for (Call callee : c.getCallees()) {
                ++this.getPerCalleeStats((ThreadInfo)thread, (Call)callee).mInvocationCount;
            }
        }

        public MethodProfileData build() {
            return new MethodProfileData(this);
        }

        public void setRecursive() {
            this.mRecursive = true;
        }
    }

    private static class MethodStats {
        private long mInclusiveThreadTime;
        private long mExclusiveThreadTime;
        private long mInclusiveGlobalTime;
        private long mExclusiveGlobalTime;
        private long mInvocationCount;

        private MethodStats() {
        }

        public long getInclusiveTime(ClockType clockType, TimeUnit unit) {
            long time = clockType == ClockType.THREAD ? this.mInclusiveThreadTime : this.mInclusiveGlobalTime;
            return unit.convert(time, DATA_TIME_UNITS);
        }

        public long getExclusiveTime(ClockType clockType, TimeUnit unit) {
            long time = clockType == ClockType.THREAD ? this.mExclusiveThreadTime : this.mExclusiveGlobalTime;
            return unit.convert(time, DATA_TIME_UNITS);
        }

        private long getInvocationCount() {
            return this.mInvocationCount;
        }
    }
}

