/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.analyzer.CaptureGroup;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzer;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

final class TaskRunner {
    TaskRunner() {
    }

    static List<AnalysisResultEntry<?>> runTasks(Set<MemoryAnalyzerTask> tasks, Set<AnalysisReport.Listener> listeners, CaptureGroup captureGroup) {
        final ArrayList generatedEntries = new ArrayList();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        HashSet<AnalysisReport.Listener> listenerSet = new HashSet<AnalysisReport.Listener>();
        listenerSet.addAll(listeners);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean cancelledOrInterrupted = new AtomicBoolean(false);
        listenerSet.add(new AnalysisReport.Listener(){

            @Override
            public void onResultsAdded(List<AnalysisResultEntry<?>> entries) {
                generatedEntries.addAll(entries);
            }

            @Override
            public void onAnalysisComplete() {
                latch.countDown();
            }

            @Override
            public void onAnalysisCancelled() {
                cancelledOrInterrupted.set(true);
                latch.countDown();
            }
        });
        MemoryAnalyzer memoryAnalyzer = new MemoryAnalyzer();
        memoryAnalyzer.analyze(captureGroup, listenerSet, tasks, executorService, executorService);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            cancelledOrInterrupted.set(true);
        }
        executorService.shutdownNow();
        if (!cancelledOrInterrupted.get()) {
            return generatedEntries;
        }
        return null;
    }

    static List<AnalysisResultEntry<?>> runTasks(Set<MemoryAnalyzerTask> tasks, CaptureGroup captureGroup) {
        return TaskRunner.runTasks(tasks, Collections.emptySet(), captureGroup);
    }

    static List<AnalysisResultEntry<?>> runTasks(Set<MemoryAnalyzerTask> tasks, Capture ... captures) {
        CaptureGroup captureGroup = new CaptureGroup();
        for (Capture capture : captures) {
            captureGroup.addCapture(capture);
        }
        return TaskRunner.runTasks(tasks, Collections.emptySet(), captureGroup);
    }
}

