/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Queries {
    private static final String DEFAULT_PACKAGE = "<default>";

    public static Map<String, Set<ClassObj>> allClasses(Snapshot snapshot) {
        return Queries.classes(snapshot, null);
    }

    public static Map<String, Set<ClassObj>> classes(Snapshot snapshot, String[] excludedPrefixes) {
        TreeMap<String, Set<ClassObj>> result = new TreeMap<String, Set<ClassObj>>();
        TreeSet<ClassObj> classes = new TreeSet<ClassObj>();
        for (Heap heap : snapshot.heapList) {
            classes.addAll(heap.getClasses());
        }
        if (excludedPrefixes != null) {
            int N = excludedPrefixes.length;
            Iterator iter = classes.iterator();
            block1: while (iter.hasNext()) {
                ClassObj theClass = (ClassObj)iter.next();
                String classPath = theClass.toString();
                for (int i = 0; i < N; ++i) {
                    if (!classPath.startsWith(excludedPrefixes[i])) continue;
                    iter.remove();
                    continue block1;
                }
            }
        }
        for (ClassObj theClass : classes) {
            Set<ClassObj> classSet;
            String packageName = DEFAULT_PACKAGE;
            int lastDot = theClass.getClassName().lastIndexOf(46);
            if (lastDot != -1) {
                packageName = theClass.getClassName().substring(0, lastDot);
            }
            if ((classSet = result.get(packageName)) == null) {
                classSet = new TreeSet<ClassObj>();
                result.put(packageName, classSet);
            }
            classSet.add(theClass);
        }
        return result;
    }

    public static Collection<ClassObj> commonClasses(Snapshot first, Snapshot second) {
        ArrayList<ClassObj> classes = new ArrayList<ClassObj>();
        for (Heap heap : first.getHeaps()) {
            for (ClassObj clazz : heap.getClasses()) {
                if (second.findClass(clazz.getClassName()) == null) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    public static ClassObj findClass(Snapshot snapshot, String name) {
        return snapshot.findClass(name);
    }

    public static Instance[] instancesOf(Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        List<Instance> instances = theClass.getInstancesList();
        return instances.toArray(new Instance[instances.size()]);
    }

    public static Instance[] allInstancesOf(Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        ArrayList<ClassObj> classList = new ArrayList<ClassObj>();
        classList.add(theClass);
        classList.addAll(Queries.traverseSubclasses(theClass));
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (ClassObj someClass : classList) {
            instanceList.addAll(someClass.getInstancesList());
        }
        Instance[] result = new Instance[instanceList.size()];
        instanceList.toArray(result);
        return result;
    }

    private static ArrayList<ClassObj> traverseSubclasses(ClassObj base) {
        ArrayList<ClassObj> result = new ArrayList<ClassObj>();
        for (ClassObj subclass : base.getSubclasses()) {
            result.add(subclass);
            result.addAll(Queries.traverseSubclasses(subclass));
        }
        return result;
    }

    public static Instance findObject(Snapshot snapshot, String id) {
        long id2 = Long.parseLong(id, 16);
        return snapshot.findInstance(id2);
    }

    @Deprecated
    public static Collection<RootObj> getRoots(Snapshot snapshot) {
        return snapshot.getGcRoots();
    }

    public static final Instance[] newInstances(Snapshot older, Snapshot newer) {
        final ArrayList resultList = new ArrayList();
        for (Heap newHeap : newer.heapList) {
            final Heap oldHeap = older.getHeap(newHeap.getName());
            if (oldHeap == null) continue;
            newHeap.forEachInstance(new TObjectProcedure<Instance>(){

                public boolean execute(Instance instance) {
                    Instance oldInstance = oldHeap.getInstance(instance.getId());
                    if (oldInstance == null || instance.getClassObj() != oldInstance.getClassObj()) {
                        resultList.add(instance);
                    }
                    return true;
                }
            });
        }
        Instance[] resultArray = new Instance[resultList.size()];
        return resultList.toArray(resultArray);
    }
}

