/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.InstanceList;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH&J\u000e\u0010O\u001a\u00020L2\u0006\u0010P\u001a\u00020\u0000J\u0018\u0010Q\u001a\u00020L2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020\u0000J\u000e\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\"J\b\u0010W\u001a\u00020\u0003H\u0004J\b\u0010X\u001a\u00020\"H\u0004J\b\u0010Y\u001a\u00020\"H\u0004J\u0012\u0010Z\u001a\u0004\u0018\u00010\u00012\u0006\u0010[\u001a\u00020\\H\u0004J\u0006\u0010]\u001a\u00020LJ\b\u0010^\u001a\u00020LH&R%\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR%\u0010\u000e\u001a\u00020\bX\u0080\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR%\u0010\u0011\u001a\u00020\bX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u0010&\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u001c\u00100\u001a\u0004\u0018\u000101X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u001aR\u0011\u00107\u001a\u0002088F\u00a2\u0006\u0006\u001a\u0004\b7\u00109R\u0014\u0010:\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00109R\u001a\u0010;\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001a\"\u0004\b=\u0010\u001cR\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010$\"\u0004\bB\u0010)R\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00000+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010-R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001aR\u0014\u0010I\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001a\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006_"}, d2={"Lcom/android/tools/perflib/heap/Instance;", "", "id", "", "stack", "Lcom/android/tools/perflib/heap/StackTrace;", "(JLcom/android/tools/perflib/heap/StackTrace;)V", "_hardFwdRefs", "Lcom/android/tools/perflib/heap/InstanceList;", "get_hardFwdRefs-s3XpT2Q$android_sdktools_perflib", "()Ljava/lang/Object;", "set_hardFwdRefs-OLAdukE$android_sdktools_perflib", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "_hardRevRefs", "get_hardRevRefs-s3XpT2Q$android_sdktools_perflib", "set_hardRevRefs-OLAdukE$android_sdktools_perflib", "_softRevRefs", "get_softRevRefs-s3XpT2Q", "set_softRevRefs-OLAdukE", "buffer", "Lcom/android/tools/perflib/captures/DataBuffer;", "getBuffer", "()Lcom/android/tools/perflib/captures/DataBuffer;", "classId", "getClassId", "()J", "setClassId", "(J)V", "classObj", "Lcom/android/tools/perflib/heap/ClassObj;", "getClassObj", "()Lcom/android/tools/perflib/heap/ClassObj;", "compositeSize", "", "getCompositeSize", "()I", "newDistance", "distanceToGcRoot", "getDistanceToGcRoot", "setDistanceToGcRoot", "(I)V", "hardForwardReferences", "Lkotlin/sequences/Sequence;", "getHardForwardReferences", "()Lkotlin/sequences/Sequence;", "hardReverseReferences", "getHardReverseReferences", "heap", "Lcom/android/tools/perflib/heap/Heap;", "getHeap", "()Lcom/android/tools/perflib/heap/Heap;", "setHeap", "(Lcom/android/tools/perflib/heap/Heap;)V", "getId", "isReachable", "", "()Z", "isSoftReference", "nativeSize", "getNativeSize", "setNativeSize", "retainedSizes", "", "size", "getSize", "setSize", "softReverseReferences", "getSoftReverseReferences", "getStack", "()Lcom/android/tools/perflib/heap/StackTrace;", "totalRetainedSize", "getTotalRetainedSize", "uniqueId", "getUniqueId", "accept", "", "visitor", "Lcom/android/tools/perflib/heap/Visitor;", "addRetainedSizes", "other", "addReverseReference", "field", "Lcom/android/tools/perflib/heap/Field;", "reference", "getRetainedSize", "heapIndex", "readId", "readUnsignedByte", "readUnsignedShort", "readValue", "type", "Lcom/android/tools/perflib/heap/Type;", "resetRetainedSize", "resolveReferences", "android.sdktools.perflib"})
public abstract class Instance {
    private final long id;
    @Nullable
    private final StackTrace stack;
    private long classId;
    @Nullable
    private Heap heap;
    private int size;
    private long nativeSize;
    @Nullable
    private long[] retainedSizes;
    @NotNull
    private Object _hardFwdRefs;
    @NotNull
    private Object _hardRevRefs;
    @NotNull
    private Object _softRevRefs;
    private int distanceToGcRoot;

    public Instance(long id, @Nullable StackTrace stack) {
        this.id = id;
        this.stack = stack;
        this._hardFwdRefs = InstanceList.Companion.getEmpty-s3XpT2Q();
        this._hardRevRefs = InstanceList.Companion.getEmpty-s3XpT2Q();
        this._softRevRefs = InstanceList.Companion.getEmpty-s3XpT2Q();
        this.distanceToGcRoot = Integer.MAX_VALUE;
    }

    public final long getId() {
        return this.id;
    }

    @Nullable
    public final StackTrace getStack() {
        return this.stack;
    }

    public final long getClassId() {
        return this.classId;
    }

    public final void setClassId(long l) {
        this.classId = l;
    }

    public long getUniqueId() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        return this.id & heap.mSnapshot.getIdSizeMask();
    }

    @Nullable
    public Heap getHeap() {
        return this.heap;
    }

    public void setHeap(@Nullable Heap heap) {
        this.heap = heap;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public final long getNativeSize() {
        return this.nativeSize;
    }

    public final void setNativeSize(long l) {
        this.nativeSize = l;
    }

    @NotNull
    public final Object get_hardFwdRefs-s3XpT2Q$android_sdktools_perflib() {
        return this._hardFwdRefs;
    }

    public final void set_hardFwdRefs-OLAdukE$android_sdktools_perflib(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this._hardFwdRefs = object;
    }

    @NotNull
    public final Sequence<Instance> getHardForwardReferences() {
        return InstanceList.asInstanceSequence-impl(this._hardFwdRefs);
    }

    @NotNull
    public final Object get_hardRevRefs-s3XpT2Q$android_sdktools_perflib() {
        return this._hardRevRefs;
    }

    public final void set_hardRevRefs-OLAdukE$android_sdktools_perflib(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this._hardRevRefs = object;
    }

    @NotNull
    public Sequence<Instance> getHardReverseReferences() {
        return InstanceList.asInstanceSequence-impl(this._hardRevRefs);
    }

    @NotNull
    public final Object get_softRevRefs-s3XpT2Q() {
        return this._softRevRefs;
    }

    public final void set_softRevRefs-OLAdukE(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this._softRevRefs = object;
    }

    @NotNull
    public Sequence<Instance> getSoftReverseReferences() {
        return InstanceList.asInstanceSequence-impl(this._softRevRefs);
    }

    @Nullable
    public ClassObj getClassObj() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        return heap.mSnapshot.findClass(this.classId);
    }

    public final int getCompositeSize() {
        NonRecursiveVisitor visitor2 = new NonRecursiveVisitor(){
            private int compositeSize;

            public final int getCompositeSize() {
                return this.compositeSize;
            }

            public final void setCompositeSize(int n) {
                this.compositeSize = n;
            }

            protected void defaultAction(@NotNull Instance node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.compositeSize += (int)((long)node.getSize() + node.getNativeSize());
            }
        };
        visitor2.doVisit(CollectionsKt.listOf((Object)this));
        return visitor2.getCompositeSize();
    }

    public int getDistanceToGcRoot() {
        return this.distanceToGcRoot;
    }

    public void setDistanceToGcRoot(int newDistance) {
        boolean bl;
        boolean bl2 = bl = newDistance < this.distanceToGcRoot;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.distanceToGcRoot = newDistance;
    }

    public final boolean isReachable() {
        return this.getDistanceToGcRoot() != Integer.MAX_VALUE;
    }

    public boolean isSoftReference() {
        return false;
    }

    @NotNull
    protected final DataBuffer getBuffer() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        return heap.mSnapshot.getBuffer();
    }

    public abstract void resolveReferences();

    public abstract void accept(@NotNull Visitor var1);

    public final void resetRetainedSize() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        List allHeaps = heap.mSnapshot.heapList;
        if (this.retainedSizes == null) {
            this.retainedSizes = new long[allHeaps.size()];
        } else {
            Intrinsics.checkNotNull((Object)this.retainedSizes);
            Arrays.fill(this.retainedSizes, 0L);
        }
        Intrinsics.checkNotNull((Object)this.retainedSizes);
        this.retainedSizes[allHeaps.indexOf((Object)this.getHeap())] = (long)this.getSize() + this.nativeSize;
    }

    public final void addRetainedSizes(@NotNull Instance other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNull((Object)this.retainedSizes);
        int n = this.retainedSizes.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.retainedSizes);
            long[] lArray = this.retainedSizes;
            int n2 = i;
            long l = lArray[n2];
            Intrinsics.checkNotNull((Object)other.retainedSizes);
            lArray[n2] = l + other.retainedSizes[i];
        }
    }

    public final long getRetainedSize(int heapIndex) {
        Intrinsics.checkNotNull((Object)this.retainedSizes);
        return this.retainedSizes[heapIndex];
    }

    public final long getTotalRetainedSize() {
        return this.retainedSizes != null ? ArraysKt.sum((long[])this.retainedSizes) : 0L;
    }

    public final void addReverseReference(@Nullable Field field, @NotNull Instance reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (field != null && Intrinsics.areEqual((Object)field.getName(), (Object)"referent") && reference.isSoftReference()) {
            this._softRevRefs = InstanceList.plus-GO6bYc0(this._softRevRefs, reference);
        } else {
            this._hardRevRefs = InstanceList.plus-GO6bYc0(this._hardRevRefs, reference);
        }
    }

    @Nullable
    protected final Object readValue(@NotNull Type type) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Heap heap = this.getHeap();
                Intrinsics.checkNotNull((Object)heap);
                object = heap.mSnapshot.findInstance(this.readId());
                break;
            }
            case 2: {
                object = this.getBuffer().readByte() != 0;
                break;
            }
            case 3: {
                object = Character.valueOf(this.getBuffer().readChar());
                break;
            }
            case 4: {
                object = Float.valueOf(this.getBuffer().readFloat());
                break;
            }
            case 5: {
                object = this.getBuffer().readDouble();
                break;
            }
            case 6: {
                object = this.getBuffer().readByte();
                break;
            }
            case 7: {
                object = this.getBuffer().readShort();
                break;
            }
            case 8: {
                object = this.getBuffer().readInt();
                break;
            }
            case 9: {
                object = this.getBuffer().readLong();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    protected final long readId() {
        long l;
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        switch (heap.mSnapshot.getTypeSize(Type.OBJECT)) {
            case 1: {
                l = this.getBuffer().readByte();
                break;
            }
            case 2: {
                l = this.getBuffer().readShort();
                break;
            }
            case 4: {
                l = this.getBuffer().readInt();
                break;
            }
            case 8: {
                l = this.getBuffer().readLong();
                break;
            }
            default: {
                l = 0L;
            }
        }
        return l;
    }

    protected final int readUnsignedByte() {
        return UnsignedBytes.toInt((byte)this.getBuffer().readByte());
    }

    protected final int readUnsignedShort() {
        return this.getBuffer().readShort() & 0xFFFF;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.OBJECT.ordinal()] = 1;
            nArray[Type.BOOLEAN.ordinal()] = 2;
            nArray[Type.CHAR.ordinal()] = 3;
            nArray[Type.FLOAT.ordinal()] = 4;
            nArray[Type.DOUBLE.ordinal()] = 5;
            nArray[Type.BYTE.ordinal()] = 6;
            nArray[Type.SHORT.ordinal()] = 7;
            nArray[Type.INT.ordinal()] = 8;
            nArray[Type.LONG.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

