/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.InstanceList;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 f2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0002fgB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J\u0016\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020\u0001J\u000e\u0010V\u001a\u0002072\u0006\u0010W\u001a\u00020\u0000J\u0011\u0010X\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010Z\u001a\u00020PJ\u0013\u0010[\u001a\u0002072\b\u0010Y\u001a\u0004\u0018\u00010?H\u0096\u0002J\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u0001032\u0006\u0010T\u001a\u00020\fJ\u000e\u0010]\u001a\u00020\f2\u0006\u0010T\u001a\u00020\fJ\u000e\u0010<\u001a\u00020\f2\u0006\u0010T\u001a\u00020\fJ\u0018\u0010^\u001a\u0004\u0018\u00010?2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020\bJ\b\u0010b\u001a\u00020\fH\u0016J\b\u0010c\u001a\u00020PH\u0016J\u0006\u0010d\u001a\u00020PJ\b\u0010e\u001a\u00020\bH\u0016R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000eR\u001a\u0010.\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u000e\"\u0004\b0\u00101R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u0001038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00108\"\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u000eR\"\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010?0>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\"\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\bC\u0010!\"\u0004\bD\u0010#R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00000F\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0014\"\u0004\bK\u0010\u0016R\u0013\u0010L\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\bM\u0010N\u00a8\u0006h"}, d2={"Lcom/android/tools/perflib/heap/ClassObj;", "Lcom/android/tools/perflib/heap/Instance;", "", "id", "", "stack", "Lcom/android/tools/perflib/heap/StackTrace;", "className", "", "staticFieldsOffset", "(JLcom/android/tools/perflib/heap/StackTrace;Ljava/lang/String;J)V", "allFieldsCount", "", "getAllFieldsCount", "()I", "classLoader", "getClassLoader", "()Lcom/android/tools/perflib/heap/Instance;", "classLoaderId", "getClassLoaderId", "()J", "setClassLoaderId", "(J)V", "getClassName", "()Ljava/lang/String;", "descendantClasses", "Lkotlin/sequences/Sequence;", "getDescendantClasses", "()Lkotlin/sequences/Sequence;", "fields", "", "Lcom/android/tools/perflib/heap/Field;", "getFields", "()[Lcom/android/tools/perflib/heap/Field;", "setFields", "([Lcom/android/tools/perflib/heap/Field;)V", "[Lcom/android/tools/perflib/heap/Field;", "heapData", "Lgnu/trove/TIntObjectHashMap;", "Lcom/android/tools/perflib/heap/ClassObj$HeapData;", "getHeapData", "()Lgnu/trove/TIntObjectHashMap;", "setHeapData", "(Lgnu/trove/TIntObjectHashMap;)V", "instanceCount", "getInstanceCount", "instanceSize", "getInstanceSize", "setInstanceSize", "(I)V", "instancesList", "", "getInstancesList", "()Ljava/util/List;", "isSoftReference", "", "()Z", "setSoftReference", "(Z)V", "shallowSize", "getShallowSize", "staticFieldValues", "", "", "getStaticFieldValues", "()Ljava/util/Map;", "staticFields", "getStaticFields", "setStaticFields", "subclasses", "", "getSubclasses", "()Ljava/util/Set;", "superClassId", "getSuperClassId", "setSuperClassId", "superClassObj", "getSuperClassObj", "()Lcom/android/tools/perflib/heap/ClassObj;", "accept", "", "visitor", "Lcom/android/tools/perflib/heap/Visitor;", "addInstance", "heapId", "instance", "addSubclass", "subclass", "compareTo", "o", "dumpSubclasses", "equals", "getHeapInstances", "getHeapInstancesCount", "getStaticField", "type", "Lcom/android/tools/perflib/heap/Type;", "name", "hashCode", "resolveReferences", "setIsSoftReference", "toString", "Companion", "HeapData", "android.sdktools.perflib"})
public class ClassObj
extends Instance
implements Comparable<ClassObj> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String className;
    private final long staticFieldsOffset;
    private long superClassId;
    private long classLoaderId;
    @NotNull
    private Field[] fields;
    @NotNull
    private Field[] staticFields;
    private int instanceSize;
    private boolean isSoftReference;
    @NotNull
    private TIntObjectHashMap<HeapData> heapData;
    @NotNull
    private final Set<ClassObj> subclasses;

    public ClassObj(long id, @Nullable StackTrace stack, @NotNull String className, long staticFieldsOffset) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        super(id, stack);
        this.className = className;
        this.staticFieldsOffset = staticFieldsOffset;
        boolean bl = false;
        Field[] fieldArray = new Field[]{};
        ClassObj classObj = this;
        classObj.fields = fieldArray;
        bl = false;
        fieldArray = new Field[]{};
        classObj = this;
        classObj.staticFields = fieldArray;
        this.heapData = new TIntObjectHashMap();
        this.subclasses = new LinkedHashSet();
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public final long getSuperClassId() {
        return this.superClassId;
    }

    public final void setSuperClassId(long l) {
        this.superClassId = l;
    }

    public final long getClassLoaderId() {
        return this.classLoaderId;
    }

    public final void setClassLoaderId(long l) {
        this.classLoaderId = l;
    }

    @NotNull
    public final Field[] getFields() {
        return this.fields;
    }

    public final void setFields(@NotNull Field[] fieldArray) {
        Intrinsics.checkNotNullParameter((Object)fieldArray, (String)"<set-?>");
        this.fields = fieldArray;
    }

    @NotNull
    public final Field[] getStaticFields() {
        return this.staticFields;
    }

    public final void setStaticFields(@NotNull Field[] fieldArray) {
        Intrinsics.checkNotNullParameter((Object)fieldArray, (String)"<set-?>");
        this.staticFields = fieldArray;
    }

    public final int getInstanceSize() {
        return this.instanceSize;
    }

    public final void setInstanceSize(int n) {
        this.instanceSize = n;
    }

    @Override
    public boolean isSoftReference() {
        return this.isSoftReference;
    }

    public void setSoftReference(boolean bl) {
        this.isSoftReference = bl;
    }

    @NotNull
    public final TIntObjectHashMap<HeapData> getHeapData() {
        return this.heapData;
    }

    public final void setHeapData(@NotNull TIntObjectHashMap<HeapData> tIntObjectHashMap) {
        Intrinsics.checkNotNullParameter(tIntObjectHashMap, (String)"<set-?>");
        this.heapData = tIntObjectHashMap;
    }

    public final boolean addSubclass(@NotNull ClassObj subclass) {
        Intrinsics.checkNotNullParameter((Object)subclass, (String)"subclass");
        return this.subclasses.add(subclass);
    }

    @NotNull
    public final Set<ClassObj> getSubclasses() {
        return this.subclasses;
    }

    public final void dumpSubclasses() {
        for (ClassObj subclass : this.subclasses) {
            System.out.println((Object)("     " + subclass.className));
        }
    }

    @NotNull
    public String toString() {
        return StringsKt.replace$default((String)this.className, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    public final void addInstance(int heapId, @NotNull Instance instance) {
        HeapData heapData;
        HeapData heapData2;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (instance instanceof ClassInstance) {
            instance.setSize(this.instanceSize);
        }
        if ((heapData2 = (HeapData)this.heapData.get(heapId)) == null) {
            HeapData heapData3;
            HeapData it = heapData3 = new HeapData();
            boolean bl = false;
            this.heapData.put(heapId, (Object)it);
            heapData = heapData3;
        } else {
            heapData = heapData2;
        }
        HeapData data = heapData;
        data.getInstances().add(instance);
        data.setShallowSize(data.getShallowSize() + instance.getSize());
    }

    public final int getAllFieldsCount() {
        ClassObj classObj = this.getSuperClassObj();
        return this.fields.length + (classObj != null ? classObj.getAllFieldsCount() : 0);
    }

    public final int getShallowSize(int heapId) {
        HeapData heapData = (HeapData)this.heapData.get(heapId);
        return heapData != null ? heapData.getShallowSize() : 0;
    }

    public final void setIsSoftReference() {
        this.setSoftReference(true);
    }

    @NotNull
    public Map<Field, Object> getStaticFieldValues() {
        Map result = new HashMap();
        this.getBuffer().setPosition(this.staticFieldsOffset);
        int numEntries = this.readUnsignedShort();
        for (int i = 0; i < numEntries; ++i) {
            Field f = this.staticFields[i];
            this.readId();
            this.readUnsignedByte();
            Type type = f.getType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"f.type");
            Object value = this.readValue(type);
            result.put(f, value);
        }
        return result;
    }

    @Override
    public void resolveReferences() {
        for (Map.Entry<Field, Object> entry : this.getStaticFieldValues().entrySet()) {
            Field key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Instance)) continue;
            ((Instance)value).addReverseReference(key, this);
            this.set_hardFwdRefs-OLAdukE$android_sdktools_perflib(InstanceList.plus-GO6bYc0(this.get_hardFwdRefs-s3XpT2Q$android_sdktools_perflib(), (Instance)value));
        }
    }

    @Override
    public void accept(@NotNull Visitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitClassObj(this);
        for (Instance instance : this.getHardForwardReferences()) {
            visitor2.visitLater(this, instance);
        }
    }

    @Override
    public int compareTo(@NotNull ClassObj o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (this.getId() == o.getId()) {
            return 0;
        }
        int nameCompareResult = this.className.compareTo(o.className);
        return nameCompareResult != 0 ? nameCompareResult : (this.getId() - o.getId() > 0L ? 1 : -1);
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof ClassObj && this.compareTo((ClassObj)o) == 0;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Nullable
    public final Object getStaticField(@NotNull Type type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getStaticFieldValues().get(new Field(type, name));
    }

    @Nullable
    public final ClassObj getSuperClassObj() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        return heap.mSnapshot.findClass(this.superClassId);
    }

    @Nullable
    public final Instance getClassLoader() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        return heap.mSnapshot.findInstance(this.classLoaderId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Instance> getInstancesList() {
        void $this$flatMapTo$iv$iv;
        int[] nArray = this.heapData.keys();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"heapData.keys()");
        int[] $this$flatMap$iv = nArray;
        boolean $i$f$flatMap = false;
        int[] nArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void p0 = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = this.getHeapInstances((int)p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Instance> getHeapInstances(int heapId) {
        Object object = (HeapData)this.heapData.get(heapId);
        if (object == null || (object = ((HeapData)object).getInstances()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final int getHeapInstancesCount(int heapId) {
        Object object = (HeapData)this.heapData.get(heapId);
        return object != null && (object = ((HeapData)object).getInstances()) != null ? object.size() : 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getInstanceCount() {
        Object[] objectArray = this.heapData.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"heapData.values");
        Object[] objectArray2 = objectArray;
        int n = 0;
        int n2 = objectArray2.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            Object object;
            Object object2 = object = objectArray2[i];
            int n3 = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.android.tools.perflib.heap.ClassObj.HeapData");
            int n4 = ((HeapData)it).getInstances().size();
            n = n3 + n4;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getShallowSize() {
        Object[] objectArray = this.heapData.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"heapData.values");
        Object[] objectArray2 = objectArray;
        int n = 0;
        int n2 = objectArray2.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            Object object;
            Object object2 = object = objectArray2[i];
            int n3 = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.android.tools.perflib.heap.ClassObj.HeapData");
            int n4 = ((HeapData)it).getShallowSize();
            n = n3 + n4;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<ClassObj> getDescendantClasses() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object = new ClassObj[]{this};
        Sequence sequence = SequencesKt.sequenceOf((Object[])object);
        object = this.subclasses;
        Sequence sequence2 = sequence;
        boolean $i$f$flatMapSequence = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ClassObj it = (ClassObj)element$iv$iv;
            boolean bl = false;
            Sequence<ClassObj> list$iv$iv = it.getDescendantClasses();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/perflib/heap/ClassObj$HeapData;", "", "()V", "instances", "", "Lcom/android/tools/perflib/heap/Instance;", "getInstances", "()Ljava/util/List;", "setInstances", "(Ljava/util/List;)V", "shallowSize", "", "getShallowSize", "()I", "setShallowSize", "(I)V", "android.sdktools.perflib"})
    public static final class HeapData {
        private int shallowSize;
        @NotNull
        private List<Instance> instances = new ArrayList();

        public final int getShallowSize() {
            return this.shallowSize;
        }

        public final void setShallowSize(int n) {
            this.shallowSize = n;
        }

        @NotNull
        public final List<Instance> getInstances() {
            return this.instances;
        }

        public final void setInstances(@NotNull List<Instance> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.instances = list2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/perflib/heap/ClassObj$Companion;", "", "()V", "referenceClassName", "", "getReferenceClassName", "()Ljava/lang/String;", "android.sdktools.perflib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getReferenceClassName() {
            return "java.lang.ref.Reference";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

